/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.corext.codemanipulation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.references.TypeReference;
import org.eclipse.dltk.compiler.problem.DefaultProblem;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.compiler.problem.IProblemIdentifier;
import org.eclipse.dltk.core.Flags;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.core.SourceRange;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.index2.search.ModelAccess;
import org.eclipse.dltk.core.manipulation.SourceModuleChange;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.MethodNameMatch;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.core.search.TypeNameMatch;
import org.eclipse.dltk.ui.viewsupport.BasicElementLabels;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.IUndoManager;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.nodes.AST;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.FunctionName;
import org.eclipse.php.core.ast.nodes.IBinding;
import org.eclipse.php.core.ast.nodes.IMethodBinding;
import org.eclipse.php.core.ast.nodes.ITypeBinding;
import org.eclipse.php.core.ast.nodes.IVariableBinding;
import org.eclipse.php.core.ast.nodes.Identifier;
import org.eclipse.php.core.ast.nodes.NamespaceDeclaration;
import org.eclipse.php.core.ast.nodes.NamespaceName;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.core.ast.nodes.Scalar;
import org.eclipse.php.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.UseStatement;
import org.eclipse.php.core.ast.nodes.UseStatementPart;
import org.eclipse.php.core.ast.visitor.ApplyAll;
import org.eclipse.php.core.ast.visitor.Visitor;
import org.eclipse.php.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.core.compiler.ast.nodes.PHPDocTag;
import org.eclipse.php.core.compiler.ast.nodes.PHPModuleDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.VarComment;
import org.eclipse.php.internal.core.ast.locator.PHPElementConciliator;
import org.eclipse.php.internal.core.ast.rewrite.ImportRewrite;
import org.eclipse.php.internal.core.compiler.ast.parser.PHPProblemIdentifier;
import org.eclipse.php.internal.core.search.FieldNameMatch;
import org.eclipse.php.internal.core.search.IElementNameMatch;
import org.eclipse.php.internal.core.search.PHPSearchFieldNameMatch;
import org.eclipse.php.internal.core.search.PHPSearchMethodNameMatch;
import org.eclipse.php.internal.core.search.PHPSearchTypeNameMatch;
import org.eclipse.php.internal.core.typeinference.PHPSimpleTypes;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.corext.codemanipulation.CodeGenerationMessages;
import org.eclipse.php.internal.ui.corext.util.FieldNameMatchCollector;
import org.eclipse.php.internal.ui.corext.util.Messages;
import org.eclipse.php.internal.ui.corext.util.MethodNameMatchCollector;
import org.eclipse.php.internal.ui.corext.util.TypeNameMatchCollector;
import org.eclipse.php.internal.ui.text.correction.ASTResolving;
import org.eclipse.php.internal.ui.text.correction.ProblemLocation;
import org.eclipse.php.ui.editor.SharedASTProvider;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;

public class OrganizeUseStatementsOperation
implements IWorkspaceRunnable {
    private static ImportRewrite.ImportRewriteContext UNRESOLVABLE_IMPORT_CONTEXT = new ImportRewrite.ImportRewriteContext(){

        public int findInContext(NamespaceDeclaration namespace, String qualifier, String name, int kind) {
            return 2;
        }
    };
    private int fNumberOfImportsAdded;
    private int fNumberOfImportsRemoved;
    private IChooseImportQuery fChooseImportQuery;
    private ISourceModule fSourceModule;
    private Program fASTRoot;

    public OrganizeUseStatementsOperation(ISourceModule sourceModule, Program astRoot, IChooseImportQuery chooseImportQuery) {
        this.fSourceModule = sourceModule;
        this.fASTRoot = astRoot;
        this.fChooseImportQuery = chooseImportQuery;
        this.fNumberOfImportsAdded = 0;
        this.fNumberOfImportsRemoved = 0;
    }

    public TextEdit createTextEdit(IProgressMonitor monitor) throws CoreException, OperationCanceledException, IOException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            this.fNumberOfImportsAdded = 0;
            this.fNumberOfImportsRemoved = 0;
            monitor.beginTask(Messages.format(CodeGenerationMessages.OrganizeImportsOperation_description, BasicElementLabels.getFileName((ISourceModule)this.fSourceModule)), 9);
            Program astRoot = this.fASTRoot;
            if (astRoot == null) {
                astRoot = SharedASTProvider.getAST(this.fSourceModule, SharedASTProvider.WAIT_YES, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)2));
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
            } else {
                monitor.worked(2);
            }
            ImportRewrite importsRewrite = ImportRewrite.create((Program)astRoot, (boolean)false);
            ArrayList<ASTNode> elementReferences = new ArrayList<ASTNode>();
            HashMap<NamespaceDeclaration, Set<String>> oldSingleImports = new HashMap<NamespaceDeclaration, Set<String>>();
            if (!this.collectReferences(astRoot, elementReferences, oldSingleImports)) {
                return null;
            }
            UnresolvableImportMatcher unresolvableImportMatcher = UnresolvableImportMatcher.forProgram(astRoot);
            ElementReferenceProcessor processor = new ElementReferenceProcessor(oldSingleImports, astRoot, importsRewrite, unresolvableImportMatcher);
            for (ASTNode elementRef : elementReferences) {
                processor.add(elementRef);
            }
            Map<NamespaceDeclaration, Boolean> hasOpenChoices = processor.process((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)3));
            if (this.fChooseImportQuery != null) {
                Map<NamespaceDeclaration, IElementNameMatch[][]> choices = processor.getChoices();
                Map<NamespaceDeclaration, SourceRange[]> ranges = processor.getChoicesSourceRanges();
                for (Map.Entry<NamespaceDeclaration, Boolean> entry : hasOpenChoices.entrySet()) {
                    NamespaceDeclaration namespace = entry.getKey();
                    if (!entry.getValue().booleanValue()) continue;
                    IElementNameMatch[] chosen = this.fChooseImportQuery.chooseImports(choices.get(namespace), (ISourceRange[])ranges.get(namespace));
                    if (chosen == null) {
                        return null;
                    }
                    int i = 0;
                    while (i < chosen.length) {
                        IElementNameMatch elementInfo = chosen[i];
                        if (elementInfo != null) {
                            int importKind = 1;
                            if (elementInfo.getElementType() == 2) {
                                importKind = 3;
                                if (StringUtils.isBlank((CharSequence)elementInfo.getContainerName())) {
                                    return null;
                                }
                            } else if (elementInfo.getElementType() == 3) {
                                importKind = 2;
                                if (StringUtils.isBlank((CharSequence)elementInfo.getContainerName())) {
                                    return null;
                                }
                            }
                            importsRewrite.addImport(namespace, elementInfo.getFullyQualifiedName(), importKind);
                        } else {
                            String elementName = choices.get(namespace)[i][0].getSimpleName();
                            Set<String> matchingUnresolvableImports = unresolvableImportMatcher.matchElementImports(namespace, elementName);
                            if (!matchingUnresolvableImports.isEmpty()) {
                                for (String string : matchingUnresolvableImports) {
                                    importsRewrite.addImport(namespace, string, UNRESOLVABLE_IMPORT_CONTEXT);
                                }
                            }
                        }
                        ++i;
                    }
                }
            }
            TextEdit result = importsRewrite.rewriteImports((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)3));
            this.determineImportDifferences(importsRewrite, oldSingleImports.values());
            TextEdit textEdit = result;
            return textEdit;
        }
        catch (Exception e) {
            PHPUiPlugin.log(e);
        }
        finally {
            monitor.done();
        }
        return null;
    }

    private void determineImportDifferences(ImportRewrite importsStructure, Collection<Set<String>> oldSingleImportsCollection) {
        ArrayList<String> importsAdded = new ArrayList<String>();
        importsAdded.addAll(Arrays.asList(importsStructure.getCreatedImports()));
        for (Set<String> oldSingleImports : oldSingleImportsCollection) {
            Object[] content = oldSingleImports.toArray();
            int i = 0;
            while (i < content.length) {
                String importName = (String)content[i];
                if (importsAdded.remove(importName)) {
                    oldSingleImports.remove(importName);
                }
                ++i;
            }
            this.fNumberOfImportsRemoved += oldSingleImports.size();
        }
        this.fNumberOfImportsAdded = importsAdded.size();
    }

    public void run(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            try {
                Change undoChange;
                monitor.beginTask(Messages.format(CodeGenerationMessages.OrganizeImportsOperation_description, BasicElementLabels.getFileName((ISourceModule)this.fSourceModule)), 10);
                SourceModuleChange cuChange = new SourceModuleChange("OrganizeUseStatements", this.fSourceModule);
                cuChange.setSaveMode(4);
                SourceModuleChange change = cuChange;
                TextEdit edit = this.createTextEdit((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor));
                if (edit != null) {
                    change.setEdit(edit);
                }
                change.initializeValidationData((IProgressMonitor)new NullProgressMonitor());
                RefactoringStatus valid = change.isValid((IProgressMonitor)new NullProgressMonitor());
                if (valid.hasFatalError()) {
                    Status status = new Status(4, "org.eclipse.php.ui", 4, valid.getMessageMatchingSeverity(4), null);
                    throw new CoreException((IStatus)status);
                }
                IUndoManager manager = RefactoringCore.getUndoManager();
                boolean successful = false;
                try {
                    manager.aboutToPerformChange((Change)change);
                    undoChange = change.perform((IProgressMonitor)new NullProgressMonitor());
                    successful = true;
                }
                finally {
                    manager.changePerformed((Change)change, successful);
                }
                if (undoChange != null) {
                    undoChange.initializeValidationData((IProgressMonitor)new NullProgressMonitor());
                    manager.addUndo("OrganizeUseStatements", undoChange);
                }
            }
            catch (IOException | MalformedTreeException e) {
                PHPUiPlugin.log(e);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    private boolean collectReferences(Program astRoot, List<ASTNode> elementReferences, Map<NamespaceDeclaration, Set<String>> oldSingleImports) {
        List namespaces = astRoot.getNamespaceDeclarations();
        if (namespaces.size() > 0) {
            for (NamespaceDeclaration namespace : namespaces) {
                this.collectImports(astRoot, namespace, oldSingleImports);
            }
        } else {
            this.collectImports(astRoot, null, oldSingleImports);
        }
        astRoot.accept((Visitor)new ReferencesCollector(elementReferences));
        return true;
    }

    private void collectImports(Program astRoot, NamespaceDeclaration namespace, Map<NamespaceDeclaration, Set<String>> oldSingleImports) {
        oldSingleImports.put(namespace, new HashSet());
        List imports = astRoot.getUseStatements(namespace);
        int i = 0;
        while (i < imports.size()) {
            UseStatement curr = (UseStatement)imports.get(i);
            for (UseStatementPart part : curr.parts()) {
                String importName = part.getFullUseStatementName();
                if (part.getAlias() != null) {
                    importName = String.valueOf(importName) + " as " + part.getAlias().getName();
                }
                oldSingleImports.get(namespace).add(importName);
            }
            ++i;
        }
    }

    public int getNumberOfImportsAdded() {
        return this.fNumberOfImportsAdded;
    }

    public int getNumberOfImportsRemoved() {
        return this.fNumberOfImportsRemoved;
    }

    public ISchedulingRule getScheduleRule() {
        return this.fSourceModule.getResource();
    }

    private static class ElementReferenceProcessor {
        private Map<NamespaceDeclaration, Set<String>> fOldSingleImports;
        private ImportRewrite fImpStructure;
        private final UnresolvableImportMatcher fUnresolvableImportMatcher;
        private Map<NamespaceDeclaration, Map<String, UnresolvedElementData>> fUnresolvedTypes = new HashMap<NamespaceDeclaration, Map<String, UnresolvedElementData>>();
        private Map<NamespaceDeclaration, Set<String>> fImportsAdded = new HashMap<NamespaceDeclaration, Set<String>>();
        private Map<NamespaceDeclaration, IElementNameMatch[][]> fOpenChoices = new HashMap<NamespaceDeclaration, IElementNameMatch[][]>();
        private Map<NamespaceDeclaration, SourceRange[]> fSourceRanges = new HashMap<NamespaceDeclaration, SourceRange[]>();
        private Program fRoot;

        public ElementReferenceProcessor(Map<NamespaceDeclaration, Set<String>> oldSingleImports, Program root, ImportRewrite impStructure, UnresolvableImportMatcher unresolvableImportMatcher) {
            this.fRoot = root;
            this.fOldSingleImports = oldSingleImports;
            this.fImpStructure = impStructure;
            this.fUnresolvableImportMatcher = unresolvableImportMatcher;
            List namespaces = root.getNamespaceDeclarations();
            if (namespaces.size() > 0) {
                for (NamespaceDeclaration namespace : namespaces) {
                    this.fImportsAdded.put(namespace, new HashSet());
                    this.fUnresolvedTypes.put(namespace, new HashMap());
                }
            } else {
                this.fImportsAdded.put(null, new HashSet());
                this.fUnresolvedTypes.put(null, new HashMap());
            }
        }

        public void add(ASTNode ref) {
            NamespaceDeclaration namespace = this.fRoot.getNamespaceDeclaration(ref.getStart());
            String elementName = null;
            IBinding binding = null;
            if (ref instanceof Identifier) {
                elementName = ((Identifier)ref).getName();
                binding = ((Identifier)ref).resolveBinding();
            } else if (ref instanceof Scalar) {
                elementName = ((Scalar)ref).getStringValue();
                binding = ((Scalar)ref).resolveBinding();
            } else {
                return;
            }
            String importName = elementName;
            int index = elementName.indexOf("\\");
            if (index > 0) {
                importName = elementName.substring(0, index);
                elementName = elementName.substring(index + 1);
            }
            if (this.fImportsAdded.get(namespace) == null || this.fImportsAdded.get(namespace).contains(importName)) {
                return;
            }
            if (binding != null) {
                ITypeBinding typeBinding = null;
                int bindingKind = binding.getKind();
                switch (bindingKind) {
                    case 2: {
                        typeBinding = ((ITypeBinding)binding).getTypeDeclaration();
                        break;
                    }
                    case 4: {
                        typeBinding = ((IMethodBinding)binding).getDeclaringClass();
                        if (typeBinding != null) break;
                        return;
                    }
                    case 3: {
                        typeBinding = ((IVariableBinding)binding).getDeclaringClass();
                        if (typeBinding != null) break;
                        return;
                    }
                    default: {
                        return;
                    }
                }
                if (typeBinding != null) {
                    String alias = null;
                    String typeBindingName = typeBinding.getName();
                    int importKind = 1;
                    if (typeBindingName != null) {
                        int indexOfNs;
                        if (typeBindingName.startsWith("\\")) {
                            typeBindingName = typeBindingName.substring(1);
                        }
                        if (bindingKind == 4 || bindingKind == 3) {
                            if (importName.equalsIgnoreCase(elementName)) {
                                switch (bindingKind) {
                                    case 4: {
                                        importKind = 3;
                                        break;
                                    }
                                    case 3: {
                                        importKind = 2;
                                    }
                                }
                            }
                            typeBindingName = String.valueOf(typeBindingName) + "\\" + binding.getName();
                        }
                        if ((indexOfNs = typeBindingName.lastIndexOf(elementName)) > 0 && !importName.equalsIgnoreCase(elementName) && (typeBindingName = typeBindingName.substring(0, indexOfNs)).endsWith("\\")) {
                            typeBindingName = typeBindingName.substring(0, typeBindingName.length() - 1);
                        }
                        String lastSeg = typeBindingName;
                        String[] segs = typeBindingName.split("\\\\");
                        if (segs.length > 0) {
                            lastSeg = segs[segs.length - 1];
                        }
                        if (!lastSeg.equalsIgnoreCase(importName)) {
                            alias = importName;
                        }
                    }
                    this.fImpStructure.addImport(namespace, typeBindingName, alias, importKind);
                    this.fImportsAdded.get(namespace).add(importName);
                    return;
                }
            }
            this.fImportsAdded.get(namespace).add(elementName);
            this.fUnresolvedTypes.get(namespace).put(elementName, new UnresolvedElementData(ref));
        }

        public Map<NamespaceDeclaration, Boolean> process(IProgressMonitor monitor) {
            HashMap<NamespaceDeclaration, Boolean> hasOpenChoices = new HashMap<NamespaceDeclaration, Boolean>();
            try {
                try {
                    IScriptProject project = this.fImpStructure.getSourceModule().getScriptProject();
                    IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)project);
                    List namespaces = this.fRoot.getNamespaceDeclarations();
                    if (namespaces.size() > 0) {
                        for (NamespaceDeclaration namespace : namespaces) {
                            hasOpenChoices.put(namespace, this.internalProcess(namespace, scope, monitor));
                        }
                    } else {
                        hasOpenChoices.put(null, this.internalProcess(null, scope, monitor));
                    }
                }
                catch (Exception e) {
                    PHPUiPlugin.log(e);
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
            return hasOpenChoices;
        }

        private boolean internalProcess(NamespaceDeclaration namespace, IDLTKSearchScope scope, IProgressMonitor monitor) throws ModelException {
            int nUnresolved = this.fUnresolvedTypes.get(namespace).size();
            if (nUnresolved == 0) {
                return false;
            }
            ArrayList<IElementNameMatch> typesFound = new ArrayList<IElementNameMatch>();
            ArrayList<IElementNameMatch> methodsFound = new ArrayList<IElementNameMatch>();
            ArrayList<IElementNameMatch> fieldsFound = new ArrayList<IElementNameMatch>();
            for (String key : this.fUnresolvedTypes.get(namespace).keySet()) {
                IField[] fields;
                Object collector;
                PHPSearchTypeNameMatch match;
                int n;
                int typeKind = this.fUnresolvedTypes.get((Object)namespace).get((Object)key).typeKinds;
                ModelAccess modelAccess = new ModelAccess();
                if (typeKind == 6) {
                    TypeNameMatchCollector collector2 = new TypeNameMatchCollector(typesFound);
                    IType[] types = modelAccess.findTypes(key, ISearchEngine.MatchRule.EXACT, 0, 0, scope, monitor);
                    if (types == null) continue;
                    IType[] iTypeArray = types;
                    int n2 = types.length;
                    n = 0;
                    while (n < n2) {
                        IType type = iTypeArray[n];
                        match = new PHPSearchTypeNameMatch(type, type.getFlags());
                        collector2.acceptTypeNameMatch((TypeNameMatch)match);
                        ++n;
                    }
                    continue;
                }
                if (typeKind == 8) {
                    IMethod[] methods = modelAccess.findMethods(key, ISearchEngine.MatchRule.EXACT, 0, 0, scope, monitor);
                    if (methods == null) continue;
                    IMethod[] iMethodArray = methods;
                    n = methods.length;
                    int type = 0;
                    while (type < n) {
                        IMethod method = iMethodArray[type];
                        collector = new MethodNameMatchCollector(methodsFound);
                        match = new PHPSearchMethodNameMatch(method, method.getFlags());
                        ((MethodNameMatchCollector)((Object)collector)).acceptMethodNameMatch((MethodNameMatch)match);
                        ++type;
                    }
                    continue;
                }
                if (typeKind != 16 || (fields = modelAccess.findFields(key, ISearchEngine.MatchRule.EXACT, 0, 0, scope, monitor)) == null) continue;
                IField[] iFieldArray = fields;
                n = fields.length;
                int type = 0;
                while (type < n) {
                    IField field = iFieldArray[type];
                    collector = new FieldNameMatchCollector(fieldsFound);
                    match = new PHPSearchFieldNameMatch(field, field.getFlags());
                    ((FieldNameMatchCollector)((Object)collector)).acceptFieldNameMatch((FieldNameMatch)match);
                    ++type;
                }
            }
            ArrayList<IElementNameMatch> elementsFound = new ArrayList<IElementNameMatch>();
            elementsFound.addAll(typesFound);
            elementsFound.addAll(methodsFound);
            elementsFound.addAll(fieldsFound);
            int i = 0;
            while (i < elementsFound.size()) {
                IElementNameMatch curr = (IElementNameMatch)elementsFound.get(i);
                UnresolvedElementData data = this.fUnresolvedTypes.get(namespace).get(curr.getSimpleName());
                if (data != null && this.isOfKind(curr, data.typeKinds)) {
                    data.addInfo(curr);
                }
                ++i;
            }
            for (Map.Entry<String, UnresolvedElementData> entry : this.fUnresolvedTypes.get(namespace).entrySet()) {
                Set<String> matchingUnresolvableImports;
                if (entry.getValue().foundElementInfos.size() != 0 || (matchingUnresolvableImports = this.fUnresolvableImportMatcher.matchElementImports(namespace, entry.getKey())).isEmpty()) continue;
                for (String string : matchingUnresolvableImports) {
                    char prefix = string.charAt(0);
                    int importKind = 1;
                    switch (prefix) {
                        case 'f': {
                            importKind = 3;
                            break;
                        }
                        case 'c': {
                            importKind = 2;
                        }
                    }
                    string = string.substring(1);
                    this.fImpStructure.addImport(namespace, string, null, importKind, UNRESOLVABLE_IMPORT_CONTEXT);
                }
            }
            ArrayList<IElementNameMatch[]> openChoices = new ArrayList<IElementNameMatch[]>(nUnresolved);
            ArrayList<SourceRange> sourceRanges = new ArrayList<SourceRange>(nUnresolved);
            for (UnresolvedElementData data : this.fUnresolvedTypes.get(namespace).values()) {
                IElementNameMatch[] openChoice = this.processElementInfo(namespace, data.foundElementInfos);
                if (openChoice == null) continue;
                openChoices.add(openChoice);
                sourceRanges.add(new SourceRange(data.ref.getStart(), data.ref.getLength()));
            }
            if (openChoices.isEmpty()) {
                return false;
            }
            this.fOpenChoices.put(namespace, (IElementNameMatch[][])openChoices.toArray((T[])new IElementNameMatch[openChoices.size()][]));
            this.fSourceRanges.put(namespace, sourceRanges.toArray(new SourceRange[sourceRanges.size()]));
            return true;
        }

        private IElementNameMatch[] processElementInfo(NamespaceDeclaration namespace, List<IElementNameMatch> elementRefsFound) {
            int nFound = elementRefsFound.size();
            if (nFound == 0) {
                return null;
            }
            if (nFound == 1) {
                IElementNameMatch elementRef = elementRefsFound.get(0);
                int importKind = 1;
                if (elementRef instanceof MethodNameMatch) {
                    importKind = 3;
                    if (StringUtils.isBlank((CharSequence)elementRef.getContainerName())) {
                        return null;
                    }
                } else if (elementRef instanceof FieldNameMatch) {
                    importKind = 2;
                    if (StringUtils.isBlank((CharSequence)elementRef.getContainerName())) {
                        return null;
                    }
                }
                this.fImpStructure.addImport(namespace, elementRef.getFullyQualifiedName(), importKind);
                return null;
            }
            int i = 0;
            while (i < nFound) {
                IElementNameMatch elementRef = elementRefsFound.get(i);
                int importKind = 1;
                if (elementRef instanceof MethodNameMatch) {
                    importKind = 3;
                } else if (elementRef instanceof FieldNameMatch) {
                    importKind = 2;
                }
                String fullName = elementRef.getFullyQualifiedName();
                if (this.fOldSingleImports.get(namespace).contains(fullName)) {
                    this.fImpStructure.addImport(namespace, fullName, importKind);
                    return null;
                }
                ++i;
            }
            return elementRefsFound.toArray(new IElementNameMatch[nFound]);
        }

        private boolean isOfKind(IElementNameMatch curr, int typeKinds) {
            int flags = curr.getModifiers();
            if (Flags.isInterface((int)flags)) {
                return (typeKinds & 4) != 0;
            }
            if (curr.getElementType() == 2) {
                return (typeKinds & 8) != 0;
            }
            if (curr.getElementType() == 3) {
                return (typeKinds & 0x10) != 0;
            }
            return (typeKinds & 2) != 0;
        }

        public Map<NamespaceDeclaration, IElementNameMatch[][]> getChoices() {
            return this.fOpenChoices;
        }

        public Map<NamespaceDeclaration, SourceRange[]> getChoicesSourceRanges() {
            return this.fSourceRanges;
        }

        private static class UnresolvedElementData {
            final ASTNode ref;
            final int typeKinds;
            final List<IElementNameMatch> foundElementInfos;

            public UnresolvedElementData(ASTNode ref) {
                this.ref = ref;
                this.typeKinds = ASTResolving.getPossibleElementKinds(ref);
                this.foundElementInfos = new ArrayList<IElementNameMatch>(3);
            }

            public void addInfo(IElementNameMatch info) {
                int i = this.foundElementInfos.size() - 1;
                while (i >= 0) {
                    IElementNameMatch curr = this.foundElementInfos.get(i);
                    if (curr.getContainerName().equals(info.getContainerName())) {
                        return;
                    }
                    --i;
                }
                this.foundElementInfos.add(info);
            }
        }
    }

    public static interface IChooseImportQuery {
        public IElementNameMatch[] chooseImports(IElementNameMatch[][] var1, ISourceRange[] var2);
    }

    static class ReferencesCollector
    extends ApplyAll {
        private static final List<String> TYPE_SKIP = new ArrayList<String>();
        private static final Pattern CONSTANT_NAME = Pattern.compile("[a-zA-Z_\\x7f-\\xff][a-zA-Z0-9_\\x7f-\\xff]*");
        private static final List<NamespaceDeclaration> reversedNamespaceDeclarations = new ArrayList<NamespaceDeclaration>();
        List<ASTNode> fElementReferences;

        static {
            TYPE_SKIP.add("parent");
            TYPE_SKIP.add("self");
            TYPE_SKIP.add("static");
            TYPE_SKIP.add("class");
        }

        public ReferencesCollector(List<ASTNode> elementReferences) {
            this.fElementReferences = elementReferences;
        }

        private NamespaceName createNamespaceName(int start, int end, AST ast, String className, Program program) {
            ArrayList<Identifier> segments = new ArrayList<Identifier>();
            String[] names = className.split(Pattern.quote("\\"));
            boolean global = names[0].length() == 0;
            int pos = start;
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                if (name.length() == 0) {
                    ++pos;
                } else {
                    int nextPos = pos + name.length();
                    segments.add(new Identifier(pos, nextPos, ast, name));
                    pos = nextPos + 1;
                }
                ++n2;
            }
            NamespaceName n3 = new NamespaceName(start, end, ast, segments, global, false);
            boolean foundNamespaceDeclaration = false;
            for (NamespaceDeclaration namespaceDeclaration : reversedNamespaceDeclarations) {
                if (namespaceDeclaration.getBody().getStart() > n3.getStart()) continue;
                foundNamespaceDeclaration = true;
                n3.setParent((ASTNode)namespaceDeclaration, (StructuralPropertyDescriptor)NamespaceDeclaration.BODY_PROPERTY);
                break;
            }
            if (!foundNamespaceDeclaration) {
                n3.setParent((ASTNode)program, (StructuralPropertyDescriptor)Program.COMMENTS_PROPERTY);
            }
            return n3;
        }

        public boolean visit(NamespaceDeclaration decl) {
            reversedNamespaceDeclarations.add(decl);
            return true;
        }

        public void endVisit(Program program) {
            if (program.getAST() == null || program.getAST().apiLevel().isLessThan(PHPVersion.PHP5_3)) {
                return;
            }
            reversedNamespaceDeclarations.sort(new Comparator<NamespaceDeclaration>(){

                @Override
                public int compare(NamespaceDeclaration o1, NamespaceDeclaration o2) {
                    return o2.getStart() - o1.getStart();
                }
            });
            ISourceModule sourceModule = program.getSourceModule();
            ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule, null);
            if (moduleDeclaration instanceof PHPModuleDeclaration) {
                int n;
                int n2;
                PHPDocTag[] pHPDocTagArray;
                for (PHPDocBlock docBlock : ((PHPModuleDeclaration)moduleDeclaration).getPHPDocBlocks()) {
                    pHPDocTagArray = docBlock.getTags();
                    n2 = pHPDocTagArray.length;
                    n = 0;
                    while (n < n2) {
                        PHPDocTag tag = pHPDocTagArray[n];
                        for (TypeReference reference : tag.getTypeReferences()) {
                            this.visitComment(this.createNamespaceName(reference.start(), reference.end(), program.getAST(), reference.getStringRepresentation(), program));
                        }
                        ++n;
                    }
                }
                for (VarComment varComment : ((PHPModuleDeclaration)moduleDeclaration).getVarComments()) {
                    pHPDocTagArray = varComment.getTypeReferences();
                    n2 = pHPDocTagArray.length;
                    n = 0;
                    while (n < n2) {
                        PHPDocTag reference = pHPDocTagArray[n];
                        this.visitComment(this.createNamespaceName(reference.start(), reference.end(), program.getAST(), reference.getStringRepresentation(), program));
                        ++n;
                    }
                }
            }
        }

        protected boolean apply(ASTNode node) {
            return true;
        }

        public boolean visit(UseStatement statement) {
            return false;
        }

        public boolean visit(NamespaceName name) {
            if (!name.isGlobal() && !(name.getParent() instanceof NamespaceDeclaration)) {
                Identifier node;
                if (PHPSimpleTypes.isHintable((String)name.getName(), (PHPVersion)name.getAST().apiLevel()) || TYPE_SKIP.contains(name.getName())) {
                    return false;
                }
                List segs = name.segments();
                if (segs.size() > 0 && (PHPElementConciliator.concile((ASTNode)(node = (Identifier)segs.get(segs.size() - 1))) == 4 || PHPElementConciliator.concile((ASTNode)node) == 8 || PHPElementConciliator.concile((ASTNode)node) == 5)) {
                    this.fElementReferences.add((ASTNode)name);
                }
            }
            return false;
        }

        private void visitComment(NamespaceName name) {
            if (!name.isGlobal()) {
                if (PHPSimpleTypes.isHintable((String)name.getName(), (PHPVersion)name.getAST().apiLevel()) || TYPE_SKIP.contains(name.getName())) {
                    return;
                }
                List segs = name.segments();
                if (segs.size() > 0) {
                    this.fElementReferences.add((ASTNode)name);
                }
            }
        }

        public boolean visit(FunctionName functionName) {
            NamespaceName name;
            if (functionName.getName() instanceof NamespaceName && !(name = (NamespaceName)functionName.getName()).isGlobal()) {
                this.fElementReferences.add((ASTNode)name);
            }
            return false;
        }

        public boolean visit(Scalar scalar) {
            if (scalar.getScalarType() == 2 && CONSTANT_NAME.matcher(scalar.getStringValue()).matches()) {
                this.fElementReferences.add((ASTNode)scalar);
            }
            return false;
        }
    }

    private static class UnresolvableImportMatcher {
        private static final char FUNCTION_PREFIX = 'f';
        private static final char CONSTANT_PREFIX = 'c';
        private static final char NORMAL_PREFIX = 'n';
        private final Map<NamespaceDeclaration, Map<String, Set<String>>> fElementImportsBySimpleName;

        static UnresolvableImportMatcher forProgram(Program cu) {
            HashMap<NamespaceDeclaration, Map<String, Set<String>>> elementImportsBySimpleName = new HashMap<NamespaceDeclaration, Map<String, Set<String>>>();
            List namespaces = cu.getNamespaceDeclarations();
            if (namespaces.size() > 0) {
                for (NamespaceDeclaration namespace : namespaces) {
                    UnresolvableImportMatcher.forProgram(cu, namespace, elementImportsBySimpleName);
                }
            } else {
                UnresolvableImportMatcher.forProgram(cu, null, elementImportsBySimpleName);
            }
            return new UnresolvableImportMatcher(elementImportsBySimpleName);
        }

        private static void forProgram(Program cu, NamespaceDeclaration namespace, Map<NamespaceDeclaration, Map<String, Set<String>>> typeImportsBySimpleName) {
            typeImportsBySimpleName.put(namespace, new HashMap());
            Collection<UseStatement> unresolvableImports = UnresolvableImportMatcher.determineUnresolvableImports(cu, namespace);
            for (UseStatement importDeclaration : unresolvableImports) {
                char prefix = 'n';
                if (importDeclaration.getStatementType() == 1) {
                    prefix = 'f';
                } else if (importDeclaration.getStatementType() == 2) {
                    prefix = 'c';
                }
                for (UseStatementPart part : importDeclaration.parts()) {
                    if (part.getStatementType() == 1) {
                        prefix = 'f';
                    } else if (part.getStatementType() == 2) {
                        prefix = 'c';
                    }
                    String qualifiedName = part.getFullUseStatementName();
                    String simpleName = qualifiedName.substring(qualifiedName.lastIndexOf(92) + 1);
                    Map<String, Set<String>> importsBySimpleName = typeImportsBySimpleName.get(namespace);
                    Set<String> importsWithSimpleName = importsBySimpleName.get(simpleName);
                    if (importsWithSimpleName == null) {
                        importsWithSimpleName = new HashSet<String>();
                        importsBySimpleName.put(simpleName, importsWithSimpleName);
                    }
                    importsWithSimpleName.add(String.valueOf(prefix) + qualifiedName);
                }
            }
        }

        private static Collection<UseStatement> determineUnresolvableImports(Program program, NamespaceDeclaration namespaceDeclaration) {
            IProblem[] problems;
            ArrayList<UseStatement> unresolvableImports = new ArrayList<UseStatement>(program.getUseStatements(namespaceDeclaration).size());
            IProblem[] iProblemArray = problems = program.getProblems();
            int n = problems.length;
            int n2 = 0;
            while (n2 < n) {
                UseStatement problematicImport;
                IProblem problem = iProblemArray[n2];
                IProblemIdentifier id = ((DefaultProblem)problem).getID();
                if (id == PHPProblemIdentifier.ImportNotFound && (problematicImport = UnresolvableImportMatcher.getProblematicImport(problem, program)) != null && program.getNamespaceDeclaration(problematicImport.getStart()) == namespaceDeclaration) {
                    unresolvableImports.add(problematicImport);
                }
                ++n2;
            }
            return unresolvableImports;
        }

        private static UseStatement getProblematicImport(IProblem problem, Program cu) {
            ASTNode coveringNode = new ProblemLocation(problem).getCoveringNode(cu);
            if (coveringNode != null && coveringNode instanceof UseStatement) {
                return (UseStatement)coveringNode;
            }
            return null;
        }

        private UnresolvableImportMatcher(Map<NamespaceDeclaration, Map<String, Set<String>>> elementImportsBySimpleName) {
            this.fElementImportsBySimpleName = elementImportsBySimpleName;
        }

        private Set<String> matchImports(NamespaceDeclaration namespace, String simpleName) {
            Map<String, Set<String>> importsBySimpleName = this.fElementImportsBySimpleName.get(namespace);
            Set<String> matchingSingleImports = importsBySimpleName.get(simpleName);
            if (matchingSingleImports != null) {
                return Collections.unmodifiableSet(matchingSingleImports);
            }
            return Collections.emptySet();
        }

        Set<String> matchElementImports(NamespaceDeclaration namespace, String simpleName) {
            return this.matchImports(namespace, simpleName);
        }
    }
}

