/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.etfw;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.ptp.etfw.ETFWUtils;
import org.eclipse.ptp.etfw.IBuildLaunchUtils;
import org.eclipse.ptp.etfw.toolopts.BuildTool;
import org.eclipse.ptp.etfw.toolopts.ExecTool;
import org.eclipse.ptp.etfw.toolopts.ExternalToolProcess;
import org.eclipse.ptp.etfw.toolopts.PostProcTool;
import org.eclipse.ptp.internal.etfw.BuildLaunchUtils;
import org.eclipse.ptp.internal.etfw.BuilderTool;
import org.eclipse.ptp.internal.etfw.ILaunchFactory;
import org.eclipse.ptp.internal.etfw.LauncherTool;
import org.eclipse.ptp.internal.etfw.PostlaunchTool;
import org.eclipse.ptp.internal.etfw.ToolStep;
import org.eclipse.ptp.internal.etfw.messages.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParametricToolLaunchManager {
    private static final String NUMBER_MPI_PROCS = "org.eclipse.ptp.rm.mpi.openmpi.ui.launchAttributes.numProcs";

    static List<String> getComArgs(String combined) {
        ArrayList<String> numProcesses = new ArrayList<String>();
        if (combined == null) {
            return numProcesses;
        }
        StringTokenizer st = new StringTokenizer(combined, ",");
        while (st.hasMoreTokens()) {
            numProcesses.add(st.nextToken());
        }
        return numProcesses;
    }

    static List<Map<String, String>> getComboMaps(List<List<StringPair>> combos) {
        ArrayList<Map<String, String>> allCom = new ArrayList<Map<String, String>>();
        for (List<StringPair> sl : combos) {
            LinkedHashMap<String, String> agg = new LinkedHashMap<String, String>();
            for (StringPair sp : sl) {
                agg.put(sp.first, sp.second);
            }
            allCom.add(agg);
        }
        return allCom;
    }

    static List<String> getComboStrings(List<List<StringPair>> combos) {
        ArrayList<String> allCom = new ArrayList<String>();
        for (List<StringPair> sl : combos) {
            String agg = "";
            for (StringPair sp : sl) {
                agg = String.valueOf(agg) + sp.first + sp.second + " ";
            }
            allCom.add(agg);
        }
        return allCom;
    }

    static List<List<StringPair>> getListCombinations(List<String> a, List<String> b) {
        ArrayList<List<StringPair>> comCom = new ArrayList<List<StringPair>>();
        if (a.size() != b.size()) {
            return comCom;
        }
        int i = 0;
        while (i < a.size()) {
            comCom.add(ParametricToolLaunchManager.getStringCombinations(a.get(i), b.get(i)));
            ++i;
        }
        return comCom;
    }

    static List<RunParams> getRunParams(String procs, List<String> argNames, List<String> argVars, List<String> argBools, List<String> envNames, List<String> envVars, List<String> envBools) {
        ArrayList<RunParams> params = new ArrayList<RunParams>();
        List<String> numProcs = ParametricToolLaunchManager.getComArgs(procs);
        ArrayList<StringPair> checkedArgs = new ArrayList<StringPair>();
        int i = 0;
        while (i < argBools.size()) {
            if (argBools.get(i).equals("1")) {
                argBools.remove(i);
                checkedArgs.add(new StringPair(argNames.remove(i), argVars.remove(i)));
                continue;
            }
            ++i;
        }
        ArrayList<StringPair> checkedVars = new ArrayList<StringPair>();
        i = 0;
        while (i < envBools.size()) {
            if (envBools.get(i).equals("1")) {
                envBools.remove(i);
                checkedVars.add(new StringPair(envNames.remove(i), envVars.remove(i)));
                continue;
            }
            ++i;
        }
        List<String> args = ParametricToolLaunchManager.getComboStrings(ParametricToolLaunchManager.unifyCombos(ParametricToolLaunchManager.getListCombinations(argNames, argVars), 0));
        List<Map<String, String>> vars = ParametricToolLaunchManager.getComboMaps(ParametricToolLaunchManager.unifyCombos(ParametricToolLaunchManager.getListCombinations(envNames, envVars), 0));
        if (args.size() == 0) {
            args.add(null);
        }
        if (vars.size() == 0) {
            vars.add(null);
        }
        i = 0;
        while (i < numProcs.size()) {
            String num = numProcs.get(i);
            for (String arg : args) {
                for (Map<String, String> var : vars) {
                    if (checkedArgs.size() > 0) {
                        if (arg == null) {
                            arg = "";
                        }
                        for (StringPair sp : checkedArgs) {
                            arg = String.valueOf(arg) + " " + sp.getFirst() + ParametricToolLaunchManager.getComArgs(sp.getSecond()).get(i);
                        }
                    }
                    if (checkedVars.size() > 0) {
                        if (var == null) {
                            var = new HashMap<String, String>();
                        }
                        for (StringPair sp : checkedVars) {
                            var.put(sp.getFirst(), ParametricToolLaunchManager.getComArgs(sp.getSecond()).get(i));
                        }
                    }
                    params.add(new RunParams(Integer.parseInt(num), arg, var));
                }
            }
            ++i;
        }
        return params;
    }

    static List<StringPair> getStringCombinations(String a, String b) {
        ArrayList<StringPair> combos = new ArrayList<StringPair>();
        List<String> aList = ParametricToolLaunchManager.getComArgs(a);
        List<String> bList = ParametricToolLaunchManager.getComArgs(b);
        for (String first : aList) {
            for (String second : bList) {
                combos.add(new StringPair(first, second));
            }
        }
        return combos;
    }

    public static String getTauMetadata(Map<String, String> build, RunParams par) {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<tau:metadata xmlns:tau=\"http://www.cs.uoregon.edu/research/tau\">\n<tau:CommonProfileAttributes>";
        if (build != null) {
            xml = String.valueOf(xml) + ParametricToolLaunchManager.makeTauAtts(build, "BUILD:");
        }
        if (par.args != null) {
            xml = String.valueOf(xml) + ParametricToolLaunchManager.makeTauAtt("ApplicationArguments", par.args);
        }
        if (par.vars != null) {
            xml = String.valueOf(xml) + ParametricToolLaunchManager.makeTauAtts(par.vars, "ENV:");
        }
        xml = String.valueOf(xml) + "\n</tau:CommonProfileAttributes>\n</tau:metadata>";
        return xml;
    }

    static List<RunParams> getWeakParams(String procs, List<String> argNames, List<String> argVars, List<String> envNames, List<String> envVars) {
        ArrayList<RunParams> params = new ArrayList<RunParams>();
        List<String> numProcs = ParametricToolLaunchManager.getComArgs(procs);
        int i = 0;
        while (i < numProcs.size()) {
            String num = numProcs.get(i);
            String arg = null;
            HashMap<String, String> var = null;
            int j = 0;
            while (j < argNames.size()) {
                if (arg == null) {
                    arg = "";
                }
                List<String> av = ParametricToolLaunchManager.getComArgs(argVars.get(j));
                arg = String.valueOf(arg) + " " + argNames.get(j) + av.get(i);
                ++j;
            }
            j = 0;
            while (j < envNames.size()) {
                if (var == null) {
                    var = new HashMap<String, String>();
                }
                List<String> ev = ParametricToolLaunchManager.getComArgs(envVars.get(j));
                var.put(envNames.get(j), ev.get(i));
                ++j;
            }
            params.add(new RunParams(Integer.parseInt(num), arg, var));
            ++i;
        }
        return params;
    }

    /*
     * WARNING - void declaration
     */
    public static void launch(ILaunchConfiguration configuration, LaunchConfigurationDelegate paraDel, ILaunchFactory lf, String mode, ILaunch launchIn, IProgressMonitor monitor, IBuildLaunchUtils utilBlob) throws CoreException {
        boolean parallel;
        final LinkedList<ILaunchConfiguration> configs = new LinkedList<ILaunchConfiguration>();
        final LinkedList<ToolStep> steps = new LinkedList<ToolStep>();
        JobChangeAdapter tauChange = new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getJob() instanceof PostlaunchTool) {
                    try {
                        ((ILaunchConfiguration)configs.poll()).delete();
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                if (!steps.isEmpty()) {
                    System.out.println("About to run job " + steps.size() + " " + ((ToolStep)steps.element()).getName());
                    ((ToolStep)steps.poll()).schedule();
                    System.out.println("Done.  Jobs left: " + steps.size());
                }
            }
        };
        ExternalToolProcess pproc = ETFWUtils.getTool(configuration.getAttribute("selected_performance_tool", null));
        Object processorOptionString = null;
        List argVars = null;
        List argNames = null;
        List argBools = null;
        List varNames = null;
        List varVars = null;
        List varBools = null;
        String optLevStr = null;
        boolean allCom = false;
        boolean bl = parallel = lf != null && lf.getType().equals("parallel_launch");
        if (pproc.para != null && pproc.para.runParametric) {
            processorOptionString = pproc.para.mpiProcs;
            argNames = pproc.para.argNames;
            argVars = pproc.para.argValues;
            argBools = pproc.para.argWeakBools;
            varNames = pproc.para.varNames;
            varVars = pproc.para.varValues;
            varBools = pproc.para.varWeakBools;
            optLevStr = pproc.para.compileropt;
            allCom = !pproc.para.weakScaling;
        } else {
            processorOptionString = configuration.getAttribute("processors to use in parametric study", "1");
            argNames = configuration.getAttribute("argument names use in parametric study", null);
            argVars = configuration.getAttribute("argument values use in parametric study", null);
            argBools = configuration.getAttribute("tells which para args are checked", null);
            varNames = configuration.getAttribute("env-var names to use in parametric study", null);
            varVars = configuration.getAttribute("env-var values to use in parametric study", null);
            varBools = configuration.getAttribute("tells which para vars are checked", null);
            optLevStr = configuration.getAttribute("compiler optimization levels to use in parametric study", "");
            allCom = configuration.getAttribute("use simple weak scaling in perf parametric tests", false);
        }
        String timestamp = BuildLaunchUtils.getNow();
        List<RunParams> params = null;
        if (!parallel) {
            if (allCom) {
                processorOptionString = "1";
            } else {
                void var25_31;
                int i;
                int min = -1;
                if (argVars != null) {
                    i = 0;
                    while (i < argVars.size()) {
                        int n = ParametricToolLaunchManager.getComArgs((String)argVars.get(i)).size();
                        if (min == -1 || min > n) {
                            min = n;
                        }
                        ++i;
                    }
                }
                if (varVars != null) {
                    i = 0;
                    while (i < varVars.size()) {
                        int n = ParametricToolLaunchManager.getComArgs((String)varVars.get(i)).size();
                        if (min == -1 || min > n) {
                            min = n;
                        }
                        ++i;
                    }
                }
                if (min == -1) {
                    min = 0;
                }
                Object agg = "";
                boolean bl2 = false;
                while (var25_31 < min) {
                    agg = String.valueOf(agg) + "1";
                    if (var25_31 < min - 1) {
                        agg = String.valueOf(agg) + ",";
                    }
                    ++var25_31;
                }
                if (((String)agg).length() == 0) {
                    agg = "1";
                }
                processorOptionString = agg;
            }
        }
        params = !allCom ? ParametricToolLaunchManager.getWeakParams((String)processorOptionString, argNames, argVars, varNames, varVars) : ParametricToolLaunchManager.getRunParams((String)processorOptionString, argNames, argVars, argBools, varNames, varVars, varBools);
        System.out.println(params.size());
        for (RunParams param : params) {
            System.out.println("Num Processors: " + param.numProcs);
            if (param.args != null) {
                System.out.println("Program args: " + param.args);
            }
            System.out.println("Env args: ");
            if (param.vars == null) continue;
            for (Map.Entry entry : param.vars.entrySet()) {
                System.out.println(entry);
            }
        }
        List<String> optLevs = ParametricToolLaunchManager.getComArgs(optLevStr);
        ArrayList buildopts = new ArrayList();
        if (optLevs.size() == 0) {
            buildopts.add(null);
        } else {
            block13: for (String string : optLevs) {
                String lev = null;
                HashMap<String, String> hm = null;
                switch (Integer.parseInt(string)) {
                    case 0: {
                        lev = Messages.ParametricToolLaunchManager_OpNone;
                        break;
                    }
                    case 1: {
                        lev = Messages.ParametricToolLaunchManager_Op1;
                        break;
                    }
                    case 2: {
                        lev = Messages.ParametricToolLaunchManager_Op2;
                        break;
                    }
                    case 3: {
                        lev = Messages.ParametricToolLaunchManager_Op3;
                        break;
                    }
                    default: {
                        continue block13;
                    }
                }
                if (lev == null) continue;
                hm = new HashMap<String, String>();
                hm.put(Messages.ParametricToolLaunchManager_OptimizationLevel, lev);
                buildopts.add(hm);
            }
        }
        BuildTool buildTool = pproc.getFirstBuilder(configuration);
        ExecTool eTool = pproc.getFirstRunner(configuration);
        PostProcTool pTool = pproc.getFirstAnalyzer(configuration);
        int numruns = 0;
        int bDex = 0;
        while (bDex < buildopts.size()) {
            Map optM = (Map)buildopts.get(bDex);
            BuilderTool builder = new BuilderTool(configuration, buildTool, optM, utilBlob);
            steps.add(builder);
            builder.addJobChangeListener((IJobChangeListener)tauChange);
            try {
                builder.join();
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
            int lDex = 0;
            while (lDex < params.size()) {
                RunParams param = params.get(lDex);
                ILaunchConfigurationWorkingCopy wc = configuration.copy(String.valueOf(configuration.getName()) + " ParameterSet_" + numruns);
                if (parallel) {
                    int numProcs = param.numProcs;
                    wc.setAttribute(NUMBER_MPI_PROCS, numProcs);
                }
                String argConfigTag = wc.getAttribute("perf_framework_attribute_for_arguments_value", "");
                if (param.args != null) {
                    String arg = wc.getAttribute(argConfigTag, "");
                    arg = String.valueOf(arg) + " " + param.args;
                    wc.setAttribute(argConfigTag, arg);
                }
                if (param.vars != null) {
                    HashMap<String, String> envvars = null;
                    envvars = wc.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, null);
                    if (envvars == null) {
                        envvars = new HashMap<String, String>();
                    }
                    envvars.putAll(param.vars);
                    wc.setAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, envvars);
                }
                wc.setAttribute("string representation of xml metadata file for perfexplorer", ParametricToolLaunchManager.getTauMetadata(optM, param));
                wc.setAttribute("string that will override the default experiment identifier used in perfdmf storage", timestamp);
                wc.setAttribute("launch perfexplorer along with other tau profile management activity", false);
                if (bDex == buildopts.size() - 1 && lDex == params.size() - 1) {
                    wc.setAttribute("launch perfexplorer along with other tau profile management activity", true);
                }
                ILaunchConfiguration tmpConfig = wc.doSave();
                configs.add(tmpConfig);
                ILaunch launch = launchIn;
                if (lf != null) {
                    launch = lf.makeLaunch(tmpConfig, launchIn.getLaunchMode(), launchIn.getSourceLocator());
                }
                LauncherTool launcher = new LauncherTool(tmpConfig, eTool, builder.getProgramPath(), paraDel, launch, utilBlob);
                steps.add(launcher);
                launcher.addJobChangeListener((IJobChangeListener)tauChange);
                PostlaunchTool analyzer = new PostlaunchTool(tmpConfig, pTool, builder.getOutputLocation(), utilBlob);
                steps.add(analyzer);
                analyzer.addJobChangeListener((IJobChangeListener)tauChange);
                ++numruns;
                ++lDex;
            }
            ++bDex;
        }
        if (steps.size() > 0) {
            ((ToolStep)steps.poll()).schedule();
        } else {
            System.out.println(Messages.ParametricToolLaunchManager_NoPerformanceAnalysisJobsConstructed);
        }
    }

    public static String makeTauAtt(String name, String value) {
        String att = "\n<tau:attribute>\n<tau:name>" + name + "</tau:name>\n<tau:value>" + value + "</tau:value>\n</tau:attribute>";
        return att;
    }

    public static String makeTauAtts(Map<String, String> map, String prefix) {
        String atts = "";
        for (Map.Entry<String, String> e : map.entrySet()) {
            atts = String.valueOf(atts) + ParametricToolLaunchManager.makeTauAtt(String.valueOf(prefix) + e.getKey(), e.getValue());
        }
        return atts;
    }

    public static String mapToString(Map<String, String> map) {
        String out = "";
        Iterator<Map.Entry<String, String>> it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> e = it.next();
            out = String.valueOf(out) + e.getKey() + "=" + e.getValue();
            if (!it.hasNext()) continue;
            out = String.valueOf(out) + ", ";
        }
        return out;
    }

    static List<List<StringPair>> unifyCombos(List<List<StringPair>> combos, int curDex) {
        ArrayList<List<StringPair>> allCom = new ArrayList<List<StringPair>>();
        if (combos.size() == 0) {
            return allCom;
        }
        if (curDex == combos.size() - 1) {
            int i = 0;
            while (i < combos.get(curDex).size()) {
                ArrayList<StringPair> jList = new ArrayList<StringPair>();
                jList.add(0, combos.get(curDex).get(i));
                allCom.add(jList);
                ++i;
            }
            return allCom;
        }
        List<List<StringPair>> someCom = ParametricToolLaunchManager.unifyCombos(combos, curDex + 1);
        int i = 0;
        while (i < combos.get(curDex).size()) {
            int j = 0;
            while (j < someCom.size()) {
                ArrayList<StringPair> jList = new ArrayList<StringPair>((Collection)someCom.get(j));
                jList.add(0, combos.get(curDex).get(i));
                allCom.add(jList);
                ++j;
            }
            ++i;
        }
        return allCom;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RunParams {
        int numProcs;
        String args;
        Map<String, String> vars;

        public RunParams(int numProcs, String args, Map<String, String> vars) {
            this.args = args;
            this.numProcs = numProcs;
            this.vars = vars;
        }
    }

    static class StringPair {
        private String first;
        private String second;

        public StringPair(String first, String second) {
            this.first = first;
            this.second = second;
        }

        public String getFirst() {
            return this.first;
        }

        public String getSecond() {
            return this.second;
        }

        public void setFirst(String first) {
            this.first = first;
        }

        public void setSecond(String second) {
            this.second = second;
        }
    }
}

