/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rm.lml.monitor.ui.handlers;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ptp.core.util.CoreExceptionUtils;
import org.eclipse.ptp.internal.rm.lml.monitor.ui.LMLMonitorUIPlugin;
import org.eclipse.ptp.internal.rm.lml.monitor.ui.messages.Messages;
import org.eclipse.ptp.rm.jaxb.control.core.ILaunchController;
import org.eclipse.ptp.rm.jaxb.control.core.LaunchControllerManager;
import org.eclipse.ptp.rm.lml.core.JobStatusData;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionHostService;
import org.eclipse.remote.core.IRemoteConnectionType;
import org.eclipse.remote.core.IRemoteFileService;
import org.eclipse.remote.core.IRemoteServicesManager;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class ActionUtils {
    private static final int UNDEFINED = -1;
    private static final int COPY_BUFFER_SIZE = 65536;

    public static void callDoControl(JobStatusData status, String operation, IProgressMonitor monitor) throws CoreException {
        ILaunchController controller;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)20);
        String controlId = status.getString("controlId");
        if (controlId != null && (controller = LaunchControllerManager.getInstance().getLaunchController(controlId)) != null) {
            controller.start((IProgressMonitor)progress.newChild(10));
            controller.control(status.getJobId(), operation, (IProgressMonitor)progress.newChild(10));
        }
    }

    public static boolean isAuthorised(JobStatusData status) {
        IRemoteConnection connection;
        ILaunchController control;
        String controlId = status.getString("controlId");
        if (controlId != null && (control = LaunchControllerManager.getInstance().getLaunchController(controlId)) != null && (connection = ActionUtils.getRemoteConnection(control)) != null) {
            IRemoteConnectionHostService hostSvc = (IRemoteConnectionHostService)connection.getService(IRemoteConnectionHostService.class);
            return hostSvc.getUsername().equals(status.getString("owner"));
        }
        return false;
    }

    public static IRemoteConnection getRemoteConnection(ILaunchController controller) {
        IRemoteServicesManager svcMgr = ActionUtils.getService(IRemoteServicesManager.class);
        IRemoteConnectionType connType = svcMgr.getConnectionType(controller.getRemoteServicesId());
        if (connType != null) {
            return connType.getConnection(controller.getConnectionName());
        }
        return null;
    }

    public static <T> T getService(Class<T> service) {
        BundleContext context = LMLMonitorUIPlugin.getDefault().getBundle().getBundleContext();
        ServiceReference ref = context.getServiceReference(service);
        return (T)(ref != null ? context.getService(ref) : null);
    }

    public static void readRemoteFile(ILaunchController controller, String path) {
        IRemoteConnection conn = ActionUtils.getRemoteConnection(controller);
        if (conn != null) {
            FileReadConsoleAppender reader = new FileReadConsoleAppender(conn, path);
            reader.setUser(true);
            reader.schedule();
        }
    }

    public static void removeFiles(final List<JobStatusData> selected) {
        Job j = new Job(Messages.ActionUtils_Remove_Files){

            protected IStatus run(IProgressMonitor monitor) {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(50 * selected.size()));
                for (JobStatusData status : selected) {
                    IRemoteFileService fileSvc;
                    IFileStore lres;
                    IRemoteConnection conn;
                    ILaunchController control;
                    String controlId = status.getString("controlId");
                    if (controlId == null || (control = LaunchControllerManager.getInstance().getLaunchController(controlId)) == null) continue;
                    String remotePath = status.getString("stdoutRemotePath");
                    if (remotePath != null && (conn = ActionUtils.getRemoteConnection(control)) != null && (lres = (fileSvc = (IRemoteFileService)conn.getService(IRemoteFileService.class)).getResource(remotePath)) != null) {
                        try {
                            if (lres.fetchInfo(0, (IProgressMonitor)progress.newChild(25)).exists()) {
                                lres.delete(0, (IProgressMonitor)progress.newChild(25));
                            }
                        }
                        catch (CoreException coreException) {
                            // empty catch block
                        }
                    }
                    if ((remotePath = status.getString("stderrRemotePath")) == null || (conn = ActionUtils.getRemoteConnection(control)) == null || (lres = (fileSvc = (IRemoteFileService)conn.getService(IRemoteFileService.class)).getResource(remotePath)) == null) continue;
                    try {
                        if (!lres.fetchInfo(0, (IProgressMonitor)progress.newChild(25)).exists()) continue;
                        lres.delete(0, (IProgressMonitor)progress.newChild(25));
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
                return Status.OK_STATUS;
            }
        };
        j.setUser(true);
        j.schedule();
    }

    private ActionUtils() {
    }

    private static class FileReadConsoleAppender
    extends Job {
        private IOConsole console;
        private IOConsoleOutputStream stream;
        private int read;
        private final IRemoteConnection connection;

        public FileReadConsoleAppender(IRemoteConnection conn, String path) {
            super(path);
            this.connection = conn;
            this.read = 0;
        }

        protected IStatus run(IProgressMonitor monitor) {
            block16: {
                try {
                    this.console = new IOConsole(this.getName(), null);
                    ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{this.console});
                    this.console.activate();
                    this.stream = this.console.newOutputStream();
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1000);
                    IRemoteFileService fileSvc = (IRemoteFileService)this.connection.getService(IRemoteFileService.class);
                    IFileStore lres = fileSvc.getResource(this.getName());
                    if (lres == null) break block16;
                    BufferedInputStream is = new BufferedInputStream(lres.openInputStream(0, (IProgressMonitor)progress.newChild(25)));
                    byte[] buffer = new byte[65536];
                    try {
                        while (!progress.isCanceled()) {
                            try {
                                this.read = is.read(buffer, 0, 65536);
                            }
                            catch (EOFException t) {
                                break;
                            }
                            if (this.read == -1) {
                                break;
                            }
                            if (progress.isCanceled()) {
                                this.read = -1;
                                break;
                            }
                            progress.worked(5);
                            this.stream.write(buffer, 0, this.read);
                        }
                    }
                    finally {
                        try {
                            if (this.stream != null) {
                                this.stream.flush();
                                this.stream.close();
                            }
                            if (is != null) {
                                is.close();
                            }
                        }
                        catch (IOException t) {
                            t.printStackTrace();
                        }
                        monitor.done();
                    }
                }
                catch (Exception e) {
                    if (monitor.isCanceled()) break block16;
                    return CoreExceptionUtils.getErrorStatus((String)e.getMessage(), (Throwable)e);
                }
            }
            return Status.OK_STATUS;
        }
    }
}

