/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.graphiti.handler;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.graphiti.tb.ContextButtonEntry;
import org.eclipse.graphiti.tb.IContextButtonEntry;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.common.util.ResultRunnable;
import org.eclipse.reddeer.graphiti.api.ContextButton;
import org.eclipse.reddeer.graphiti.impl.contextbutton.internal.BasicContextButton;

public class ContextButtonHandler {
    protected final Logger log = Logger.getLogger(this.getClass());
    private static ContextButtonHandler instance;

    public static ContextButtonHandler getInstance() {
        if (instance == null) {
            instance = new ContextButtonHandler();
        }
        return instance;
    }

    public void click(final IContextButtonEntry contextButtonEntry) {
        Display.asyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                contextButtonEntry.execute();
            }
        });
    }

    public String getText(final IContextButtonEntry contextButtonEntry) {
        return (String)Display.syncExec((ResultRunnable)new ResultRunnable<String>(){

            public String run() {
                return contextButtonEntry.getText();
            }
        });
    }

    public List<ContextButton> getContextButtons(IContextButtonEntry contextButtonEntry) {
        ArrayList<ContextButton> entries = new ArrayList<ContextButton>();
        if (contextButtonEntry instanceof ContextButtonEntry) {
            ContextButtonEntry entry = (ContextButtonEntry)contextButtonEntry;
            List menuEntries = entry.getContextButtonMenuEntries();
            for (IContextButtonEntry menuEntry : menuEntries) {
                entries.add(new BasicContextButton(menuEntry));
            }
        }
        return entries;
    }
}

