/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.cdt.ui.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTImplicitName;
import org.eclipse.cdt.core.dom.ast.IASTImplicitNameOwner;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeSelector;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDeclaration;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.debug.internal.ui.CDebugUIUtils;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.index.IIndexFragmentName;
import org.eclipse.cdt.internal.core.model.ASTCache;
import org.eclipse.cdt.internal.core.model.ext.CElementHandleFactory;
import org.eclipse.cdt.internal.core.model.ext.ICElementHandle;
import org.eclipse.cdt.internal.ui.editor.ASTProvider;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.viewsupport.IndexUI;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.commands.IDebugCommandRequest;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.tcf.internal.debug.ui.model.TCFModel;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeStackFrame;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextEditor;

class StepIntoSelectionLocation {
    IDebugCommandRequest request;
    TCFNodeExecContext node;
    TextEditor editor;
    ITextSelection text_selection;
    String text_file;
    int text_line;
    ITranslationUnit compilation_unit;
    IIndex project_index;
    IFunctionDeclaration[] resolved_functions;
    IFunctionDeclaration target_function;

    StepIntoSelectionLocation() {
    }

    void getTextLocation(IDebugCommandRequest request) {
        IEditorPart part;
        this.request = request;
        Object[] elements = request.getElements();
        if (elements.length != 1) {
            return;
        }
        if (elements[0] instanceof TCFNodeExecContext) {
            this.node = (TCFNodeExecContext)elements[0];
        } else if (elements[0] instanceof TCFNodeStackFrame) {
            this.node = (TCFNodeExecContext)((TCFNodeStackFrame)elements[0]).getParent();
        } else {
            return;
        }
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
        if (win != null && win.getActivePage() != null && (part = win.getActivePage().getActiveEditor()) instanceof TextEditor) {
            this.editor = (TextEditor)part;
        }
        if (this.editor != null) {
            ISelection selection = this.editor.getEditorSite().getSelectionProvider().getSelection();
            if (selection instanceof ITextSelection) {
                this.text_selection = (ITextSelection)selection;
            }
            try {
                this.text_file = CDebugUIUtils.getEditorFilePath((IEditorInput)this.editor.getEditorInput());
            }
            catch (CoreException x) {
                request.setStatus((IStatus)new Status(4, "org.eclipse.tcf.cdt.ui", 4, TCFModel.getErrorMessage((Throwable)x, (boolean)true), (Throwable)x));
                return;
            }
        }
        if (this.text_selection != null) {
            this.text_line = this.text_selection.getStartLine() + 1;
        }
    }

    private IName[] findDefinitions(IIndex index, IASTTranslationUnit ast, NameKind kind, IBinding binding) throws CoreException {
        ArrayList<IASTName> declNames = new ArrayList<IASTName>();
        declNames.addAll(Arrays.asList(ast.getDefinitionsInAST(binding)));
        Iterator i = declNames.iterator();
        while (i.hasNext()) {
            IASTName name = (IASTName)i.next();
            IBinding b2 = name.resolveBinding();
            if (b2 instanceof ICPPUsingDeclaration) {
                i.remove();
            }
            if (binding == b2 || !(binding instanceof ICPPSpecialization)) continue;
            IBinding spec = binding;
            while (spec instanceof ICPPSpecialization) {
                if ((spec = ((ICPPSpecialization)spec).getSpecializedBinding()) == b2) break;
            }
            if (spec instanceof ICPPSpecialization) continue;
            i.remove();
        }
        if (!declNames.isEmpty()) {
            return (IName[])declNames.toArray(new IASTName[declNames.size()]);
        }
        return index.findNames(binding, 10);
    }

    private IName[] findDeclarations(IIndex index, IASTTranslationUnit ast, IBinding binding) throws CoreException {
        Object[] astNames = ast.getDeclarationsInAST(binding);
        ArrayList<Object> usingDeclarations = null;
        int i = 0;
        while (i < astNames.length) {
            Object name = astNames[i];
            if (name.isDefinition()) {
                astNames[i] = null;
            } else if (CPPVisitor.findAncestorWithType((IASTNode)name, ICPPASTUsingDeclaration.class) != null) {
                if (usingDeclarations == null) {
                    usingDeclarations = new ArrayList<Object>(1);
                }
                usingDeclarations.add(name);
                astNames[i] = null;
            }
            ++i;
        }
        IName[] declNames = (IName[])ArrayUtil.removeNulls((Object[])astNames);
        if (declNames.length == 0) {
            declNames = index.findNames(binding, 9);
        }
        if (declNames.length == 0 && usingDeclarations != null) {
            declNames = usingDeclarations.toArray(new IName[usingDeclarations.size()]);
        }
        return declNames;
    }

    private IName[] findNames(IIndex index, IASTTranslationUnit ast, NameKind kind, IBinding binding) throws CoreException {
        IName[] declNames = kind == NameKind.DEFINITION ? this.findDeclarations(index, ast, binding) : this.findDefinitions(index, ast, kind, binding);
        if (declNames.length == 0) {
            declNames = kind == NameKind.DEFINITION ? this.findDefinitions(index, ast, kind, binding) : this.findDeclarations(index, ast, binding);
        }
        return declNames;
    }

    private IName[] findDeclNames(IASTTranslationUnit ast, NameKind kind, IBinding binding) throws CoreException {
        ICPPClassType clsBinding;
        ICPPMethod method;
        IName[] declNames = this.findNames(this.project_index, ast, kind, binding);
        while (declNames.length == 0 && binding instanceof ICPPSpecialization) {
            if ((binding = ((ICPPSpecialization)binding).getSpecializedBinding()) == null || binding instanceof IProblemBinding) continue;
            declNames = this.findNames(this.project_index, ast, NameKind.DEFINITION, binding);
        }
        if (declNames.length == 0 && binding instanceof ICPPMethod && (method = (ICPPMethod)binding).isImplicit() && (clsBinding = method.getClassOwner()) != null && !(clsBinding instanceof IProblemBinding)) {
            declNames = this.findNames(this.project_index, ast, NameKind.REFERENCE, (IBinding)clsBinding);
        }
        return declNames;
    }

    private IName[] findImplicitTargets(IASTTranslationUnit ast, IASTNodeSelector nodeSelector, int offset, int length) throws CoreException {
        Object[] definitions = IName.EMPTY_ARRAY;
        IASTImplicitName firstName = nodeSelector.findEnclosingImplicitName(offset, length);
        if (firstName != null) {
            IASTImplicitNameOwner owner = (IASTImplicitNameOwner)firstName.getParent();
            IASTImplicitName[] iASTImplicitNameArray = owner.getImplicitNames();
            int n = iASTImplicitNameArray.length;
            int n2 = 0;
            while (n2 < n) {
                IASTImplicitName name = iASTImplicitNameArray[n2];
                if (((ASTNode)name).getOffset() == ((ASTNode)firstName).getOffset()) {
                    IBinding binding = name.resolveBinding();
                    Object[] declNames = this.findDeclNames(ast, NameKind.REFERENCE, binding);
                    definitions = (IName[])ArrayUtil.addAll((Object[])definitions, (Object[])declNames);
                }
                ++n2;
            }
        }
        return (IName[])ArrayUtil.trim((Object[])definitions);
    }

    private static IBinding getBinding(IName name) {
        if (name instanceof IASTName) {
            return ((IASTName)name).resolveBinding();
        }
        if (name instanceof IIndexFragmentName) {
            try {
                return ((IIndexFragmentName)name).getBinding();
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return null;
    }

    private static NameKind getNameKind(IName name) {
        if (name.isDefinition()) {
            if (StepIntoSelectionLocation.getBinding(name) instanceof ICPPUsingDeclaration) {
                return NameKind.USING_DECL;
            }
            return NameKind.DEFINITION;
        }
        if (name.isDeclaration()) {
            return NameKind.DECLARATION;
        }
        return NameKind.REFERENCE;
    }

    private boolean areOverlappingNames(IName n1, IName n2) {
        if (n1 == n2) {
            return true;
        }
        IASTFileLocation loc1 = n1.getFileLocation();
        IASTFileLocation loc2 = n2.getFileLocation();
        if (loc1 == null || loc2 == null) {
            return false;
        }
        return loc1.getFileName().equals(loc2.getFileName()) && Math.max(loc1.getNodeOffset(), loc2.getNodeOffset()) < Math.min(loc1.getNodeOffset() + loc1.getNodeLength(), loc2.getNodeOffset() + loc2.getNodeLength());
    }

    private static IASTDeclaration getEnclosingFunctionDefinition(IASTNode node) {
        while (node != null && !(node instanceof IASTFunctionDefinition)) {
            node = node.getParent();
        }
        return (IASTDeclaration)node;
    }

    private static boolean isInSameFunction(IASTName refName, IName funcDeclName) {
        if (funcDeclName instanceof IASTName) {
            IASTDeclaration fdef = StepIntoSelectionLocation.getEnclosingFunctionDefinition((IASTNode)funcDeclName);
            return fdef != null && fdef.contains((IASTNode)refName);
        }
        return false;
    }

    private static IASTDeclaration getEnclosingTemplateDeclaration(IASTNode node) {
        while (node != null && !(node instanceof ICPPASTTemplateDeclaration)) {
            node = node.getParent();
        }
        return (IASTDeclaration)node;
    }

    private static boolean isInSameTemplate(IASTName refName, IName templateDeclName) {
        if (templateDeclName instanceof IASTName) {
            IASTDeclaration template = StepIntoSelectionLocation.getEnclosingTemplateDeclaration((IASTNode)refName);
            return template != null && template.contains((IASTNode)refName);
        }
        return false;
    }

    private ICElementHandle getCElementForName(ICProject project, IIndex index, IName declName) throws CoreException {
        if (declName instanceof IIndexName) {
            return IndexUI.getCElementForName((ICProject)project, (IIndex)index, (IIndexName)((IIndexName)declName));
        }
        if (declName instanceof IASTName) {
            ITranslationUnit tu;
            IASTName astName = (IASTName)declName;
            IBinding binding = astName.resolveBinding();
            if (binding != null && (tu = StepIntoSelectionLocation.getTranslationUnit(astName)) != null) {
                IASTFileLocation loc = astName.getFileLocation();
                Region region = new Region(loc.getNodeOffset(), loc.getNodeLength());
                return CElementHandleFactory.create((ITranslationUnit)tu, (IBinding)binding, (boolean)astName.isDefinition(), (IRegion)region, (long)0L);
            }
            return null;
        }
        return null;
    }

    private void filterToFunctions(ICProject project, IIndex index, IName[] declNames, List<IFunctionDeclaration> functionElements) {
        IName[] iNameArray = declNames;
        int n = declNames.length;
        int n2 = 0;
        while (n2 < n) {
            IName declName = iNameArray[n2];
            try {
                ICElementHandle elem = this.getCElementForName(project, index, declName);
                if (elem instanceof IFunctionDeclaration) {
                    functionElements.add((IFunctionDeclaration)elem);
                }
            }
            catch (CoreException e) {
                CUIPlugin.log((Throwable)e);
            }
            ++n2;
        }
    }

    void getTargetFunction(IDebugCommandRequest request) {
        this.getTextLocation(request);
        if (this.text_selection == null) {
            return;
        }
        this.text_line = this.text_selection.getStartLine() + 1;
        if (this.editor instanceof CEditor) {
            this.compilation_unit = ((CEditor)this.editor).getInputCElement();
            if (this.compilation_unit == null) {
                return;
            }
            try {
                this.project_index = CCorePlugin.getIndexManager().getIndex(this.compilation_unit.getCProject(), 11);
            }
            catch (Exception x) {
                request.setStatus((IStatus)new Status(4, "org.eclipse.tcf.cdt.ui", 4, TCFModel.getErrorMessage((Throwable)x, (boolean)true), (Throwable)x));
                return;
            }
            IStatus status = ASTProvider.getASTProvider().runOnAST((ICElement)this.compilation_unit, ASTProvider.WAIT_NO, null, new ASTCache.ASTRunnable(){

                public IStatus runOnAST(ILanguage lang, IASTTranslationUnit ast) throws CoreException {
                    if (ast == null) {
                        return Status.OK_STATUS;
                    }
                    int selection_start = StepIntoSelectionLocation.this.text_selection.getOffset();
                    int selection_length = StepIntoSelectionLocation.this.text_selection.getLength();
                    IASTNodeSelector node_selector = ast.getNodeSelector(null);
                    IASTName source_name = node_selector.findEnclosingName(selection_start, selection_length);
                    if (source_name == null) {
                        return new Status(4, "org.eclipse.tcf.cdt.ui", "Unable to resolve the selection to a semantic object");
                    }
                    Object[] implicitTargets = StepIntoSelectionLocation.this.findImplicitTargets(ast, node_selector, selection_start, selection_length);
                    NameKind kind = StepIntoSelectionLocation.getNameKind((IName)source_name);
                    IBinding b = source_name.resolveBinding();
                    IBinding[] bindings = new IBinding[]{b};
                    if (b instanceof IProblemBinding) {
                        IBinding[] candidateBindings = ((IProblemBinding)b).getCandidateBindings();
                        if (candidateBindings.length != 0) {
                            bindings = candidateBindings;
                        }
                    } else if (kind == NameKind.DEFINITION && b instanceof IType) {
                        return Status.OK_STATUS;
                    }
                    Object[] targets = IName.EMPTY_ARRAY;
                    String file_path = ast.getFilePath();
                    IBinding[] iBindingArray = bindings;
                    int n = bindings.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IBinding binding = iBindingArray[n2];
                        if (binding != null && !(binding instanceof IProblemBinding)) {
                            IName[] names;
                            IName[] iNameArray = names = StepIntoSelectionLocation.this.findDeclNames(ast, kind, binding);
                            int n3 = names.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IName name = iNameArray[n4];
                                if (!(name == null || name instanceof IIndexName && file_path.equals(((IIndexName)name).getFileLocation().getFileName()) || StepIntoSelectionLocation.this.areOverlappingNames(name, (IName)source_name))) {
                                    if (binding instanceof IParameter) {
                                        if (StepIntoSelectionLocation.isInSameFunction(source_name, name)) {
                                            targets = (IName[])ArrayUtil.append((Object[])targets, (Object)name);
                                        }
                                    } else if (binding instanceof ICPPTemplateParameter) {
                                        if (StepIntoSelectionLocation.isInSameTemplate(source_name, name)) {
                                            targets = (IName[])ArrayUtil.append((Object[])targets, (Object)name);
                                        }
                                    } else {
                                        targets = (IName[])ArrayUtil.append((Object[])targets, (Object)name);
                                    }
                                }
                                ++n4;
                            }
                        }
                        ++n2;
                    }
                    targets = (IName[])ArrayUtil.trim((Object[])((IName[])ArrayUtil.addAll((Object[])targets, (Object[])implicitTargets)));
                    ArrayList functionElements = new ArrayList();
                    StepIntoSelectionLocation.this.filterToFunctions(StepIntoSelectionLocation.this.compilation_unit.getCProject(), StepIntoSelectionLocation.this.project_index, (IName[])targets, functionElements);
                    StepIntoSelectionLocation.this.resolved_functions = functionElements.toArray(new IFunctionDeclaration[functionElements.size()]);
                    return Status.OK_STATUS;
                }
            });
            if (status.getSeverity() != 0) {
                request.setStatus(status);
            }
        }
        if (this.resolved_functions != null && this.resolved_functions.length == 1 && this.resolved_functions[0] != null) {
            this.target_function = this.resolved_functions[0];
        }
    }

    boolean isValid() {
        return this.request != null && this.request.getStatus() == null && this.text_file != null && this.text_line > 0;
    }

    private static ITranslationUnit getTranslationUnit(IASTName name) {
        IASTTranslationUnit astTranslationUnit = name.getTranslationUnit();
        return astTranslationUnit == null ? null : astTranslationUnit.getOriginatingTranslationUnit();
    }

    private static enum NameKind {
        REFERENCE,
        DECLARATION,
        USING_DECL,
        DEFINITION;

    }
}

