/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.boundary;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.eclipse.viatra.query.runtime.matchers.planning.SubPlan;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.matchers.util.Direction;
import org.eclipse.viatra.query.runtime.rete.boundary.InputConnector;
import org.eclipse.viatra.query.runtime.rete.matcher.ReteEngine;
import org.eclipse.viatra.query.runtime.rete.network.Network;
import org.eclipse.viatra.query.runtime.rete.network.ProductionNode;
import org.eclipse.viatra.query.runtime.rete.network.Receiver;
import org.eclipse.viatra.query.runtime.rete.network.ReteContainer;
import org.eclipse.viatra.query.runtime.rete.network.Supplier;
import org.eclipse.viatra.query.runtime.rete.remote.Address;
import org.eclipse.viatra.query.runtime.rete.traceability.CompiledQuery;
import org.eclipse.viatra.query.runtime.rete.traceability.RecipeTraceInfo;

public class ReteBoundary {
    protected ReteEngine engine;
    protected Network network;
    protected ReteContainer headContainer;
    protected final InputConnector inputConnector;
    protected Map<SubPlan, Address<? extends Supplier>> subplanToAddressMapping;
    protected Map<Address<? extends Receiver>, Set<SubPlan>> parentPlansOfReceiver;

    public ReteContainer getHeadContainer() {
        return this.headContainer;
    }

    public ReteBoundary(ReteEngine engine) {
        this.engine = engine;
        this.network = engine.getReteNet();
        this.headContainer = this.network.getHeadContainer();
        this.inputConnector = this.network.getInputConnector();
        this.parentPlansOfReceiver = CollectionsFactory.createMap();
        this.subplanToAddressMapping = CollectionsFactory.createMap();
    }

    public Collection<? extends RecipeTraceInfo> getAllProductionNodes() {
        return this.engine.getCompiler().getCachedCompiledQueries().values();
    }

    public synchronized RecipeTraceInfo accessProductionTrace(PQuery query) {
        CompiledQuery compiled = this.engine.getCompiler().getCompiledForm(query);
        return compiled;
    }

    public synchronized Address<? extends ProductionNode> accessProductionNode(PQuery query) {
        RecipeTraceInfo productionTrace = this.accessProductionTrace(query);
        return this.headContainer.getProvisioner().getOrCreateNodeByRecipe(productionTrace);
    }

    private static Direction direction(boolean isInsertion) {
        return isInsertion ? Direction.INSERT : Direction.DELETE;
    }

    public void notifyEvaluator(Address<? extends Receiver> receiver, Tuple tuple) {
        this.network.sendExternalUpdate(receiver, Direction.INSERT, tuple);
        if (!this.engine.isParallelExecutionEnabled()) {
            this.network.waitForReteTermination();
        }
    }

    public void mapPlanToAddress(SubPlan plan, Address<? extends Supplier> handle) {
        this.subplanToAddressMapping.put(plan, handle);
    }

    public Address<? extends Supplier> getAddress(SubPlan plan) {
        return this.subplanToAddressMapping.get(plan);
    }
}

