/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.debug.launch;

import java.io.IOException;
import javax.management.InstanceNotFoundException;
import javax.management.MalformedObjectNameException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.viatra.transformation.debug.communication.DebuggerHostEndpoint;
import org.eclipse.viatra.transformation.debug.model.TransformationDebugProcess;
import org.eclipse.viatra.transformation.debug.model.TransformationDebugTarget;

public class TransformationLaunchConfigurationDelegate
implements ILaunchConfigurationDelegate {
    public static final String SELECTED_TARGET = "org.eclipse.viatra.transformation.debug.launch.SelectedTarget";
    public static final String TRANSFORMATION_ATTR = "org.eclipse.viatra.transformation.debug.launch.TransformationClass";
    public static final String PROJECT_NAME = "org.eclipse.viatra.transformation.debug.launch.TransformationProject";
    public static final String PORT_NAME = "org.eclipse.viatra.transformation.debug.launch.DebuggerPort";

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        String endpointID = configuration.getAttribute(SELECTED_TARGET, "");
        String transformationClassName = configuration.getAttribute(TRANSFORMATION_ATTR, "");
        String projectName = configuration.getAttribute(PROJECT_NAME, "");
        int port = Integer.parseInt(configuration.getAttribute(PORT_NAME, ""));
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project.hasNature("org.eclipse.jdt.core.javanature")) {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IType transformationType = javaProject.findType(transformationClassName);
            DebuggerHostEndpoint agent = new DebuggerHostEndpoint(endpointID);
            try {
                agent.connectTo(port);
                if (mode.equals("debug")) {
                    TransformationDebugTarget target = new TransformationDebugTarget(launch, agent, transformationType);
                    launch.addDebugTarget((IDebugTarget)target);
                }
            }
            catch (IOException | InstanceNotFoundException | MalformedObjectNameException e) {
                TransformationDebugProcess process = new TransformationDebugProcess(launch, "FAILED");
                process.terminate();
                launch.addProcess((IProcess)process);
                PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
                    Shell activeShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    ErrorDialog.openError((Shell)activeShell, (String)"Debugger Connection Interrupted", (String)"Communication with the VIATRA Debugger Agent has been interrupted. Perhaps the target application has been closed abruptly or was not running at all.", (IStatus)new Status(4, "org.eclipse.viatra.transformation.debug", e.getMessage()));
                });
            }
        }
    }
}

