/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.util;

import java.util.Comparator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.internal.core.SortElementsOperation;

public final class JavaScriptUnitSorter {
    public static final String RELATIVE_ORDER = "relativeOrder";

    private JavaScriptUnitSorter() {
    }

    private static void checkASTLevel(int level) {
        switch (level) {
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public static void sort(int level, IJavaScriptUnit compilationUnit, int[] positions, Comparator comparator, int options, IProgressMonitor monitor) throws JavaScriptModelException {
        if (compilationUnit == null || comparator == null) {
            throw new IllegalArgumentException();
        }
        JavaScriptUnitSorter.checkASTLevel(level);
        IJavaScriptElement[] compilationUnits = new IJavaScriptUnit[]{compilationUnit};
        SortElementsOperation operation = new SortElementsOperation(level, compilationUnits, positions, comparator);
        operation.runOperation(monitor);
    }

    public static TextEdit sort(JavaScriptUnit unit, Comparator comparator, int options, TextEditGroup group, IProgressMonitor monitor) throws JavaScriptModelException {
        if (unit == null || comparator == null) {
            throw new IllegalArgumentException();
        }
        SortElementsOperation operation = new SortElementsOperation(3, new IJavaScriptElement[]{unit.getJavaElement()}, null, comparator);
        return operation.calculateEdit(unit, group);
    }
}

