/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.core.internal.util;

import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public class RegionIterator {
    private IStructuredDocumentRegion documentRegion = null;
    private IStructuredDocumentRegion curDocumentRegion = null;
    private int current = -1;

    public RegionIterator(IStructuredDocument structuredDocument, int index) {
        this.reset(structuredDocument, index);
    }

    public RegionIterator(IStructuredDocumentRegion flatNode, ITextRegion region) {
        this.reset(flatNode, region);
    }

    public IStructuredDocumentRegion getStructuredDocumentRegion() {
        return this.curDocumentRegion;
    }

    public boolean hasNext() {
        if (this.documentRegion == null) {
            return false;
        }
        if (this.current < 0) {
            return false;
        }
        return this.current < this.documentRegion.getRegions().size();
    }

    public boolean hasPrev() {
        return this.hasNext();
    }

    public ITextRegion next() {
        if (this.documentRegion == null) {
            return null;
        }
        if (this.current < 0 || this.documentRegion.getRegions() == null || this.documentRegion.getRegions().size() <= this.current) {
            return null;
        }
        ITextRegion region = this.documentRegion.getRegions().get(this.current);
        this.curDocumentRegion = this.documentRegion;
        if (this.current >= this.documentRegion.getRegions().size() - 1) {
            this.documentRegion = this.documentRegion.getNext();
            this.current = -1;
        }
        ++this.current;
        return region;
    }

    public ITextRegion prev() {
        if (this.documentRegion == null) {
            return null;
        }
        if (this.current < 0 || this.documentRegion.getRegions() == null || this.documentRegion.getRegions().size() <= this.current) {
            return null;
        }
        ITextRegion region = this.documentRegion.getRegions().get(this.current);
        this.curDocumentRegion = this.documentRegion;
        if (this.current == 0) {
            this.documentRegion = this.documentRegion.getPrevious();
            this.current = this.documentRegion != null ? this.documentRegion.getRegions().size() : 0;
        }
        --this.current;
        return region;
    }

    public void reset(IStructuredDocument structuredDocument, int index) {
        this.curDocumentRegion = this.documentRegion = structuredDocument.getRegionAtCharacterOffset(index);
        if (this.documentRegion != null) {
            ITextRegion region = this.documentRegion.getRegionAtCharacterOffset(index);
            this.current = this.documentRegion.getRegions().indexOf(region);
        }
    }

    public void reset(IStructuredDocumentRegion flatNode, ITextRegion region) {
        if (region != null && flatNode != null) {
            this.documentRegion = flatNode;
            this.curDocumentRegion = flatNode;
            this.current = flatNode.getRegions().indexOf(region);
        }
    }
}

