/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.engine.transformer;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.wst.ws.internal.datamodel.Element;
import org.eclipse.wst.ws.internal.datamodel.Rel;
import org.eclipse.wst.ws.internal.explorer.platform.datamodel.TreeElement;
import org.eclipse.wst.ws.internal.explorer.platform.engine.transformer.ITransformer;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Node;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.NodeManager;

public class NodeSelectionTransformer
implements ITransformer {
    protected Controller controller;

    public NodeSelectionTransformer(Controller controller) {
        this.controller = controller;
    }

    @Override
    public Hashtable normalize(Hashtable properties) {
        try {
            NodeManager nodeManager = this.controller.getCurrentPerspective().getNodeManager();
            Node nextNode = nodeManager.getNode(Integer.parseInt((String)properties.get("nodeId")));
            Node currNode = nodeManager.getSelectedNode();
            if (currNode == null) {
                currNode = nodeManager.getRootNode();
            }
            Vector<String> nextRels = new Vector<String>();
            Vector<String> currRels = new Vector<String>();
            while (!(nextNode == null || currNode == null || this.isRootElement((Element)nextNode.getTreeElement()) && this.isRootElement((Element)currNode.getTreeElement()) || nextNode == currNode)) {
                StringBuffer relValue;
                Rel rel;
                Node parentNode;
                if (nextNode.getNodeDepth() >= currNode.getNodeDepth()) {
                    parentNode = nextNode.getParent();
                    TreeElement nextElement = nextNode.getTreeElement();
                    rel = this.getRel((Element)parentNode.getTreeElement(), (Element)nextElement);
                    relValue = new StringBuffer(rel.getName());
                    relValue.append("#");
                    relValue.append(nextElement.getName());
                    nextRels.insertElementAt(relValue.toString(), 0);
                    nextNode = parentNode;
                    continue;
                }
                parentNode = currNode.getParent();
                TreeElement parentElement = parentNode.getTreeElement();
                rel = this.getRel((Element)currNode.getTreeElement(), (Element)parentElement);
                relValue = new StringBuffer(rel.getName());
                relValue.append("#");
                relValue.append(parentElement.getName());
                currRels.add(relValue.toString());
                currNode = parentNode;
            }
            currRels.addAll(nextRels);
            int numRelationships = currRels.size();
            if (numRelationships == 1) {
                properties.put("relationshipId", currRels.get(0).toString());
            } else if (numRelationships > 1) {
                properties.put("relationshipId", currRels.toArray(new String[0]));
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return properties;
    }

    private boolean isRootElement(Element e) {
        return e.getModel().getRootElement() == e;
    }

    private Rel getRel(Element sourceElement, Element targetElement) {
        Enumeration rels = sourceElement.getRels();
        while (rels.hasMoreElements()) {
            Rel rel = (Rel)rels.nextElement();
            Enumeration targetElements = rel.getTargetElements();
            while (targetElements.hasMoreElements()) {
                if (targetElements.nextElement() != targetElement) continue;
                return rel;
            }
        }
        return null;
    }

    @Override
    public Hashtable deNormalize(Hashtable properties) {
        NodeManager nodeManager = this.controller.getCurrentPerspective().getNodeManager();
        Node rootNode = nodeManager.getRootNode();
        Node currNode = nodeManager.getSelectedNode();
        if (currNode == null) {
            currNode = rootNode;
        }
        Object value = properties.get("relationshipId");
        String[] relationships = null;
        if (value instanceof String[]) {
            relationships = (String[])value;
        } else if (value != null) {
            relationships = new String[]{value.toString()};
        }
        if (relationships != null) {
            TreeElement currElement = currNode.getTreeElement();
            int i = 0;
            while (i < relationships.length) {
                int index = relationships[i].indexOf("#");
                String rel = index != -1 ? relationships[i].substring(0, index) : relationships[i];
                String localname = index != -1 ? relationships[i].substring(index + 1, relationships[i].length()) : null;
                Enumeration e = currElement.getElements(rel);
                Element targetElement = null;
                if (localname != null) {
                    Element firstElement = null;
                    while (e.hasMoreElements()) {
                        Element nextElement = (Element)e.nextElement();
                        if (firstElement == null) {
                            firstElement = nextElement;
                        }
                        if (!localname.equals(nextElement.getName())) continue;
                        targetElement = nextElement;
                        break;
                    }
                    if (targetElement == null) {
                        targetElement = firstElement;
                    }
                } else if (e.hasMoreElements()) {
                    targetElement = (Element)e.nextElement();
                }
                if (targetElement != null) {
                    currElement = targetElement;
                    Node parentNode = currNode.getParent();
                    currNode = parentNode != null && parentNode.getTreeElement() == currElement ? parentNode : currNode.getChildNode(currElement);
                }
                ++i;
            }
        }
        properties.put("nodeId", String.valueOf(currNode.getNodeId()));
        return properties;
    }
}

