/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.common.data;

import com.google.gerrit.common.data.GitWebType;
import com.google.gerrit.common.data.ParamertizedString;
import com.google.gerrit.reviewdb.Branch;
import com.google.gerrit.reviewdb.PatchSet;
import com.google.gerrit.reviewdb.Project;
import com.google.gwt.http.client.URL;
import java.util.HashMap;

public class GitwebLink {
    protected String baseUrl;
    protected GitWebType type;

    protected GitwebLink() {
    }

    public GitwebLink(String base, GitWebType gitWebType) {
        this.baseUrl = base;
        this.type = gitWebType;
    }

    public String toRevision(Project.NameKey project, PatchSet ps) {
        ParamertizedString pattern = new ParamertizedString(this.type.getRevision());
        HashMap<String, String> p = new HashMap<String, String>();
        p.put("project", URL.encodeComponent((String)project.get()));
        p.put("commit", URL.encodeComponent((String)ps.getRevision().get()));
        return this.baseUrl + pattern.replace(p);
    }

    public String toProject(Project.NameKey project) {
        ParamertizedString pattern = new ParamertizedString(this.type.getProject());
        HashMap<String, String> p = new HashMap<String, String>();
        p.put("project", URL.encodeComponent((String)project.get()));
        return this.baseUrl + pattern.replace(p);
    }

    public String toBranch(Branch.NameKey branch) {
        ParamertizedString pattern = new ParamertizedString(this.type.getBranch());
        HashMap<String, String> p = new HashMap<String, String>();
        p.put("project", URL.encodeComponent((String)branch.getParentKey().get()));
        p.put("branch", URL.encodeComponent((String)branch.get()));
        return this.baseUrl + pattern.replace(p);
    }
}

