/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.containers.participant;

import java.util.List;
import org.eclipse.bpmn2.ChoreographyActivity;
import org.eclipse.bpmn2.Lane;
import org.eclipse.bpmn2.modeler.core.features.containers.AbstractResizeContainerFeature;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IResizeShapeFeature;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.context.impl.ResizeShapeContext;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;

public class ResizeParticipantFeature
extends AbstractResizeContainerFeature {
    public ResizeParticipantFeature(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    public boolean canResizeShape(IResizeShapeContext context) {
        PictogramElement containerElem;
        EObject container = context.getShape().eContainer();
        if (container instanceof PictogramElement && BusinessObjectUtil.containsElementOfType(containerElem = (PictogramElement)container, ChoreographyActivity.class)) {
            return false;
        }
        return super.canResizeShape(context);
    }

    @Override
    protected void resizeHeight(IResizeShapeContext context) {
        ContainerShape poolShape = (ContainerShape)context.getShape();
        GraphicsAlgorithm ga = poolShape.getGraphicsAlgorithm();
        ContainerShape laneToResize = null;
        GraphicsAlgorithm laneToResizeGA = null;
        int width = 0;
        int height = 0;
        boolean resizeFirstLane = false;
        boolean resize = false;
        if (this.isHorizontal) {
            int dHeight = context.getHeight() - ga.getHeight();
            if (dHeight != 0) {
                resize = true;
                if (context.getY() != ga.getY()) {
                    laneToResize = FeatureSupport.getFirstLaneInContainer(poolShape);
                    resizeFirstLane = true;
                } else {
                    laneToResize = FeatureSupport.getLastLaneInContainer(poolShape);
                }
                laneToResizeGA = laneToResize.getGraphicsAlgorithm();
                width = laneToResizeGA.getWidth();
                height = laneToResizeGA.getHeight() + dHeight;
            }
        } else {
            int dWidth = context.getWidth() - ga.getWidth();
            if (dWidth != 0) {
                resize = true;
                if (context.getX() != ga.getX()) {
                    laneToResize = FeatureSupport.getFirstLaneInContainer(poolShape);
                    resizeFirstLane = true;
                } else {
                    laneToResize = FeatureSupport.getLastLaneInContainer(poolShape);
                }
                laneToResizeGA = laneToResize.getGraphicsAlgorithm();
                width = laneToResizeGA.getWidth() + dWidth;
                height = laneToResizeGA.getHeight();
            }
        }
        if (resize) {
            ResizeShapeContext newContext = new ResizeShapeContext(laneToResize);
            newContext.setX(laneToResizeGA.getX());
            newContext.setY(laneToResizeGA.getY());
            newContext.setHeight(height);
            newContext.setWidth(width);
            newContext.setDirection(context.getDirection());
            newContext.putProperty((Object)"pool.resize", (Object)true);
            newContext.putProperty((Object)"resize.first.lane", (Object)resizeFirstLane);
            IResizeShapeFeature resizeFeature = this.getFeatureProvider().getResizeShapeFeature((IResizeShapeContext)newContext);
            if (resizeFeature.canResizeShape((IResizeShapeContext)newContext)) {
                resizeFeature.resizeShape((IResizeShapeContext)newContext);
            }
            if (this.isHorizontal) {
                ((ResizeShapeContext)context).setHeight(ga.getHeight());
            } else {
                ((ResizeShapeContext)context).setWidth(ga.getWidth());
            }
        }
    }

    @Override
    protected void resizeWidth(IResizeShapeContext context) {
        ContainerShape poolShape = (ContainerShape)context.getShape();
        GraphicsAlgorithm ga = poolShape.getGraphicsAlgorithm();
        int dHeight = context.getHeight() - ga.getHeight();
        int dWidth = context.getWidth() - ga.getWidth();
        if (dWidth != 0 && this.isHorizontal || dHeight != 0 && !this.isHorizontal) {
            List<PictogramElement> childrenShapes = BusinessObjectUtil.getChildElementsOfType(poolShape, Lane.class);
            for (PictogramElement currentPicElem : childrenShapes) {
                if (!(currentPicElem instanceof ContainerShape)) continue;
                ContainerShape currentContainerShape = (ContainerShape)currentPicElem;
                GraphicsAlgorithm laneGA = currentContainerShape.getGraphicsAlgorithm();
                ResizeShapeContext newContext = new ResizeShapeContext((Shape)currentContainerShape);
                newContext.setLocation(laneGA.getX(), laneGA.getY());
                if (this.isHorizontal) {
                    newContext.setWidth(laneGA.getWidth() + dWidth);
                    newContext.setHeight(laneGA.getHeight());
                } else {
                    newContext.setHeight(laneGA.getHeight() + dHeight);
                    newContext.setWidth(laneGA.getWidth());
                }
                newContext.setDirection(context.getDirection());
                newContext.putProperty((Object)"pool.resize", (Object)true);
                IResizeShapeFeature resizeFeature = this.getFeatureProvider().getResizeShapeFeature((IResizeShapeContext)newContext);
                if (!resizeFeature.canResizeShape((IResizeShapeContext)newContext)) continue;
                resizeFeature.resizeShape((IResizeShapeContext)newContext);
            }
        }
    }

    @Override
    public void resizeShape(IResizeShapeContext context) {
        this.preResizeShape(context);
        if (BusinessObjectUtil.containsChildElementOfType(context.getPictogramElement(), Lane.class)) {
            this.resizeHeight(context);
            this.resizeWidth(context);
        }
        this.internalResizeShape(context);
        this.postResizeShape(context);
    }
}

