/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.views.outline;

import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.AbstractObjectEditingDialog;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.ObjectEditingDialog;
import org.eclipse.bpmn2.modeler.ui.Activator;
import org.eclipse.bpmn2.modeler.ui.editor.BPMN2Editor;
import org.eclipse.bpmn2.modeler.ui.views.outline.AbstractGraphicsTreeEditPart;
import org.eclipse.bpmn2.modeler.ui.views.outline.BPMN2EditorOutlineTreeViewer;
import org.eclipse.bpmn2.modeler.ui.views.outline.BPMNDiagramTreeEditPartFactory;
import org.eclipse.bpmn2.modeler.ui.views.outline.Messages;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.Viewport;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.parts.ContentOutlinePage;
import org.eclipse.gef.ui.parts.SelectionSynchronizer;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.graphiti.ui.internal.fixed.FixedScrollableThumbnail;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.PageBook;

public class BPMN2EditorOutlinePage
extends ContentOutlinePage
implements IPropertyListener,
IAdaptable {
    public static final int ID_BUSINESS_MODEL_OUTLINE = 0;
    public static final int ID_INTERCHANGE_MODEL_OUTLINE = 1;
    public static final int ID_THUMBNAIL = 2;
    private GraphicalViewer graphicalViewer;
    private ActionRegistry actionRegistry;
    private EditDomain editDomain;
    private KeyHandler keyHandler;
    private SelectionSynchronizer selectionSynchronizer;
    private DiagramEditor diagramEditor;
    private FixedScrollableThumbnail thumbnail;
    private IAction showBusinessModelOutlineAction;
    private IAction showInterchangeModelOutlineAction;
    private IAction showOverviewAction;
    private PageBook pageBook;
    private Tree businessModelOutline;
    private Tree interchangeModelOutline;
    private EditPartFactory businessModelEditPartFactory;
    private EditPartFactory interchangeModelEditPartFactory;
    private Canvas overview;

    public BPMN2EditorOutlinePage(DiagramEditor diagramEditor) {
        super((EditPartViewer)new BPMN2EditorOutlineTreeViewer(diagramEditor));
        this.graphicalViewer = diagramEditor.getGraphicalViewer();
        this.actionRegistry = (ActionRegistry)diagramEditor.getAdapter(ActionRegistry.class);
        this.editDomain = diagramEditor.getEditDomain();
        this.keyHandler = (KeyHandler)diagramEditor.getAdapter(KeyHandler.class);
        this.selectionSynchronizer = (SelectionSynchronizer)diagramEditor.getAdapter(SelectionSynchronizer.class);
        this.diagramEditor = diagramEditor;
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
    }

    public void createControl(Composite parent) {
        this.pageBook = new PageBook(parent, 0);
        this.businessModelOutline = (Tree)this.getViewer().createControl((Composite)this.pageBook);
        this.interchangeModelOutline = (Tree)this.getViewer().createControl((Composite)this.pageBook);
        this.overview = new Canvas((Composite)this.pageBook, 0);
        this.createOutlineViewer();
        this.selectionSynchronizer.addViewer(this.getViewer());
        this.diagramEditor.addPropertyListener((IPropertyListener)this);
        this.addContextMenu(this.getViewer());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.bpmn2.modeler.help.Outline_View");
    }

    private void addContextMenu(final EditPartViewer viewer) {
        viewer.getControl().addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                for (Object p : viewer.getSelectedEditParts()) {
                    Object model;
                    if (!(p instanceof AbstractGraphicsTreeEditPart) || !((model = ((AbstractGraphicsTreeEditPart)((Object)p)).getModel()) instanceof EObject)) continue;
                    ObjectEditingDialog dialog = new ObjectEditingDialog(BPMN2EditorOutlinePage.this.diagramEditor, (EObject)model);
                    ObjectEditingDialog.openWithTransaction((AbstractObjectEditingDialog)dialog);
                }
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
    }

    private void removeKeyListeners(Tree tree) {
        Listener l;
        Listener[] listenerArray = tree.getListeners(2);
        int n = listenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            l = listenerArray[n2];
            tree.removeListener(2, l);
            ++n2;
        }
        listenerArray = tree.getListeners(1);
        n = listenerArray.length;
        n2 = 0;
        while (n2 < n) {
            l = listenerArray[n2];
            tree.removeListener(1, l);
            ++n2;
        }
    }

    public void dispose() {
        this.selectionSynchronizer.removeViewer(this.getViewer());
        this.diagramEditor.removePropertyListener((IPropertyListener)this);
        if (this.thumbnail != null) {
            this.thumbnail.deactivate();
        }
        super.dispose();
    }

    public Control getControl() {
        return this.pageBook;
    }

    public void propertyChanged(Object source, int propId) {
        this.refresh();
    }

    public Object getAdapter(Class key) {
        if (key == BPMN2Editor.class) {
            return this.diagramEditor;
        }
        if (this.diagramEditor != null) {
            return this.diagramEditor.getAdapter(key);
        }
        return null;
    }

    protected void showPage(int id) {
        if (id == 0) {
            if (this.businessModelEditPartFactory == null) {
                this.businessModelEditPartFactory = new BPMNDiagramTreeEditPartFactory(0);
            }
            this.getViewer().setEditPartFactory(this.businessModelEditPartFactory);
            this.getViewer().setControl((Control)this.businessModelOutline);
            Diagram diagram = this.diagramEditor.getDiagramTypeProvider().getDiagram();
            this.getViewer().setContents((Object)diagram);
            this.showBusinessModelOutlineAction.setChecked(true);
            this.showInterchangeModelOutlineAction.setChecked(false);
            this.showOverviewAction.setChecked(false);
            this.pageBook.showPage((Control)this.businessModelOutline);
            this.removeKeyListeners(this.businessModelOutline);
        } else if (id == 1) {
            if (this.interchangeModelEditPartFactory == null) {
                this.interchangeModelEditPartFactory = new BPMNDiagramTreeEditPartFactory(1);
            }
            this.getViewer().setEditPartFactory(this.interchangeModelEditPartFactory);
            this.getViewer().setControl((Control)this.interchangeModelOutline);
            Diagram diagram = this.diagramEditor.getDiagramTypeProvider().getDiagram();
            this.getViewer().setContents((Object)diagram);
            this.showBusinessModelOutlineAction.setChecked(false);
            this.showInterchangeModelOutlineAction.setChecked(true);
            this.showOverviewAction.setChecked(false);
            this.pageBook.showPage((Control)this.interchangeModelOutline);
            this.removeKeyListeners(this.interchangeModelOutline);
        } else if (id == 2) {
            if (this.thumbnail == null) {
                this.createThumbnailViewer();
            }
            this.showBusinessModelOutlineAction.setChecked(false);
            this.showInterchangeModelOutlineAction.setChecked(false);
            this.showOverviewAction.setChecked(true);
            this.pageBook.showPage((Control)this.overview);
        }
    }

    protected void createOutlineViewer() {
        this.getViewer().setEditDomain(this.editDomain);
        this.getViewer().setKeyHandler(this.keyHandler);
        ContextMenuProvider contextMenuProvider = this.createContextMenuProvider();
        if (contextMenuProvider != null) {
            this.getViewer().setContextMenu((MenuManager)contextMenuProvider);
        }
        IToolBarManager tbm = this.getSite().getActionBars().getToolBarManager();
        this.showBusinessModelOutlineAction = new Action(){

            public void run() {
                BPMN2EditorOutlinePage.this.showPage(0);
            }
        };
        this.showBusinessModelOutlineAction.setImageDescriptor(Activator.getDefault().getImageDescriptor("20/BusinessModel.png"));
        this.showBusinessModelOutlineAction.setToolTipText(Messages.BPMN2EditorOutlinePage_Business_Model_Title);
        tbm.add(this.showBusinessModelOutlineAction);
        this.showInterchangeModelOutlineAction = new Action(){

            public void run() {
                BPMN2EditorOutlinePage.this.showPage(1);
            }
        };
        this.showInterchangeModelOutlineAction.setImageDescriptor(Activator.getDefault().getImageDescriptor("20/InterchangeModel.png"));
        this.showInterchangeModelOutlineAction.setToolTipText(Messages.BPMN2EditorOutlinePage_DI_Model_Title);
        tbm.add(this.showInterchangeModelOutlineAction);
        this.showOverviewAction = new Action(){

            public void run() {
                BPMN2EditorOutlinePage.this.showPage(2);
            }
        };
        this.showOverviewAction.setImageDescriptor(Activator.getDefault().getImageDescriptor("20/Thumbnail.png"));
        this.showOverviewAction.setToolTipText(Messages.BPMN2EditorOutlinePage_Thumbnail_Title);
        tbm.add(this.showOverviewAction);
        this.showPage(0);
    }

    protected ContextMenuProvider createContextMenuProvider() {
        return null;
    }

    protected void createThumbnailViewer() {
        LightweightSystem lws = new LightweightSystem(this.overview);
        ScalableFreeformRootEditPart rootEditPart = (ScalableFreeformRootEditPart)this.graphicalViewer.getRootEditPart();
        this.thumbnail = new FixedScrollableThumbnail((Viewport)rootEditPart.getFigure());
        this.thumbnail.setBorder((Border)new MarginBorder(3));
        this.thumbnail.setSource(rootEditPart.getLayer((Object)"Printable Layers"));
        lws.setContents((IFigure)this.thumbnail);
    }

    private void registerGlobalActionHandler(IActionBars actionBars, String id) {
        IAction action = this.actionRegistry.getAction((Object)id);
        if (action != null) {
            actionBars.setGlobalActionHandler(id, action);
        }
    }

    void refresh() {
        try {
            EditPartViewer viewer = this.getViewer();
            EditPart contents = viewer.getContents();
            if (contents != null) {
                contents.refresh();
            }
        }
        catch (Exception exception) {}
    }
}

