/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.testsrunner.internal.launcher;

import java.io.InputStream;
import java.util.Map;
import org.eclipse.cdt.dsf.gdb.launching.GDBProcess;
import org.eclipse.cdt.dsf.gdb.launching.InferiorRuntimeProcess;
import org.eclipse.cdt.testsrunner.internal.TestsRunnerPlugin;
import org.eclipse.cdt.testsrunner.internal.launcher.ProcessWrapper;
import org.eclipse.cdt.testsrunner.internal.launcher.TestsRunnerProviderInfo;
import org.eclipse.cdt.testsrunner.internal.model.TestingSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.IProcessFactory;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.RuntimeProcess;

public class TestingProcessFactory
implements IProcessFactory {
    private Process wrapProcess(ILaunch launch, Process process) throws CoreException {
        TestingSession testingSession = TestsRunnerPlugin.getDefault().getTestingSessionsManager().newSession(launch);
        TestsRunnerProviderInfo testsRunnerProvider = testingSession.getTestsRunnerProviderInfo();
        InputStream iStream = testsRunnerProvider.isOutputStreamRequired() ? process.getInputStream() : (testsRunnerProvider.isErrorStreamRequired() ? process.getErrorStream() : null);
        ProcessWrapper processWrapper = new ProcessWrapper(process, testsRunnerProvider.isOutputStreamRequired(), testsRunnerProvider.isErrorStreamRequired());
        Thread t = new Thread(new TestingSessionRunner(testingSession, iStream, processWrapper));
        t.start();
        return processWrapper;
    }

    public IProcess newProcess(ILaunch launch, Process process, String label, Map attributes) {
        block5: {
            try {
                if (attributes != null) {
                    Object processTypeCreationAttrValue = attributes.get("org.eclipse.cdt.dsf.gdb.createProcessType");
                    if ("org.eclipse.cdt.dsf.gdb.gdbProcess".equals(processTypeCreationAttrValue)) {
                        return new GDBProcess(launch, process, label, attributes);
                    }
                    if ("org.eclipse.cdt.dsf.gdb.inferiorProcess".equals(processTypeCreationAttrValue)) {
                        return new InferiorRuntimeProcess(launch, this.wrapProcess(launch, process), label, attributes);
                    }
                    break block5;
                }
                return new RuntimeProcess(launch, this.wrapProcess(launch, process), label, attributes);
            }
            catch (CoreException e) {
                TestsRunnerPlugin.log(e);
            }
        }
        return null;
    }

    private class TestingSessionRunner
    implements Runnable {
        private TestingSession testingSession;
        private InputStream iStream;
        private ProcessWrapper processWrapper;

        TestingSessionRunner(TestingSession testingSession, InputStream iStream, ProcessWrapper processWrapper) {
            this.testingSession = testingSession;
            this.iStream = iStream;
            this.processWrapper = processWrapper;
        }

        @Override
        public void run() {
            try {
                this.testingSession.run(this.iStream);
            }
            finally {
                this.processWrapper.allowStreamsClosing();
            }
        }
    }
}

