/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.ast.impl;

import java.util.Collection;
import org.eclipse.dltk.tcl.ast.ArgumentMatch;
import org.eclipse.dltk.tcl.ast.AstPackage;
import org.eclipse.dltk.tcl.ast.TclArgument;
import org.eclipse.dltk.tcl.ast.TclCommand;
import org.eclipse.dltk.tcl.ast.impl.NodeImpl;
import org.eclipse.dltk.tcl.definitions.Command;
import org.eclipse.dltk.tcl.parser.printer.SimpleCodePrinter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

public class TclCommandImpl
extends NodeImpl
implements TclCommand {
    protected TclArgument name;
    protected EList<TclArgument> arguments;
    protected Command definition;
    protected EList<ArgumentMatch> matches;
    protected static final String QUALIFIED_NAME_EDEFAULT = null;
    protected String qualifiedName = QUALIFIED_NAME_EDEFAULT;
    protected static final boolean MATCHED_EDEFAULT = false;
    protected boolean matched = false;

    protected TclCommandImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return AstPackage.Literals.TCL_COMMAND;
    }

    @Override
    public TclArgument getName() {
        return this.name;
    }

    public NotificationChain basicSetName(TclArgument newName, NotificationChain msgs) {
        TclArgument oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldName, (Object)newName);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setName(TclArgument newName) {
        if (newName != this.name) {
            NotificationChain msgs = null;
            if (this.name != null) {
                msgs = ((InternalEObject)this.name).eInverseRemove((InternalEObject)this, -3, null, msgs);
            }
            if (newName != null) {
                msgs = ((InternalEObject)newName).eInverseAdd((InternalEObject)this, -3, null, msgs);
            }
            if ((msgs = this.basicSetName(newName, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)newName, (Object)newName));
        }
    }

    @Override
    public EList<TclArgument> getArguments() {
        if (this.arguments == null) {
            this.arguments = new EObjectContainmentEList(TclArgument.class, (InternalEObject)this, 3);
        }
        return this.arguments;
    }

    @Override
    public Command getDefinition() {
        if (this.definition != null && this.definition.eIsProxy()) {
            InternalEObject oldDefinition = (InternalEObject)this.definition;
            this.definition = (Command)this.eResolveProxy(oldDefinition);
            if (this.definition != oldDefinition && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 4, (Object)oldDefinition, (Object)this.definition));
            }
        }
        return this.definition;
    }

    public Command basicGetDefinition() {
        return this.definition;
    }

    @Override
    public void setDefinition(Command newDefinition) {
        Command oldDefinition = this.definition;
        this.definition = newDefinition;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldDefinition, (Object)this.definition));
        }
    }

    @Override
    public EList<ArgumentMatch> getMatches() {
        if (this.matches == null) {
            this.matches = new EObjectContainmentEList(ArgumentMatch.class, (InternalEObject)this, 5);
        }
        return this.matches;
    }

    @Override
    public String getQualifiedName() {
        return this.qualifiedName;
    }

    @Override
    public void setQualifiedName(String newQualifiedName) {
        String oldQualifiedName = this.qualifiedName;
        this.qualifiedName = newQualifiedName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldQualifiedName, (Object)this.qualifiedName));
        }
    }

    @Override
    public boolean isMatched() {
        return this.matched;
    }

    @Override
    public void setMatched(boolean newMatched) {
        boolean oldMatched = this.matched;
        this.matched = newMatched;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, oldMatched, this.matched));
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 2: {
                return this.basicSetName(null, msgs);
            }
            case 3: {
                return ((InternalEList)this.getArguments()).basicRemove((Object)otherEnd, msgs);
            }
            case 5: {
                return ((InternalEList)this.getMatches()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 2: {
                return this.getName();
            }
            case 3: {
                return this.getArguments();
            }
            case 4: {
                if (resolve) {
                    return this.getDefinition();
                }
                return this.basicGetDefinition();
            }
            case 5: {
                return this.getMatches();
            }
            case 6: {
                return this.getQualifiedName();
            }
            case 7: {
                return this.isMatched();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.setName((TclArgument)newValue);
                return;
            }
            case 3: {
                this.getArguments().clear();
                this.getArguments().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.setDefinition((Command)newValue);
                return;
            }
            case 5: {
                this.getMatches().clear();
                this.getMatches().addAll((Collection)newValue);
                return;
            }
            case 6: {
                this.setQualifiedName((String)newValue);
                return;
            }
            case 7: {
                this.setMatched((Boolean)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.setName(null);
                return;
            }
            case 3: {
                this.getArguments().clear();
                return;
            }
            case 4: {
                this.setDefinition(null);
                return;
            }
            case 5: {
                this.getMatches().clear();
                return;
            }
            case 6: {
                this.setQualifiedName(QUALIFIED_NAME_EDEFAULT);
                return;
            }
            case 7: {
                this.setMatched(false);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 2: {
                return this.name != null;
            }
            case 3: {
                return this.arguments != null && !this.arguments.isEmpty();
            }
            case 4: {
                return this.definition != null;
            }
            case 5: {
                return this.matches != null && !this.matches.isEmpty();
            }
            case 6: {
                return QUALIFIED_NAME_EDEFAULT == null ? this.qualifiedName != null : !QUALIFIED_NAME_EDEFAULT.equals(this.qualifiedName);
            }
            case 7: {
                return this.matched;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (qualifiedName: ");
        result.append(this.qualifiedName);
        result.append(", matched: ");
        result.append(this.matched);
        result.append(')');
        result.append("\n{");
        result.append(SimpleCodePrinter.getCommandString(this, this.getStart()));
        result.append("}");
        return result.toString();
    }
}

