/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.useradmin;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.eclipse.equinox.internal.useradmin.Group;
import org.eclipse.equinox.internal.useradmin.LogTracker;
import org.eclipse.equinox.internal.useradmin.Role;
import org.eclipse.equinox.internal.useradmin.User;
import org.eclipse.equinox.internal.useradmin.UserAdmin;
import org.eclipse.equinox.internal.useradmin.UserAdminHashtable;
import org.eclipse.equinox.internal.useradmin.UserAdminMsg;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.osgi.service.prefs.PreferencesService;

public class UserAdminStore {
    protected static final String propertiesNode = "properties";
    protected static final String credentialsNode = "credentials";
    protected static final String membersNode = "members";
    private static final String typesNode = "types";
    protected static final String basicString = "basic";
    protected static final String requiredString = "required";
    protected static final String typeString = "type";
    protected static final String persistenceUserName = "UserAdmin";
    protected ServiceReference prefsRef;
    protected ServiceRegistration userAdminListenerReg;
    protected UserAdmin useradmin;
    protected LogTracker log;
    protected Preferences rootNode;
    protected PreferencesService preferencesService;

    protected UserAdminStore(PreferencesService preferencesService, UserAdmin useradmin, LogTracker log) {
        this.preferencesService = preferencesService;
        this.useradmin = useradmin;
        this.log = log;
    }

    protected void init() throws BackingStoreException {
        try {
            AccessController.doPrivileged(() -> {
                this.rootNode = this.preferencesService.getUserPreferences(persistenceUserName);
                this.loadRoles();
                return null;
            });
        }
        catch (PrivilegedActionException ex) {
            throw (BackingStoreException)ex.getException();
        }
    }

    protected void addRole(org.osgi.service.useradmin.Role role) throws BackingStoreException {
        try {
            AccessController.doPrivileged(() -> {
                Preferences node = this.rootNode.node(role.getName());
                node.putInt(typeString, role.getType());
                node.flush();
                return null;
            });
        }
        catch (PrivilegedActionException ex) {
            this.log.log(1, UserAdminMsg.Backing_Store_Write_Exception, ex);
            throw (BackingStoreException)ex.getException();
        }
    }

    protected void removeRole(org.osgi.service.useradmin.Role role) throws BackingStoreException {
        try {
            AccessController.doPrivileged(() -> {
                Preferences node = this.rootNode.node(role.getName());
                node.removeNode();
                this.rootNode.node("").flush();
                return null;
            });
        }
        catch (PrivilegedActionException ex) {
            this.log.log(1, UserAdminMsg.Backing_Store_Write_Exception, ex);
            throw (BackingStoreException)ex.getException();
        }
    }

    protected void clearProperties(org.osgi.service.useradmin.Role role) throws BackingStoreException {
        try {
            AccessController.doPrivileged(() -> {
                Preferences propertyNode = this.rootNode.node(String.valueOf(role.getName()) + "/" + propertiesNode);
                propertyNode.clear();
                if (propertyNode.nodeExists(typesNode)) {
                    propertyNode.node(typesNode).removeNode();
                }
                propertyNode.flush();
                return null;
            });
        }
        catch (PrivilegedActionException ex) {
            this.log.log(1, UserAdminMsg.Backing_Store_Write_Exception, ex);
            throw (BackingStoreException)ex.getException();
        }
    }

    protected void addProperty(org.osgi.service.useradmin.Role role, String key, Object value) throws BackingStoreException {
        try {
            AccessController.doPrivileged(() -> {
                Preferences propertyNode = this.rootNode.node(String.valueOf(role.getName()) + "/" + propertiesNode);
                Preferences propertyTypesNode = propertyNode.node(typesNode);
                if (value instanceof String) {
                    propertyNode.put(key, (String)value);
                    propertyTypesNode.putBoolean(key, true);
                } else {
                    propertyNode.putByteArray(key, (byte[])value);
                    propertyTypesNode.putBoolean(key, false);
                }
                propertyNode.flush();
                return null;
            });
        }
        catch (PrivilegedActionException ex) {
            this.log.log(1, UserAdminMsg.Backing_Store_Write_Exception, ex);
            throw (BackingStoreException)ex.getException();
        }
    }

    protected void removeProperty(org.osgi.service.useradmin.Role role, String key) throws BackingStoreException {
        try {
            AccessController.doPrivileged(() -> {
                Preferences propertyNode = this.rootNode.node(String.valueOf(role.getName()) + "/" + propertiesNode);
                propertyNode.remove(key);
                if (propertyNode.nodeExists(typesNode)) {
                    propertyNode.node(typesNode).remove(key);
                }
                propertyNode.flush();
                return null;
            });
        }
        catch (PrivilegedActionException ex) {
            this.log.log(1, UserAdminMsg.Backing_Store_Write_Exception, ex);
            throw (BackingStoreException)ex.getException();
        }
    }

    protected void clearCredentials(org.osgi.service.useradmin.Role role) throws BackingStoreException {
        try {
            AccessController.doPrivileged(() -> {
                Preferences credentialNode = this.rootNode.node(String.valueOf(role.getName()) + "/" + credentialsNode);
                credentialNode.clear();
                if (credentialNode.nodeExists(typesNode)) {
                    credentialNode.node(typesNode).removeNode();
                }
                credentialNode.flush();
                return null;
            });
        }
        catch (PrivilegedActionException ex) {
            this.log.log(1, UserAdminMsg.Backing_Store_Write_Exception, ex);
            throw (BackingStoreException)ex.getException();
        }
    }

    protected void addCredential(org.osgi.service.useradmin.Role role, String key, Object value) throws BackingStoreException {
        try {
            AccessController.doPrivileged(() -> {
                Preferences credentialNode = this.rootNode.node(String.valueOf(role.getName()) + "/" + credentialsNode);
                Preferences credentialTypesNode = credentialNode.node(typesNode);
                if (value instanceof String) {
                    credentialNode.put(key, (String)value);
                    credentialTypesNode.putBoolean(key, true);
                } else {
                    credentialNode.putByteArray(key, (byte[])value);
                    credentialTypesNode.putBoolean(key, false);
                }
                credentialNode.flush();
                return null;
            });
        }
        catch (PrivilegedActionException ex) {
            this.log.log(1, NLS.bind((String)UserAdminMsg.Backing_Store_Write_Exception, (Object[])new Object[]{NLS.bind((String)UserAdminMsg.adding_Credential_to__15, (Object)role.getName())}), ex);
            throw (BackingStoreException)ex.getException();
        }
    }

    protected void removeCredential(org.osgi.service.useradmin.Role role, String key) throws BackingStoreException {
        try {
            AccessController.doPrivileged(() -> {
                Preferences credentialNode = this.rootNode.node(String.valueOf(role.getName()) + "/" + credentialsNode);
                credentialNode.remove(key);
                if (credentialNode.nodeExists(typesNode)) {
                    credentialNode.node(typesNode).remove(key);
                }
                credentialNode.flush();
                return null;
            });
        }
        catch (PrivilegedActionException ex) {
            this.log.log(1, UserAdminMsg.Backing_Store_Write_Exception, ex);
            throw (BackingStoreException)ex.getException();
        }
    }

    protected void addMember(Group group, Role role) throws BackingStoreException {
        try {
            AccessController.doPrivileged(() -> {
                Preferences memberNode = this.rootNode.node(String.valueOf(group.getName()) + "/" + membersNode);
                memberNode.put(role.getName(), basicString);
                memberNode.flush();
                return null;
            });
        }
        catch (PrivilegedActionException ex) {
            this.log.log(1, NLS.bind((String)UserAdminMsg.Backing_Store_Write_Exception, (Object[])new Object[]{NLS.bind((String)UserAdminMsg.adding_member__18, (Object)role.getName(), (Object)group.getName())}), ex);
            throw (BackingStoreException)ex.getException();
        }
    }

    protected void addRequiredMember(Group group, Role role) throws BackingStoreException {
        try {
            AccessController.doPrivileged(() -> {
                Preferences memberNode = this.rootNode.node(String.valueOf(group.getName()) + "/" + membersNode);
                memberNode.put(role.getName(), requiredString);
                memberNode.flush();
                return null;
            });
        }
        catch (PrivilegedActionException ex) {
            this.log.log(1, NLS.bind((String)UserAdminMsg.Backing_Store_Write_Exception, (Object[])new Object[]{NLS.bind((String)UserAdminMsg.adding_required_member__21, (Object)role.getName(), (Object)group.getName())}), ex);
            throw (BackingStoreException)ex.getException();
        }
    }

    protected void removeMember(Group group, Role role) throws BackingStoreException {
        try {
            AccessController.doPrivileged(() -> {
                Preferences memberNode = this.rootNode.node(String.valueOf(group.getName()) + "/" + membersNode);
                memberNode.remove(role.getName());
                memberNode.flush();
                return null;
            });
        }
        catch (PrivilegedActionException ex) {
            this.log.log(1, NLS.bind((String)UserAdminMsg.Backing_Store_Write_Exception, (Object[])new Object[]{NLS.bind((String)UserAdminMsg.removing_member__24, (Object)role.getName(), (Object)group.getName())}), ex);
            throw (BackingStoreException)ex.getException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadRoles() throws BackingStoreException {
        UserAdminStore userAdminStore = this;
        synchronized (userAdminStore) {
            this.createAnonRole();
            String[] children = this.rootNode.node("").childrenNames();
            int i = 0;
            while (i < children.length) {
                if (this.useradmin.getRole(children[i]) == null) {
                    this.loadRole(this.rootNode.node(children[i]), null);
                }
                ++i;
            }
        }
    }

    protected void loadRole(Preferences node, Role role) throws BackingStoreException {
        Object value;
        int type = node.getInt(typeString, Integer.MIN_VALUE);
        if (type == Integer.MIN_VALUE) {
            String errorString = NLS.bind((String)UserAdminMsg.Backing_Store_Read_Exception, (Object[])new Object[]{NLS.bind((String)UserAdminMsg.Unable_to_load_role__27, (Object)node.name())});
            BackingStoreException ex = new BackingStoreException(errorString);
            this.log.log(1, errorString, ex);
            throw ex;
        }
        if (role == null) {
            role = (Role)this.useradmin.createRole(node.name(), type, false);
        }
        Preferences propsNode = node.node(propertiesNode);
        String[] keys = propsNode.keys();
        UserAdminHashtable properties = (UserAdminHashtable)role.getProperties();
        Preferences propsTypesNode = propsNode.node(typesNode);
        int i = 0;
        while (i < keys.length) {
            value = propsTypesNode.getBoolean(keys[i], true) ? propsNode.get(keys[i], null) : (Object)propsNode.getByteArray(keys[i], null);
            properties.put(keys[i], value, false);
            ++i;
        }
        if (type == 1 || type == 2) {
            Preferences credNode = node.node(credentialsNode);
            Preferences credTypesNode = credNode.node(typesNode);
            keys = credNode.keys();
            UserAdminHashtable credentials = (UserAdminHashtable)((User)role).getCredentials();
            int i2 = 0;
            while (i2 < keys.length) {
                Object credValue = credTypesNode.getBoolean(keys[i2], true) ? credNode.get(keys[i2], null) : (Object)credNode.getByteArray(keys[i2], null);
                credentials.put(keys[i2], credValue, false);
                ++i2;
            }
        }
        if (type == 2) {
            Preferences memberNode = node.node(membersNode);
            keys = memberNode.keys();
            int i3 = 0;
            while (i3 < keys.length) {
                value = memberNode.get(keys[i3], null);
                Role member = (Role)this.useradmin.getRole(keys[i3]);
                if (member == null) {
                    this.loadRole(this.rootNode.node(keys[i3]), null);
                    member = (Role)this.useradmin.getRole(keys[i3]);
                }
                if (value.equals(requiredString)) {
                    ((Group)role).addRequiredMember(member, false);
                } else {
                    ((Group)role).addMember(member, false);
                }
                ++i3;
            }
        }
    }

    protected void destroy() {
        try {
            this.rootNode.flush();
            this.rootNode = null;
            this.preferencesService = null;
        }
        catch (BackingStoreException ex) {
            this.log.log(1, UserAdminMsg.Backing_Store_Write_Exception, ex);
        }
    }

    private void createAnonRole() throws BackingStoreException {
        Role role = null;
        if (!this.rootNode.nodeExists("user.anyone")) {
            role = (Role)this.useradmin.createRole("user.anyone", 0, true);
        }
        if (role != null) {
            this.loadRole(this.rootNode.node("user.anyone"), role);
        } else {
            this.loadRole(this.rootNode.node("user.anyone"), null);
        }
    }
}

