/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.manipulation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.manipulation.CodeStyleConfiguration;
import org.eclipse.jdt.core.manipulation.CoreASTProvider;
import org.eclipse.jdt.core.manipulation.ImportReferencesCollector;
import org.eclipse.jdt.core.manipulation.JavaManipulation;
import org.eclipse.jdt.core.manipulation.TypeNameMatchCollector;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.core.search.TypeNameMatchRequestor;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationMessages;
import org.eclipse.jdt.internal.core.manipulation.Messages;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.core.manipulation.util.Strings;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.text.edits.TextEdit;

public class OrganizeImportsOperation
implements IWorkspaceRunnable {
    private static ImportRewrite.ImportRewriteContext UNRESOLVABLE_IMPORT_CONTEXT = new ImportRewrite.ImportRewriteContext(){

        public int findInContext(String qualifier, String name, int kind) {
            return 4;
        }
    };
    private boolean fDoSave;
    private boolean fIgnoreLowerCaseNames;
    private IChooseImportQuery fChooseImportQuery;
    private int fNumberOfImportsAdded;
    private int fNumberOfImportsRemoved;
    private IProblem fParsingError;
    private ICompilationUnit fCompilationUnit;
    private CompilationUnit fASTRoot;
    private final boolean fAllowSyntaxErrors;

    public OrganizeImportsOperation(ICompilationUnit cu, CompilationUnit astRoot, boolean ignoreLowerCaseNames, boolean save, boolean allowSyntaxErrors, IChooseImportQuery chooseImportQuery) {
        this.fCompilationUnit = cu;
        this.fASTRoot = astRoot;
        this.fDoSave = save;
        this.fIgnoreLowerCaseNames = ignoreLowerCaseNames;
        this.fAllowSyntaxErrors = allowSyntaxErrors;
        this.fChooseImportQuery = chooseImportQuery;
        this.fNumberOfImportsAdded = 0;
        this.fNumberOfImportsRemoved = 0;
        this.fParsingError = null;
    }

    public void run(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.format(JavaManipulationMessages.OrganizeImportsOperation_description, BasicElementLabels.getFileName((ITypeRoot)this.fCompilationUnit)), (int)10);
        TextEdit edit = this.createTextEdit((IProgressMonitor)subMonitor.split(9));
        if (edit == null) {
            return;
        }
        JavaModelUtil.applyEdit(this.fCompilationUnit, edit, this.fDoSave, (IProgressMonitor)subMonitor.split(1));
    }

    public TextEdit createTextEdit(IProgressMonitor m) throws CoreException, OperationCanceledException {
        HashSet<String> oldDemandImports;
        HashSet<String> oldSingleImports;
        ArrayList<SimpleName> staticReferences;
        ArrayList<SimpleName> typeReferences;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)m, (String)Messages.format(JavaManipulationMessages.OrganizeImportsOperation_description, BasicElementLabels.getFileName((ITypeRoot)this.fCompilationUnit)), (int)9);
        this.fNumberOfImportsAdded = 0;
        this.fNumberOfImportsRemoved = 0;
        CompilationUnit astRoot = this.fASTRoot;
        if (astRoot == null) {
            astRoot = CoreASTProvider.getInstance().getAST((ITypeRoot)this.fCompilationUnit, CoreASTProvider.WAIT_YES, (IProgressMonitor)subMonitor.split(2));
        }
        subMonitor.setWorkRemaining(7);
        ImportRewrite importsRewrite = CodeStyleConfiguration.createImportRewrite(astRoot, false);
        if (astRoot.getAST().hasResolvedBindings()) {
            importsRewrite.setUseContextToFilterImplicitImports(true);
        }
        if (!this.collectReferences(astRoot, typeReferences = new ArrayList<SimpleName>(), staticReferences = new ArrayList<SimpleName>(), oldSingleImports = new HashSet<String>(), oldDemandImports = new HashSet<String>())) {
            return null;
        }
        subMonitor.split(1);
        UnresolvableImportMatcher unresolvableImportMatcher = UnresolvableImportMatcher.forCompilationUnit(astRoot);
        TypeReferenceProcessor processor = new TypeReferenceProcessor(oldSingleImports, oldDemandImports, astRoot, importsRewrite, this.fIgnoreLowerCaseNames, unresolvableImportMatcher);
        for (SimpleName typeRef : typeReferences) {
            processor.add(typeRef);
        }
        boolean hasOpenChoices = processor.process((IProgressMonitor)subMonitor.split(3));
        this.addStaticImports(staticReferences, importsRewrite, unresolvableImportMatcher);
        if (hasOpenChoices && this.fChooseImportQuery != null) {
            ISourceRange[] ranges;
            TypeNameMatch[][] choices = processor.getChoices();
            TypeNameMatch[] chosen = this.fChooseImportQuery.chooseImports(choices, ranges = processor.getChoicesSourceRanges());
            if (chosen == null) {
                throw new OperationCanceledException();
            }
            int i = 0;
            while (i < chosen.length) {
                TypeNameMatch typeInfo = chosen[i];
                if (typeInfo != null) {
                    importsRewrite.addImport(typeInfo.getFullyQualifiedName());
                } else {
                    String typeName = choices[i][0].getSimpleTypeName();
                    Set<String> matchingUnresolvableImports = unresolvableImportMatcher.matchTypeImports(typeName);
                    if (!matchingUnresolvableImports.isEmpty()) {
                        for (String string : matchingUnresolvableImports) {
                            importsRewrite.addImport(string, UNRESOLVABLE_IMPORT_CONTEXT);
                        }
                    }
                }
                ++i;
            }
        }
        TextEdit result = importsRewrite.rewriteImports((IProgressMonitor)subMonitor.split(3));
        this.determineImportDifferences(importsRewrite, oldSingleImports, oldDemandImports);
        return result;
    }

    private void determineImportDifferences(ImportRewrite importsStructure, Set<String> oldSingleImports, Set<String> oldDemandImports) {
        String importName;
        Object element;
        ArrayList<String> importsAdded = new ArrayList<String>(importsStructure.getCreatedImports().length + importsStructure.getCreatedStaticImports().length);
        importsAdded.addAll(Arrays.asList(importsStructure.getCreatedImports()));
        importsAdded.addAll(Arrays.asList(importsStructure.getCreatedStaticImports()));
        Object[] objectArray = oldSingleImports.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            element = objectArray[n2];
            importName = (String)element;
            if (importsAdded.remove(importName)) {
                oldSingleImports.remove(importName);
            }
            ++n2;
        }
        objectArray = oldDemandImports.toArray();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            element = objectArray[n2];
            importName = (String)element;
            if (importsAdded.remove(String.valueOf(importName) + ".*")) {
                oldDemandImports.remove(importName);
            }
            ++n2;
        }
        this.fNumberOfImportsAdded = importsAdded.size();
        this.fNumberOfImportsRemoved = oldSingleImports.size() + oldDemandImports.size();
    }

    private void addStaticImports(Collection<SimpleName> staticReferences, ImportRewrite importRewrite, UnresolvableImportMatcher unresolvableImportMatcher) {
        for (SimpleName name : staticReferences) {
            IBinding binding = name.resolveBinding();
            if (binding != null) {
                importRewrite.addStaticImport(binding);
                continue;
            }
            String identifier = name.getIdentifier();
            Set<String> unresolvableImports = unresolvableImportMatcher.matchStaticImports(identifier);
            for (String unresolvableImport : unresolvableImports) {
                int lastDotIndex = unresolvableImport.lastIndexOf(46);
                if (lastDotIndex == -1) continue;
                String declaringTypeName = unresolvableImport.substring(0, lastDotIndex);
                String simpleName = unresolvableImport.substring(lastDotIndex + 1);
                boolean isField = false;
                importRewrite.addStaticImport(declaringTypeName, simpleName, isField, UNRESOLVABLE_IMPORT_CONTEXT);
            }
            if (!unresolvableImports.isEmpty()) continue;
            String pref = JavaManipulation.getPreference("content_assist_favorite_static_members", importRewrite.getCompilationUnit().getJavaProject());
            String[] favourites = pref.split(";");
            if (favourites.length == 0) {
                return;
            }
            try {
                boolean isMethod = name.getParent() instanceof MethodInvocation;
                ICompilationUnit cu = importRewrite.getCompilationUnit().getPrimary();
                String[] staticFavourites = JavaModelUtil.getStaticImportFavorites(cu, identifier, isMethod, favourites);
                if (staticFavourites.length <= 0) continue;
                String qualifiedTypeName = Signature.getQualifier((String)staticFavourites[0]);
                importRewrite.addStaticImport(qualifiedTypeName, identifier, !isMethod);
            }
            catch (JavaModelException javaModelException) {
                return;
            }
        }
    }

    private boolean collectReferences(CompilationUnit astRoot, List<SimpleName> typeReferences, List<SimpleName> staticReferences, Set<String> oldSingleImports, Set<String> oldDemandImports) {
        if (!this.fAllowSyntaxErrors) {
            IProblem[] iProblemArray = astRoot.getProblems();
            int n = iProblemArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProblem curr = iProblemArray[n2];
                if (curr.isError() && (curr.getID() & 0x40000000) != 0) {
                    this.fParsingError = curr;
                    return false;
                }
                ++n2;
            }
        }
        List imports = astRoot.imports();
        for (ImportDeclaration curr : imports) {
            String id = ASTResolving.getFullName(curr.getName());
            if (curr.isOnDemand()) {
                oldDemandImports.add(id);
                continue;
            }
            oldSingleImports.add(id);
        }
        IJavaProject project = this.fCompilationUnit.getJavaProject();
        ImportReferencesCollector.collect((ASTNode)astRoot, project, null, typeReferences, staticReferences);
        return true;
    }

    public IProblem getParseError() {
        return this.fParsingError;
    }

    public int getNumberOfImportsAdded() {
        return this.fNumberOfImportsAdded;
    }

    public int getNumberOfImportsRemoved() {
        return this.fNumberOfImportsRemoved;
    }

    public ISchedulingRule getScheduleRule() {
        return this.fCompilationUnit.getResource();
    }

    public static interface IChooseImportQuery {
        public TypeNameMatch[] chooseImports(TypeNameMatch[][] var1, ISourceRange[] var2);
    }

    private static class TypeReferenceProcessor {
        private Set<String> fOldSingleImports;
        private Set<String> fOldDemandImports;
        private Set<String> fImplicitImports;
        private ImportRewrite fImpStructure;
        private boolean fDoIgnoreLowerCaseNames;
        private final UnresolvableImportMatcher fUnresolvableImportMatcher;
        private IPackageFragment fCurrPackage;
        private ScopeAnalyzer fAnalyzer;
        private boolean fAllowDefaultPackageImports;
        private Map<String, UnresolvedTypeData> fUnresolvedTypes;
        private Set<String> fImportsAdded;
        private TypeNameMatch[][] fOpenChoices;
        private SourceRange[] fSourceRanges;

        public TypeReferenceProcessor(Set<String> oldSingleImports, Set<String> oldDemandImports, CompilationUnit root, ImportRewrite impStructure, boolean ignoreLowerCaseNames, UnresolvableImportMatcher unresolvableImportMatcher) {
            this.fOldSingleImports = oldSingleImports;
            this.fOldDemandImports = oldDemandImports;
            this.fImpStructure = impStructure;
            this.fDoIgnoreLowerCaseNames = ignoreLowerCaseNames;
            this.fUnresolvableImportMatcher = unresolvableImportMatcher;
            ICompilationUnit cu = impStructure.getCompilationUnit();
            this.fImplicitImports = new HashSet<String>(3);
            this.fImplicitImports.add("");
            this.fImplicitImports.add("java.lang");
            this.fImplicitImports.add(cu.getParent().getElementName());
            this.fAnalyzer = new ScopeAnalyzer(root);
            this.fCurrPackage = (IPackageFragment)cu.getParent();
            this.fAllowDefaultPackageImports = "1.3".equals(cu.getJavaProject().getOption("org.eclipse.jdt.core.compiler.source", true));
            this.fImportsAdded = new HashSet<String>();
            this.fUnresolvedTypes = new HashMap<String, UnresolvedTypeData>();
        }

        private boolean needsImport(ITypeBinding typeBinding, SimpleName ref) {
            if (!typeBinding.isTopLevel() && !typeBinding.isMember() || typeBinding.isRecovered()) {
                return false;
            }
            int modifiers = typeBinding.getModifiers();
            if (Modifier.isPrivate((int)modifiers)) {
                return false;
            }
            ITypeBinding currTypeBinding = Bindings.getBindingOfParentType((ASTNode)ref);
            if (currTypeBinding == null) {
                if (ASTNodes.getParent((ASTNode)ref, 35) != null) {
                    return true;
                }
                return ASTNodes.getParent((ASTNode)ref, 93) != null;
            }
            if (!Modifier.isPublic((int)modifiers) && !currTypeBinding.getPackage().getName().equals(typeBinding.getPackage().getName())) {
                return false;
            }
            ASTNode parent = ref.getParent();
            while (parent instanceof Type) {
                parent = parent.getParent();
            }
            if (parent instanceof AbstractTypeDeclaration && parent.getParent() instanceof CompilationUnit) {
                return true;
            }
            return !typeBinding.isMember() || !this.fAnalyzer.isDeclaredInScope((IBinding)typeBinding, ref, 20);
        }

        public void add(SimpleName ref) {
            char ch;
            String typeName = ref.getIdentifier();
            if (this.fImportsAdded.contains(typeName)) {
                return;
            }
            IBinding binding = ref.resolveBinding();
            if (binding != null) {
                if (binding.getKind() != 2) {
                    return;
                }
                ITypeBinding typeBinding = (ITypeBinding)binding;
                if (typeBinding.isArray()) {
                    typeBinding = typeBinding.getElementType();
                }
                if (!(typeBinding = typeBinding.getTypeDeclaration()).isRecovered()) {
                    if (this.needsImport(typeBinding, ref)) {
                        this.fImpStructure.addImport(typeBinding);
                        this.fImportsAdded.add(typeName);
                    }
                    return;
                }
            } else if (this.fDoIgnoreLowerCaseNames && typeName.length() > 0 && Strings.isLowerCase(ch = typeName.charAt(0)) && Character.isLetter(ch)) {
                return;
            }
            this.fImportsAdded.add(typeName);
            this.fUnresolvedTypes.put(typeName, new UnresolvedTypeData(ref));
        }

        public boolean process(IProgressMonitor monitor) throws JavaModelException {
            try {
                int nUnresolved = this.fUnresolvedTypes.size();
                if (nUnresolved == 0) {
                    return false;
                }
                char[][] allTypes = new char[nUnresolved][];
                int i = 0;
                for (String string : this.fUnresolvedTypes.keySet()) {
                    allTypes[i++] = string.toCharArray();
                }
                ArrayList<TypeNameMatch> typesFound = new ArrayList<TypeNameMatch>();
                IJavaProject project = this.fCurrPackage.getJavaProject();
                boolean excludeTestCode = !((IPackageFragmentRoot)this.fCurrPackage.getParent()).getResolvedClasspathEntry().isTest();
                IJavaSearchScope scope = SearchEngine.createJavaSearchScope((boolean)excludeTestCode, (IJavaElement[])new IJavaElement[]{project}, (boolean)true);
                TypeNameMatchCollector collector = new TypeNameMatchCollector(typesFound);
                new SearchEngine().searchAllTypeNames(null, (char[][])allTypes, scope, (TypeNameMatchRequestor)collector, 3, monitor);
                boolean is50OrHigher = JavaModelUtil.is50OrHigher(project);
                for (TypeNameMatch typeNameMatch : typesFound) {
                    UnresolvedTypeData data = this.fUnresolvedTypes.get(typeNameMatch.getSimpleTypeName());
                    if (data == null || !this.isVisible(typeNameMatch) || !this.isOfKind(typeNameMatch, data.typeKinds, is50OrHigher) || !this.fAllowDefaultPackageImports && typeNameMatch.getPackageName().length() <= 0) continue;
                    data.addInfo(typeNameMatch);
                }
                for (Map.Entry entry : this.fUnresolvedTypes.entrySet()) {
                    Set<String> matchingUnresolvableImports;
                    if (!((UnresolvedTypeData)entry.getValue()).foundInfos.isEmpty() || (matchingUnresolvableImports = this.fUnresolvableImportMatcher.matchTypeImports((String)entry.getKey())).isEmpty()) continue;
                    for (String string : matchingUnresolvableImports) {
                        this.fImpStructure.addImport(string, UNRESOLVABLE_IMPORT_CONTEXT);
                    }
                }
                ArrayList<TypeNameMatch[]> arrayList = new ArrayList<TypeNameMatch[]>(nUnresolved);
                ArrayList<SourceRange> sourceRanges = new ArrayList<SourceRange>(nUnresolved);
                for (UnresolvedTypeData data : this.fUnresolvedTypes.values()) {
                    TypeNameMatch[] openChoice = this.processTypeInfo(data.foundInfos);
                    if (openChoice == null) continue;
                    arrayList.add(openChoice);
                    sourceRanges.add(new SourceRange(data.ref.getStartPosition(), data.ref.getLength()));
                }
                if (arrayList.isEmpty()) {
                    return false;
                }
                this.fOpenChoices = (TypeNameMatch[][])arrayList.toArray((T[])new TypeNameMatch[arrayList.size()][]);
                this.fSourceRanges = sourceRanges.toArray(new SourceRange[sourceRanges.size()]);
                return true;
            }
            finally {
                monitor.done();
            }
        }

        private TypeNameMatch[] processTypeInfo(List<TypeNameMatch> typeRefsFound) {
            int nFound = typeRefsFound.size();
            if (nFound == 0) {
                return null;
            }
            if (nFound == 1) {
                TypeNameMatch typeRef = typeRefsFound.get(0);
                this.fImpStructure.addImport(typeRef.getFullyQualifiedName());
                return null;
            }
            String typeToImport = null;
            boolean ambiguousImports = false;
            int i = 0;
            while (i < nFound) {
                TypeNameMatch typeRef = typeRefsFound.get(i);
                String fullName = typeRef.getFullyQualifiedName();
                String containerName = typeRef.getTypeContainerName();
                if (this.fOldSingleImports.contains(fullName)) {
                    this.fImpStructure.addImport(fullName);
                    return null;
                }
                if (this.fOldDemandImports.contains(containerName) || this.fImplicitImports.contains(containerName)) {
                    if (typeToImport == null) {
                        typeToImport = fullName;
                    } else {
                        ambiguousImports = true;
                    }
                }
                ++i;
            }
            if (typeToImport != null && !ambiguousImports) {
                this.fImpStructure.addImport(typeToImport);
                return null;
            }
            return typeRefsFound.toArray(new TypeNameMatch[nFound]);
        }

        private boolean isOfKind(TypeNameMatch curr, int typeKinds, boolean is50OrHigher) {
            int flags = curr.getModifiers();
            if (Flags.isAnnotation((int)flags)) {
                return is50OrHigher && (typeKinds & 8) != 0;
            }
            if (Flags.isEnum((int)flags)) {
                return is50OrHigher && (typeKinds & 0x10) != 0;
            }
            if (Flags.isInterface((int)flags)) {
                return (typeKinds & 4) != 0;
            }
            return (typeKinds & 2) != 0;
        }

        private boolean isVisible(TypeNameMatch curr) {
            boolean isPublic;
            int flags = curr.getModifiers();
            if (Flags.isPrivate((int)flags)) {
                return false;
            }
            try {
                isPublic = JdtFlags.isPublic((IMember)curr.getType());
            }
            catch (JavaModelException javaModelException) {
                isPublic = Flags.isPublic((int)flags);
            }
            if (isPublic || Flags.isProtected((int)flags)) {
                return true;
            }
            return curr.getPackageName().equals(this.fCurrPackage.getElementName());
        }

        public TypeNameMatch[][] getChoices() {
            return this.fOpenChoices;
        }

        public ISourceRange[] getChoicesSourceRanges() {
            return this.fSourceRanges;
        }

        private static class UnresolvedTypeData {
            final SimpleName ref;
            final int typeKinds;
            final List<TypeNameMatch> foundInfos;

            public UnresolvedTypeData(SimpleName ref) {
                this.ref = ref;
                this.typeKinds = ASTResolving.getPossibleTypeKinds((ASTNode)ref, true);
                this.foundInfos = new ArrayList<TypeNameMatch>(3);
            }

            public void addInfo(TypeNameMatch info) {
                int i = this.foundInfos.size() - 1;
                while (i >= 0) {
                    TypeNameMatch curr = this.foundInfos.get(i);
                    if (curr.getTypeContainerName().equals(info.getTypeContainerName())) {
                        return;
                    }
                    --i;
                }
                this.foundInfos.add(info);
            }
        }
    }

    private static class UnresolvableImportMatcher {
        private final Map<String, Set<String>> fTypeImportsBySimpleName;
        private final Map<String, Set<String>> fStaticImportsBySimpleName;

        static UnresolvableImportMatcher forCompilationUnit(CompilationUnit cu) {
            Collection<ImportDeclaration> unresolvableImports = UnresolvableImportMatcher.determineUnresolvableImports(cu);
            HashMap<String, Set<String>> typeImportsBySimpleName = new HashMap<String, Set<String>>();
            HashMap<String, Set<String>> staticImportsBySimpleName = new HashMap<String, Set<String>>();
            for (ImportDeclaration importDeclaration : unresolvableImports) {
                String qualifiedName = importDeclaration.isOnDemand() ? String.valueOf(importDeclaration.getName().getFullyQualifiedName()) + ".*" : importDeclaration.getName().getFullyQualifiedName();
                String simpleName = qualifiedName.substring(qualifiedName.lastIndexOf(46) + 1);
                HashMap<String, Set<String>> importsBySimpleName = importDeclaration.isStatic() ? staticImportsBySimpleName : typeImportsBySimpleName;
                HashSet<String> importsWithSimpleName = (HashSet<String>)importsBySimpleName.get(simpleName);
                if (importsWithSimpleName == null) {
                    importsWithSimpleName = new HashSet<String>();
                    importsBySimpleName.put(simpleName, importsWithSimpleName);
                }
                importsWithSimpleName.add(qualifiedName);
            }
            return new UnresolvableImportMatcher(typeImportsBySimpleName, staticImportsBySimpleName);
        }

        private static Collection<ImportDeclaration> determineUnresolvableImports(CompilationUnit cu) {
            ArrayList<ImportDeclaration> unresolvableImports = new ArrayList<ImportDeclaration>(cu.imports().size());
            IProblem[] iProblemArray = cu.getProblems();
            int n = iProblemArray.length;
            int n2 = 0;
            while (n2 < n) {
                ImportDeclaration problematicImport;
                IProblem problem = iProblemArray[n2];
                if (problem.getID() == 268435846 && (problematicImport = UnresolvableImportMatcher.getProblematicImport(problem, cu)) != null) {
                    unresolvableImports.add(problematicImport);
                }
                ++n2;
            }
            return unresolvableImports;
        }

        private static ImportDeclaration getProblematicImport(IProblem problem, CompilationUnit cu) {
            ASTNode importNode;
            ASTNode coveringNode = new NodeFinder((ASTNode)cu, problem.getSourceStart(), problem.getSourceEnd() - problem.getSourceStart() + 1).getCoveringNode();
            if (coveringNode != null && (importNode = ASTNodes.getParent(coveringNode, 26)) instanceof ImportDeclaration) {
                return (ImportDeclaration)importNode;
            }
            return null;
        }

        private UnresolvableImportMatcher(Map<String, Set<String>> typeImportsBySimpleName, Map<String, Set<String>> staticImportsBySimpleName) {
            this.fTypeImportsBySimpleName = typeImportsBySimpleName;
            this.fStaticImportsBySimpleName = staticImportsBySimpleName;
        }

        private Set<String> matchImports(boolean isStatic, String simpleName) {
            Map<String, Set<String>> importsBySimpleName = isStatic ? this.fStaticImportsBySimpleName : this.fTypeImportsBySimpleName;
            Set<String> matchingSingleImports = importsBySimpleName.get(simpleName);
            if (matchingSingleImports != null) {
                return Collections.unmodifiableSet(matchingSingleImports);
            }
            Set<String> matchingOnDemandImports = importsBySimpleName.get("*");
            if (matchingOnDemandImports != null) {
                return Collections.unmodifiableSet(matchingOnDemandImports);
            }
            return Collections.emptySet();
        }

        Set<String> matchTypeImports(String simpleName) {
            return this.matchImports(false, simpleName);
        }

        Set<String> matchStaticImports(String simpleName) {
            return this.matchImports(true, simpleName);
        }
    }
}

