/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.ui.internal.dialogfield;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;

class JavaSearchScope
implements IJavaSearchScope {
    private final IProject _project;
    private final String _superType;
    private HashSet _allowedTypeSet;
    private IPath[] _enclosingProjectsAndJars;
    private IProject[] _relativeProjects;

    public JavaSearchScope(IProject project, String superType) {
        this._project = project;
        this._superType = superType;
        this.computeRelativeProjects();
    }

    public IPath[] enclosingProjectsAndJars() {
        if (this._enclosingProjectsAndJars == null) {
            ArrayList<IPath> list = new ArrayList<IPath>();
            int i = 0;
            while (i < this._relativeProjects.length) {
                try {
                    if (this._relativeProjects[i].hasNature("org.eclipse.jdt.core.javanature")) {
                        IJavaProject javaProject = JavaCore.create((IProject)this._relativeProjects[i]);
                        IClasspathEntry[] classpath = javaProject.getResolvedClasspath(true);
                        int j = 0;
                        while (j < classpath.length) {
                            list.add(classpath[j].getPath());
                            ++j;
                        }
                        list.add(javaProject.getPath());
                    }
                }
                catch (CoreException coreException) {}
                ++i;
            }
            this._enclosingProjectsAndJars = list.toArray(new IPath[list.size()]);
        }
        return this._enclosingProjectsAndJars;
    }

    private void computeRelativeProjects() {
        try {
            IProject[] referencedProjects = this._project.getReferencedProjects();
            this._relativeProjects = new IProject[referencedProjects.length + 1];
            System.arraycopy(referencedProjects, 0, this._relativeProjects, 1, referencedProjects.length);
            this._relativeProjects[0] = this._project;
        }
        catch (CoreException coreException) {
            this._relativeProjects = new IProject[]{this._project};
        }
    }

    public boolean encloses(String resourcePath) {
        String className;
        int separatorIndex;
        if (this._allowedTypeSet == null) {
            try {
                this._allowedTypeSet = this.findAllowedTypes(this._superType);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        if (this._allowedTypeSet == null) {
            this._allowedTypeSet = new HashSet();
        }
        return (separatorIndex = resourcePath.indexOf("|")) != -1 ? this._allowedTypeSet.contains(className = resourcePath.substring(separatorIndex + 1, resourcePath.length() - 6).replace('/', '.')) : this._allowedTypeSet.contains(resourcePath);
    }

    public boolean encloses(IJavaElement element) {
        return this.encloses(element.getPath().toString());
    }

    public boolean includesBinaries() {
        return true;
    }

    public boolean includesClasspaths() {
        return true;
    }

    public void setIncludesBinaries(boolean includesBinaries) {
    }

    public void setIncludesClasspaths(boolean includesClasspaths) {
    }

    private HashSet findAllowedTypes(String superType) throws CoreException {
        HashSet<String> set = new HashSet<String>();
        IProject[] projects = this._relativeProjects;
        int i = 0;
        while (i < projects.length) {
            IType type = null;
            if (projects[i].hasNature("org.eclipse.jdt.core.javanature")) {
                IJavaProject javaProject = JavaCore.create((IProject)projects[i]);
                if (superType != null) {
                    try {
                        type = javaProject.findType(superType);
                        if (type != null) {
                            ITypeHierarchy typeHierarchy = type.newTypeHierarchy(javaProject, null);
                            IType[] subtypes = typeHierarchy.getAllSubtypes(type);
                            int j = 0;
                            while (j < subtypes.length) {
                                if (!subtypes[j].isBinary()) {
                                    set.add(subtypes[j].getPath().toString());
                                } else {
                                    String path = subtypes[j].getPath().toString();
                                    if (path != null && path.endsWith(".jar")) {
                                        set.add(subtypes[j].getFullyQualifiedName());
                                    } else {
                                        set.add(path);
                                    }
                                }
                                ++j;
                            }
                        }
                    }
                    catch (JavaModelException e) {
                        e.printStackTrace();
                    }
                }
            }
            ++i;
        }
        return set;
    }

    public String getSuperType() {
        return this._superType;
    }
}

