// =================== DO NOT EDIT THIS FILE ====================
// Generated by Modello 1.8.3,
// any modifications will be overwritten.
// ==============================================================

package org.apache.maven.archetype.catalog;

/**
 * Informations to point to an Archetype referenced in the catalog.
 * 
 * @version $Revision$ $Date$
 */
@SuppressWarnings( "all" )
public class Archetype
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * The groupId of the archetype.
     */
    private String groupId;

    /**
     * The artifactId of the archetype.
     */
    private String artifactId;

    /**
     * The version of the archetype. <code>RELEASE</code> is a
     * valid version.
     */
    private String version;

    /**
     * The repository where to find the archetype.
     *            When omitted, the archetype is searched for in
     * the repository where the catalog comes from.
     */
    private String repository;

    /**
     * The description of the archetype.
     */
    private String description;

    /**
     * Field goals.
     */
    private java.util.List<String> goals;

    /**
     * Field properties.
     */
    private java.util.Properties properties;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addGoal.
     * 
     * @param string
     */
    public void addGoal( String string )
    {
        getGoals().add( string );
    } //-- void addGoal( String )

    /**
     * Method addProperty.
     * 
     * @param key
     * @param value
     */
    public void addProperty( String key, String value )
    {
        getProperties().put( key, value );
    } //-- void addProperty( String, String )

    /**
     * Get the artifactId of the archetype.
     * 
     * @return String
     */
    public String getArtifactId()
    {
        return this.artifactId;
    } //-- String getArtifactId()

    /**
     * Get the description of the archetype.
     * 
     * @return String
     */
    public String getDescription()
    {
        return this.description;
    } //-- String getDescription()

    /**
     * Method getGoals.
     * 
     * @return List
     */
    public java.util.List<String> getGoals()
    {
        if ( this.goals == null )
        {
            this.goals = new java.util.ArrayList<String>();
        }

        return this.goals;
    } //-- java.util.List<String> getGoals()

    /**
     * Get the groupId of the archetype.
     * 
     * @return String
     */
    public String getGroupId()
    {
        return this.groupId;
    } //-- String getGroupId()

    /**
     * Method getProperties.
     * 
     * @return Properties
     */
    public java.util.Properties getProperties()
    {
        if ( this.properties == null )
        {
            this.properties = new java.util.Properties();
        }

        return this.properties;
    } //-- java.util.Properties getProperties()

    /**
     * Get the repository where to find the archetype.
     *            When omitted, the archetype is searched for in
     * the repository where the catalog comes from.
     * 
     * @return String
     */
    public String getRepository()
    {
        return this.repository;
    } //-- String getRepository()

    /**
     * Get the version of the archetype. <code>RELEASE</code> is a
     * valid version.
     * 
     * @return String
     */
    public String getVersion()
    {
        return this.version;
    } //-- String getVersion()

    /**
     * Method removeGoal.
     * 
     * @param string
     */
    public void removeGoal( String string )
    {
        getGoals().remove( string );
    } //-- void removeGoal( String )

    /**
     * Set the artifactId of the archetype.
     * 
     * @param artifactId
     */
    public void setArtifactId( String artifactId )
    {
        this.artifactId = artifactId;
    } //-- void setArtifactId( String )

    /**
     * Set the description of the archetype.
     * 
     * @param description
     */
    public void setDescription( String description )
    {
        this.description = description;
    } //-- void setDescription( String )

    /**
     * Set goals to execute after the creation of the project.
     * 
     * @param goals
     */
    public void setGoals( java.util.List<String> goals )
    {
        this.goals = goals;
    } //-- void setGoals( java.util.List )

    /**
     * Set the groupId of the archetype.
     * 
     * @param groupId
     */
    public void setGroupId( String groupId )
    {
        this.groupId = groupId;
    } //-- void setGroupId( String )

    /**
     * Set properties that will be used during the execution of
     * addition goals after the creation of the project.
     * 
     * @param properties
     */
    public void setProperties( java.util.Properties properties )
    {
        this.properties = properties;
    } //-- void setProperties( java.util.Properties )

    /**
     * Set the repository where to find the archetype.
     *            When omitted, the archetype is searched for in
     * the repository where the catalog comes from.
     * 
     * @param repository
     */
    public void setRepository( String repository )
    {
        this.repository = repository;
    } //-- void setRepository( String )

    /**
     * Set the version of the archetype. <code>RELEASE</code> is a
     * valid version.
     * 
     * @param version
     */
    public void setVersion( String version )
    {
        this.version = version;
    } //-- void setVersion( String )

    
    public String toString()
    {
        return "[" + groupId + ":" + artifactId + ":" + version + ( repository != null ? " -> " + repository : "" ) + "]";
    }
    public int hashCode()
    {
        return groupId.hashCode() + 17 * artifactId.hashCode();
    }
    public boolean equals( Object object )
    {
        if ( object == null || !( object instanceof Archetype ) )
        {
            return false;
        }
        else
        {
            Archetype a = (Archetype) object;
            return org.codehaus.plexus.util.StringUtils.equals( groupId, a.getGroupId() )
                   && org.codehaus.plexus.util.StringUtils.equals( artifactId, a.getArtifactId() );
        }
    }
          
}
