/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.facet.widgets.celleditors.internal.core.composite;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.modisco.facet.widgets.celleditors.internal.core.composite.AbstractIResourceComposite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class CoreIProjectComposite
extends AbstractIResourceComposite<IProject> {
    public CoreIProjectComposite(Composite parent) {
        super(parent);
    }

    public CoreIProjectComposite(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    public IProject getValue() {
        IResource member = ResourcesPlugin.getWorkspace().getRoot().findMember(this.getText().getText());
        if (member instanceof IProject) {
            return (IProject)member;
        }
        return null;
    }

    @Override
    protected final void browseResource() {
        Object[] result;
        WorkbenchContentProvider projectsContentProvider = new WorkbenchContentProvider(){

            public Object[] getChildren(Object element) {
                if (!(element instanceof IWorkspace)) {
                    return new Object[0];
                }
                Object[] projects = ((IWorkspace)element).getRoot().getProjects();
                if (projects == null) {
                    return new Object[0];
                }
                return projects;
            }
        };
        ListDialog dialog = new ListDialog(this.getShell());
        dialog.setContentProvider((IStructuredContentProvider)projectsContentProvider);
        dialog.setLabelProvider((ILabelProvider)new WorkbenchLabelProvider());
        dialog.setInput((Object)ResourcesPlugin.getWorkspace());
        dialog.setMessage("Please select a project");
        dialog.setTitle("Select Project");
        int code = dialog.open();
        if (code == 0 && (result = dialog.getResult()).length == 1) {
            IProject selectedProject = (IProject)result[0];
            this.setValue((IResource)selectedProject);
            this.fireCommit();
        }
    }
}

