/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.builds.internal.core.operations;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.builds.core.IBuildServer;
import org.eclipse.mylyn.builds.core.spi.BuildServerConfiguration;
import org.eclipse.mylyn.builds.internal.core.BuildServer;
import org.eclipse.mylyn.builds.internal.core.operations.BuildJob;
import org.eclipse.mylyn.builds.internal.core.util.BuildRunnableWithResult;
import org.eclipse.mylyn.builds.internal.core.util.BuildRunner;
import org.eclipse.mylyn.commons.core.operations.IOperationMonitor;
import org.eclipse.osgi.util.NLS;

public class RefreshConfigurationOperation
extends BuildJob {
    private final List<IBuildServer> servers;

    public RefreshConfigurationOperation(List<IBuildServer> servers) {
        super("Refresh Configuration");
        Assert.isNotNull(servers);
        this.servers = new ArrayList<IBuildServer>(servers.size());
        for (IBuildServer server : servers) {
            this.servers.add(((BuildServer)server).createWorkingCopy());
        }
    }

    @Override
    protected IStatus doExecute(IOperationMonitor progress) {
        MultiStatus result = new MultiStatus("org.eclipse.mylyn.builds.core", 0, "Refreshing of builds failed", null);
        if (this.servers.size() == 1) {
            progress.beginTask("Refreshing configuration", this.servers.size());
        } else {
            progress.beginTask("Refreshing server configurations", this.servers.size());
        }
        for (IBuildServer server : this.servers) {
            try {
                progress.subTask(NLS.bind((String)"{0}", (Object)server.getLabel()));
                this.doRefresh((BuildServer)server, progress.newChild(1));
            }
            catch (CoreException e) {
                result.add((IStatus)new Status(4, "org.eclipse.mylyn.builds.core", NLS.bind((String)"Refresh of server ''{0}'' failed", (Object)server.getName()), (Throwable)e));
            }
            catch (OperationCanceledException e) {
                return Status.CANCEL_STATUS;
            }
        }
        this.setStatus((IStatus)result);
        return Status.OK_STATUS;
    }

    public void doRefresh(final BuildServer server, final IOperationMonitor monitor) throws CoreException {
        BuildServerConfiguration result = BuildRunner.run(new BuildRunnableWithResult<BuildServerConfiguration>(){

            @Override
            public BuildServerConfiguration run() throws CoreException {
                return server.getBehaviour().refreshConfiguration(monitor);
            }
        });
        if (result == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.builds.core", "Server did not provide a valid configuration."));
        }
    }
}

