/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.ui;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.commons.net.UnsupportedRequestException;
import org.eclipse.mylyn.commons.workbench.WorkbenchUtil;
import org.eclipse.mylyn.commons.workbench.browser.WebBrowserDialog;
import org.eclipse.mylyn.internal.gerrit.core.client.IOpenIdLocation;
import org.eclipse.mylyn.internal.gerrit.core.client.OpenIdAuthenticationRequest;
import org.eclipse.mylyn.internal.gerrit.core.client.OpenIdAuthenticationResponse;
import org.eclipse.mylyn.internal.gerrit.ui.Messages;
import org.eclipse.mylyn.internal.tasks.ui.TaskRepositoryLocationUi;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class GerritRepositoryLocationUi
extends TaskRepositoryLocationUi
implements IOpenIdLocation {
    private static Object lock = new Object();
    private static volatile int version = 1;

    public GerritRepositoryLocationUi(TaskRepository taskRepository) {
        super(taskRepository);
    }

    public String getProviderUrl() {
        if (Boolean.parseBoolean(this.taskRepository.getProperty("org.eclipse.mylyn.gerrit.openId.enabled"))) {
            return this.taskRepository.getProperty("org.eclipse.mylyn.gerrit.openId.provider");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenIdAuthenticationResponse requestAuthentication(OpenIdAuthenticationRequest request, IProgressMonitor monitor) throws UnsupportedRequestException {
        if (Policy.isBackgroundMonitor((IProgressMonitor)monitor)) {
            throw new UnsupportedRequestException();
        }
        String repositoryUrl = this.taskRepository.getUrl();
        int currentVersion = version;
        Object object = lock;
        synchronized (object) {
            block5: {
                if (currentVersion == version) break block5;
                return null;
            }
            return this.showAuthenticationDialog(repositoryUrl, request);
        }
    }

    private OpenIdAuthenticationResponse showAuthenticationDialog(String repositoryUrl, final OpenIdAuthenticationRequest request) {
        final StringBuilder sb = new StringBuilder();
        try {
            for (Map.Entry entry : request.getProviderArgs().entrySet()) {
                if (sb.length() > 0) {
                    sb.append("&");
                }
                sb.append(URLEncoder.encode((String)entry.getKey(), "UTF-8"));
                sb.append("=");
                sb.append(URLEncoder.encode((String)entry.getValue(), "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        final AtomicReference result = new AtomicReference();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                final WebBrowserDialog dialog = new WebBrowserDialog(WorkbenchUtil.getShell(), Messages.GerritRepositoryLocationUi_Login, null, Messages.GerritRepositoryLocationUi_Login_to_OpenID_Provider, 0, new String[]{IDialogConstants.CANCEL_LABEL}, 0){

                    protected Point getInitialSize() {
                        return new Point(780, 580);
                    }
                };
                dialog.create();
                dialog.getBrowser().addLocationListener((LocationListener)new LocationAdapter(){

                    public void changing(LocationEvent event) {
                        String value;
                        if (event.location != null && event.location.startsWith(request.getReturnUrl())) {
                            result.set(new OpenIdAuthenticationResponse(event.location, null));
                        }
                        if ((value = Browser.getCookie((String)request.getCookie(), (String)request.getCookieUrl())) != null) {
                            result.set(new OpenIdAuthenticationResponse(event.location, value));
                        }
                        if (result.get() != null) {
                            event.doit = false;
                            dialog.getBrowser().getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (dialog.getShell() != null && !dialog.getShell().isDisposed()) {
                                        dialog.close();
                                    }
                                }
                            });
                        }
                    }
                });
                dialog.getBrowser().setUrl(String.valueOf(request.getRequestUrl()) + "?" + sb.toString());
                dialog.open();
            }
        });
        return (OpenIdAuthenticationResponse)result.get();
    }
}

