/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.ui.matcher;

import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.ui.matcher.IMouseEventMatcher;
import org.eclipse.swt.events.MouseEvent;

public class DisplayModeMouseEventMatcher
implements IMouseEventMatcher {
    private final String displayMode;
    private final IMouseEventMatcher aggregate;

    public DisplayModeMouseEventMatcher(String displayMode) {
        this(displayMode, null);
    }

    public DisplayModeMouseEventMatcher(String displayMode, IMouseEventMatcher aggregate) {
        if (displayMode == null || displayMode.length() == 0) {
            throw new IllegalArgumentException("displayMode must not be blank.");
        }
        this.displayMode = displayMode;
        this.aggregate = aggregate;
    }

    @Override
    public boolean matches(NatTable natTable, MouseEvent event, LabelStack regionLabels) {
        ILayerCell cell = natTable.getCellByPosition(natTable.getColumnPositionByX(event.x), natTable.getRowPositionByY(event.y));
        if (cell != null) {
            boolean displayModeMatches = this.displayMode.equals(cell.getDisplayMode());
            if (this.aggregate != null) {
                return displayModeMatches && this.aggregate.matches(natTable, event, regionLabels);
            }
            return displayModeMatches;
        }
        return false;
    }

    public static DisplayModeMouseEventMatcher displayMode(String displayMode, IMouseEventMatcher aggregate) {
        return new DisplayModeMouseEventMatcher(displayMode, aggregate);
    }

    public static DisplayModeMouseEventMatcher displayMode(String displayMode) {
        return DisplayModeMouseEventMatcher.displayMode(displayMode, null);
    }
}

