/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.collection;

import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.net4j.util.ObjectUtil;

public class MapEntry<K, V>
implements Map.Entry<K, V> {
    private K key;
    private V value;

    public MapEntry(K key, V value) {
        this.key = key;
        this.value = value;
    }

    public MapEntry(Map.Entry<K, V> entry) {
        this.key = entry.getKey();
        this.value = entry.getValue();
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public V setValue(V value) {
        V oldValue = this.value;
        this.value = value;
        return oldValue;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)obj;
            return ObjectUtil.equals(this.key, entry.getKey()) && ObjectUtil.equals(this.value, entry.getValue());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return ObjectUtil.hashCode(this.key) ^ ObjectUtil.hashCode(this.value);
    }

    public String toString() {
        return MessageFormat.format("{0}={1}", this.key, this.value);
    }
}

