/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal;

import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.OrphanCompletePackage;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.TemplateParameter;
import org.eclipse.ocl.pivot.TemplateSignature;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.internal.CompleteClassImpl;
import org.eclipse.ocl.pivot.internal.CompleteEnvironmentImpl;
import org.eclipse.ocl.pivot.internal.CompletePackageImpl;
import org.eclipse.ocl.pivot.internal.complete.CompleteClassInternal;
import org.eclipse.ocl.pivot.internal.complete.CompleteInheritanceImpl;
import org.eclipse.ocl.pivot.internal.complete.CompletePackageInternal;
import org.eclipse.ocl.pivot.internal.manager.Orphanage;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.TypeUtil;
import org.eclipse.ocl.pivot.values.IntegerValue;
import org.eclipse.ocl.pivot.values.TemplateParameterSubstitutions;
import org.eclipse.ocl.pivot.values.UnlimitedNaturalValue;

public class OrphanCompletePackageImpl
extends CompletePackageImpl
implements OrphanCompletePackage {
    public static final int ORPHAN_COMPLETE_PACKAGE_FEATURE_COUNT = 10;
    public static final int ORPHAN_COMPLETE_PACKAGE_OPERATION_COUNT = 3;
    private @NonNull Map<Class, WeakReference<OrphanCompleteClassImpl>> class2orphanCompleteClass = new WeakHashMap<Class, WeakReference<OrphanCompleteClassImpl>>();

    @Override
    protected EClass eStaticClass() {
        return PivotPackage.Literals.ORPHAN_COMPLETE_PACKAGE;
    }

    protected OrphanCompletePackageImpl() {
        this.init("$orphans$", "orph", "http://www.eclipse.org/ocl/2015/Orphanage");
    }

    @Override
    public <R> R accept(@NonNull Visitor<R> visitor) {
        return visitor.visitOrphanCompletePackage(this);
    }

    @Override
    public void assertSamePackage(@Nullable Package domainPackage) {
        assert (domainPackage != null);
        Package parentPackage = domainPackage.getOwningPackage();
        assert (parentPackage == null);
        assert (Orphanage.isTypeOrphanage(domainPackage));
    }

    public <T extends CollectionType> @NonNull T getCollectionType(@NonNull T containerType, @NonNull Type elementType, boolean isNullFree, @Nullable IntegerValue lower, @Nullable UnlimitedNaturalValue upper) {
        boolean isUnspecialized;
        assert (containerType == PivotUtil.getUnspecializedTemplateableElement(containerType));
        TemplateSignature templateSignature = containerType.getOwnedSignature();
        if (templateSignature == null) {
            throw new IllegalArgumentException("Collection type must have a template signature");
        }
        List<TemplateParameter> templateParameters = templateSignature.getOwnedParameters();
        if (templateParameters.size() != 1) {
            throw new IllegalArgumentException("Collection type must have exactly one template parameter");
        }
        boolean bl = isUnspecialized = elementType == templateParameters.get(0);
        if (isUnspecialized) {
            return containerType;
        }
        CompleteClassInternal completeClass = this.getCompleteModel().getCompleteClass(containerType);
        CollectionType specializedType = this.getCompleteModel().getCollectionType(completeClass, TypeUtil.createCollectionTypeParameters(elementType, isNullFree, lower, upper));
        return (T)specializedType;
    }

    @Override
    public @NonNull CompleteClassInternal getCompleteClass(@NonNull Class type) {
        OrphanCompleteClassImpl orphanCompleteClass;
        WeakReference<OrphanCompleteClassImpl> ref = this.class2orphanCompleteClass.get(type);
        if (ref != null && (orphanCompleteClass = (OrphanCompleteClassImpl)ref.get()) != null) {
            return orphanCompleteClass;
        }
        @NonNull Class orphanClass = type;
        OrphanCompleteClassImpl completeClass = new OrphanCompleteClassImpl();
        completeClass.setName(orphanClass.getName());
        completeClass.getPartialClasses().add(orphanClass);
        this.class2orphanCompleteClass.put(orphanClass, new WeakReference<OrphanCompleteClassImpl>(completeClass));
        return completeClass;
    }

    @Override
    public @NonNull CompleteInheritanceImpl getCompleteInheritance(@NonNull CompleteClassInternal completeClass) {
        return new CompleteInheritanceImpl(completeClass);
    }

    @Override
    public @Nullable CompleteClassInternal getOwnedCompleteClass(String name) {
        return null;
    }

    private class OrphanCompleteClassImpl
    extends CompleteClassImpl {
        private OrphanCompleteClassImpl() {
        }

        @Override
        public boolean conformsTo(final @NonNull CompleteClass thatCompleteClass) {
            final @NonNull Class thisClass = this.getPrimaryClass();
            final @NonNull Class thatClass = thatCompleteClass.getPrimaryClass();
            CompleteEnvironmentImpl completeEnvironmentImpl = new CompleteEnvironmentImpl(){
                {
                    this.ownedCompleteModel = OrphanCompleteClassImpl.this.getCompleteModel();
                }

                @Override
                public @NonNull CompleteClassInternal getCompleteClass(@NonNull Type asType) {
                    if (asType == thisClass) {
                        return OrphanCompleteClassImpl.this;
                    }
                    if (asType == thatClass) {
                        return (CompleteClassInternal)thatCompleteClass;
                    }
                    return super.getCompleteClass(asType);
                }
            };
            return completeEnvironmentImpl.conformsTo(thisClass, TemplateParameterSubstitutions.EMPTY, thatClass, TemplateParameterSubstitutions.EMPTY);
        }

        @Override
        public @NonNull CompletePackageInternal getOwningCompletePackage() {
            return OrphanCompletePackageImpl.this;
        }
    }
}

