/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.decoratormodel.internal.ui.wizards;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.eventbus.EventBus;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.papyrus.uml.decoratormodel.helper.DecoratorModelUtils;
import org.eclipse.papyrus.uml.decoratormodel.internal.ui.messages.Messages;
import org.eclipse.papyrus.uml.decoratormodel.internal.ui.wizards.AbstractManageProfileApplicationsWizard;
import org.eclipse.papyrus.uml.decoratormodel.internal.ui.wizards.ConflictingDecoratorModelsPage;
import org.eclipse.papyrus.uml.decoratormodel.internal.ui.wizards.DecoratorModelSelectionPage;
import org.eclipse.papyrus.uml.decoratormodel.internal.ui.wizards.LoadDecoratorModelsPage;
import org.eclipse.papyrus.uml.decoratormodel.internal.ui.wizards.UnloadProfileApplicationsWizard;
import org.eclipse.uml2.uml.Package;

public class LoadProfileApplicationsWizard
extends AbstractManageProfileApplicationsWizard {
    private static final String SECTION_RESOURCES = "resources";
    private static final String KEY_AUTO_PROMPT_SELECTIONS = "autoPromptSelections";
    private Set<URI> loadedProfileApplicationResources;
    private ConflictingDecoratorModelsPage conflictsPage;
    private final boolean promptingConflicts;

    public LoadProfileApplicationsWizard(boolean autoPrompt) {
        this(autoPrompt, false);
    }

    public LoadProfileApplicationsWizard(boolean autoPrompt, boolean promptingConflicts) {
        super(autoPrompt);
        this.promptingConflicts = promptingConflicts;
        this.setWindowTitle(Messages.LoadProfileApplicationsWizard_0);
    }

    @Override
    protected DecoratorModelSelectionPage createSelectionPage(EventBus bus) {
        return new LoadDecoratorModelsPage(bus);
    }

    @Override
    protected void configureSelectionPage(DecoratorModelSelectionPage page) {
        page.setMessage(Messages.LoadProfileApplicationsWizard_1);
    }

    @Override
    Set<URI> getAvailableProfileApplicationResources(Package package_) {
        HashSet result = Sets.newHashSet();
        result.addAll(DecoratorModelUtils.getUnloadedDecoratorModels((Resource)package_.eResource()));
        if (!this.isAutoPrompt()) {
            for (Package subUnit : DecoratorModelUtils.getLoadedSubUnitPackages((Package)package_)) {
                result.addAll(DecoratorModelUtils.getUnloadedDecoratorModels((Resource)subUnit.eResource()));
            }
        }
        return result;
    }

    @Override
    protected void createPages(Package package_, EventBus bus) {
        super.createPages(package_, bus);
        this.loadedProfileApplicationResources = this.getLoadedProfileApplicationResources(package_);
        if (this.needsUnloadConflictsPage()) {
            this.conflictsPage = new ConflictingDecoratorModelsPage(bus);
            this.conflictsPage.setIsAutomaticPrompt(this.promptingConflicts);
        }
    }

    @Override
    protected void initPages(Package package_, Iterable<URI> initialSelections) {
        if (this.isAutoPrompt() && Iterables.isEmpty(initialSelections)) {
            initialSelections = this.getSavedDecoratorsSelection();
        }
        super.initPages(package_, initialSelections);
        if (this.conflictsPage != null) {
            this.conflictsPage.setInput(package_, this.loadedProfileApplicationResources);
        }
    }

    @Override
    public void addPages() {
        super.addPages();
        if (this.conflictsPage != null) {
            this.addPage((IWizardPage)this.conflictsPage);
        }
    }

    public boolean needsUnloadConflictsPage() {
        return this.loadedProfileApplicationResources != null && !this.loadedProfileApplicationResources.isEmpty();
    }

    protected Set<URI> getLoadedProfileApplicationResources(Package package_) {
        HashSet resources = Sets.newHashSet();
        resources.add(package_.eResource());
        for (Package next : DecoratorModelUtils.getLoadedSubUnitPackages((Package)package_)) {
            resources.add(next.eResource());
        }
        HashSet result = Sets.newHashSet();
        for (Resource next : resources) {
            result.addAll(DecoratorModelUtils.getLoadedDecoratorModels((Resource)next));
        }
        return result;
    }

    @Override
    public boolean isComplete() {
        return super.isComplete() && (this.conflictsPage == null || this.conflictsPage.isPageComplete());
    }

    @Override
    protected boolean performFinish(ResourceSet resourceSet, Set<URI> resourceURIs) {
        Set<URI> unload;
        if (this.conflictsPage != null && !(unload = this.conflictsPage.getResourcesToUnload()).isEmpty() && !UnloadProfileApplicationsWizard.unload(resourceSet, unload)) {
            return false;
        }
        boolean result = DecoratorModelUtils.loadDecoratorModels((ResourceSet)resourceSet, resourceURIs);
        if (this.isAutoPrompt()) {
            this.saveDecoratorsSelection(resourceURIs);
        }
        return result;
    }

    protected void saveDecoratorsSelection(Set<URI> resourceURIs) {
        boolean remove = resourceURIs.isEmpty();
        IDialogSettings resourcesSection = this.getSection(SECTION_RESOURCES, !remove);
        if (resourcesSection != null) {
            this.pruneResourceSections(resourcesSection);
            String resourceURI = this.getPackage().eResource().getURI().toString();
            IDialogSettings resource = this.getSection(resourcesSection, resourceURI, !remove);
            if (resource != null) {
                if (remove) {
                    resource.put(KEY_AUTO_PROMPT_SELECTIONS, null);
                } else {
                    String[] uris = (String[])Iterables.toArray((Iterable)Iterables.transform(resourceURIs, (Function)Functions.toStringFunction()), String.class);
                    resource.put(KEY_AUTO_PROMPT_SELECTIONS, uris);
                }
            }
        }
    }

    private Set<URI> getSavedDecoratorsSelection() {
        String[] uris;
        String resourceURI;
        IDialogSettings resource;
        ImmutableSet.Builder result = ImmutableSet.builder();
        IDialogSettings resourcesSection = this.getSection(SECTION_RESOURCES, false);
        if (resourcesSection != null && (resource = resourcesSection.getSection(resourceURI = this.getPackage().eResource().getURI().toString())) != null && (uris = resource.getArray(KEY_AUTO_PROMPT_SELECTIONS)) != null) {
            String[] stringArray = uris;
            int n = uris.length;
            int n2 = 0;
            while (n2 < n) {
                String next = stringArray[n2];
                result.add((Object)URI.createURI((String)next));
                ++n2;
            }
        }
        return result.build();
    }

    private void pruneResourceSections(IDialogSettings resourcesSection) {
        IDialogSettings[] iDialogSettingsArray = resourcesSection.getSections();
        int n = iDialogSettingsArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDialogSettings next = iDialogSettingsArray[n2];
            URI uri = URI.createURI((String)next.getName());
            boolean exists = false;
            if (uri.isPlatformResource()) {
                Path path = new Path(uri.toPlatformString(true));
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
                boolean bl = exists = file != null && (file.isAccessible() || !file.getProject().isOpen());
            }
            if (!exists) {
                ((DialogSettings)resourcesSection).removeSection(next);
            }
            ++n2;
        }
    }
}

