/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.useractions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.rse.core.model.IPropertySet;
import org.eclipse.rse.core.model.IRSEPersistableContainer;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.model.RSEModelObject;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.internal.useractions.IUserActionContext;
import org.eclipse.rse.internal.useractions.IUserActionModel;

public class UserActionModel
extends RSEModelObject
implements IUserActionModel {
    private ISystemProfile profile;
    private ISubSystemConfiguration subsysConfig;
    private String type;
    private String name;
    private String description;
    private String supplier;
    private String command;
    private List contextList;
    private boolean isModifiable;

    public UserActionModel(ISystemProfile profile, ISubSystemConfiguration subsysConfig, String name) {
        this.profile = profile;
        this.subsysConfig = subsysConfig;
        this.name = name;
        this.isModifiable = true;
    }

    public UserActionModel(ISystemProfile profile, ISubSystemConfiguration subsysConfig, String type, String name, String description, String supplier, String command, IUserActionContext[] contexts, IPropertySet[] sets, boolean isModifiable) {
        this.profile = profile;
        this.subsysConfig = subsysConfig;
        this.type = type;
        this.name = name;
        this.description = description;
        this.supplier = supplier;
        this.command = command;
        this.contextList = new ArrayList();
        int i = 0;
        while (i < contexts.length) {
            this.contextList.add(contexts[i]);
            ++i;
        }
        this.addPropertySets(sets);
        this.isModifiable = isModifiable;
    }

    public ISystemProfile getParentProfile() {
        return this.profile;
    }

    public ISubSystemConfiguration getParentConfiguration() {
        return this.subsysConfig;
    }

    public void setType(String type) {
        if (this.isModifiable()) {
            this.type = type;
        }
    }

    public String getType() {
        return this.type;
    }

    public void setName(String name) {
        if (this.isModifiable()) {
            this.name = name;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String description) {
        if (this.isModifiable()) {
            this.description = description;
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setSupplier(String supplier) {
        if (this.isModifiable()) {
            this.supplier = supplier;
        }
    }

    public String getSupplier() {
        return this.supplier;
    }

    public void setCommand(String command) {
        if (this.isModifiable()) {
            this.command = command;
        }
    }

    public String getCommand() {
        return this.command;
    }

    public IUserActionContext[] getContexts() {
        return (IUserActionContext[])this.contextList.toArray();
    }

    public boolean isModifiable() {
        return this.isModifiable;
    }

    public boolean commit() {
        return false;
    }

    public IRSEPersistableContainer[] getPersistableChildren() {
        return IRSEPersistableContainer.NO_CHILDREN;
    }

    public IRSEPersistableContainer getPersistableParent() {
        return null;
    }
}

