/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.locator.services;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.tcf.core.Command;
import org.eclipse.tcf.core.TransientPeer;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.IService;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.ILocator;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.model.interfaces.IModelNode;
import org.eclipse.tcf.te.runtime.model.interfaces.contexts.IAsyncRefreshableCtx;
import org.eclipse.tcf.te.runtime.persistence.interfaces.IURIPersistenceService;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.tcf.core.Tcf;
import org.eclipse.tcf.te.tcf.core.interfaces.IChannelManager;
import org.eclipse.tcf.te.tcf.core.peers.Peer;
import org.eclipse.tcf.te.tcf.core.util.persistence.PeerDataHelper;
import org.eclipse.tcf.te.tcf.locator.interfaces.ILocatorModelListener;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.ILocatorModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.ILocatorNode;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelLookupService;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelRefreshService;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelUpdateService;
import org.eclipse.tcf.te.tcf.locator.model.ModelLocationUtil;
import org.eclipse.tcf.te.tcf.locator.model.ModelManager;
import org.eclipse.tcf.te.tcf.locator.nodes.LocatorNode;
import org.eclipse.tcf.te.tcf.locator.services.AbstractLocatorModelService;

public class LocatorModelRefreshService
extends AbstractLocatorModelService
implements ILocatorModelRefreshService {
    public LocatorModelRefreshService(ILocatorModel parentModel) {
        super(parentModel);
    }

    protected final void invokeCallback(final ICallback callback) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        if (callback != null) {
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    callback.done((Object)LocatorModelRefreshService.this, Status.OK_STATUS);
                }
            });
        }
    }

    @Override
    public void refresh(ICallback callback) {
        ILocatorModelListener[] listeners;
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        ILocatorModel model = this.getLocatorModel();
        if (model.isDisposed()) {
            this.invokeCallback(callback);
            return;
        }
        if (!Tcf.isRunning()) {
            this.invokeCallback(callback);
            return;
        }
        this.refreshStaticPeers();
        ILocatorNode[] locatorNodes = model.getLocatorNodes();
        ArrayList<IPeer> oldChildren = new ArrayList<IPeer>();
        ILocatorNode[] iLocatorNodeArray = locatorNodes;
        int n = locatorNodes.length;
        int n2 = 0;
        while (n2 < n) {
            ILocatorNode node = iLocatorNodeArray[n2];
            if (!node.isStatic()) {
                oldChildren.add(node.getPeer());
            }
            ++n2;
        }
        this.processPeers(Protocol.getLocator().getPeers(), oldChildren, model);
        for (IPeer oldChild : oldChildren) {
            model.getService(ILocatorModelUpdateService.class).remove(oldChild);
        }
        ILocatorModelListener[] iLocatorModelListenerArray = listeners = model.getListener();
        int n3 = listeners.length;
        n = 0;
        while (n < n3) {
            ILocatorModelListener listener = iLocatorModelListenerArray[n];
            listener.modelChanged(model, null, false);
            ++n;
        }
        this.invokeCallback(callback);
    }

    protected void processPeers(Map<String, IPeer> peers, List<IPeer> oldChildren, ILocatorModel model) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull(peers);
        Assert.isNotNull(oldChildren);
        Assert.isNotNull((Object)model);
        for (Map.Entry<String, IPeer> entry : peers.entrySet()) {
            IPeer peer = entry.getValue();
            if (this.isFiltered(peer)) continue;
            IPeer lkupPeer = model.getService(ILocatorModelLookupService.class).lkupPeerById(entry.getKey());
            if (lkupPeer == null) {
                lkupPeer = model.validatePeer(peer);
                if (lkupPeer == null) continue;
                model.getService(ILocatorModelUpdateService.class).add(lkupPeer);
                continue;
            }
            oldChildren.remove(peer);
        }
    }

    @Override
    public void refresh(final ILocatorNode locatorNode, ICallback callback) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        final ILocatorModel model = this.getLocatorModel();
        if (model.isDisposed()) {
            this.invokeCallback(callback);
            return;
        }
        if (!Tcf.isRunning()) {
            this.invokeCallback(callback);
            return;
        }
        final IAsyncRefreshableCtx refreshCtx = (IAsyncRefreshableCtx)locatorNode.getAdapter(IAsyncRefreshableCtx.class);
        refreshCtx.setQueryState(IAsyncRefreshableCtx.QueryType.CONTEXT, IAsyncRefreshableCtx.QueryState.IN_PROGRESS);
        refreshCtx.setQueryState(IAsyncRefreshableCtx.QueryType.CHILD_LIST, IAsyncRefreshableCtx.QueryState.IN_PROGRESS);
        HashMap<String, Boolean> flags = new HashMap<String, Boolean>();
        flags.put("channel.forceNew", Boolean.TRUE);
        flags.put("channel.noPathMap", Boolean.TRUE);
        flags.put("channel.noValueAdd", Boolean.TRUE);
        Callback finCb = new Callback(callback){

            protected void internalDone(Object caller, IStatus status) {
                refreshCtx.setQueryState(IAsyncRefreshableCtx.QueryType.CONTEXT, IAsyncRefreshableCtx.QueryState.DONE);
                refreshCtx.setQueryState(IAsyncRefreshableCtx.QueryType.CHILD_LIST, IAsyncRefreshableCtx.QueryState.DONE);
                final ILocatorModel model = ModelManager.getLocatorModel();
                final ILocatorModelListener[] listeners = model.getListener();
                if (listeners.length > 0) {
                    Protocol.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ILocatorModelListener[] iLocatorModelListenerArray = listeners;
                            int n = listeners.length;
                            int n2 = 0;
                            while (n2 < n) {
                                ILocatorModelListener listener = iLocatorModelListenerArray[n2];
                                listener.modelChanged(model, locatorNode, false);
                                ++n2;
                            }
                        }
                    });
                }
            }
        };
        Tcf.getChannelManager().openChannel(locatorNode.getPeer(), flags, new IChannelManager.DoneOpenChannel((ICallback)finCb){
            private final /* synthetic */ ICallback val$finCb;
            {
                this.val$finCb = iCallback;
            }

            public void doneOpenChannel(Throwable error, final IChannel channel) {
                if (error != null || channel == null) {
                    locatorNode.removeAll(ILocatorNode.class);
                    refreshCtx.setQueryState(IAsyncRefreshableCtx.QueryType.CONTEXT, IAsyncRefreshableCtx.QueryState.DONE);
                    refreshCtx.setQueryState(IAsyncRefreshableCtx.QueryType.CHILD_LIST, IAsyncRefreshableCtx.QueryState.DONE);
                    if (channel != null) {
                        Tcf.getChannelManager().closeChannel(channel);
                    }
                    if (locatorNode.isStatic()) {
                        locatorNode.setProperty("PeerInstance", locatorNode.getProperty("staticInstance"));
                    } else {
                        ILocatorModelUpdateService update = model.getService(ILocatorModelUpdateService.class);
                        update.remove(locatorNode.getPeer());
                    }
                    LocatorModelRefreshService.this.invokeCallback(this.val$finCb);
                } else {
                    LocatorModelRefreshService.this.onDoneOpenChannelRefreshLocatorNode(channel, locatorNode, (ICallback)new Callback(this.val$finCb){

                        protected void internalDone(Object caller, IStatus status) {
                            Tcf.getChannelManager().closeChannel(channel);
                        }
                    });
                }
            }
        });
    }

    protected void onDoneOpenChannelRefreshLocatorNode(final IChannel channel, final ILocatorNode locatorNode, final ICallback callback) {
        final ILocator locator = (ILocator)channel.getRemoteService(ILocator.class);
        final IAsyncRefreshableCtx refreshCtx = (IAsyncRefreshableCtx)locatorNode.getAdapter(IAsyncRefreshableCtx.class);
        if (locator == null) {
            locatorNode.removeAll(ILocatorNode.class);
            refreshCtx.setQueryState(IAsyncRefreshableCtx.QueryType.CONTEXT, IAsyncRefreshableCtx.QueryState.DONE);
            refreshCtx.setQueryState(IAsyncRefreshableCtx.QueryType.CHILD_LIST, IAsyncRefreshableCtx.QueryState.DONE);
            this.invokeCallback(callback);
        } else {
            locator.getAgentID(new ILocator.DoneGetAgentID(){

                public void doneGetAgentID(IToken token, Exception error, String agentID) {
                    if (error == null) {
                        locatorNode.setProperty("AgentID", agentID);
                    }
                    refreshCtx.setQueryState(IAsyncRefreshableCtx.QueryType.CONTEXT, IAsyncRefreshableCtx.QueryState.DONE);
                    LocatorModelRefreshService.this.getPeers(locator, channel, locatorNode, callback);
                }
            });
        }
    }

    protected void getPeers(ILocator locator, IChannel channel, final ILocatorNode locatorNode, final ICallback callback) {
        Command cmd = new Command(channel, (IService)locator, "getPeers", null){

            public void done(Exception error, Object[] args) {
                if (error == null) {
                    Assert.isTrue((args.length == 2 ? 1 : 0) != 0);
                    error = this.toError(args[0]);
                }
                if (error == null && args[1] != null) {
                    String parentProxies = (String)locatorNode.getPeer().getAttributes().get("Proxies");
                    IPeer[] proxies = PeerDataHelper.decodePeerList((String)parentProxies);
                    ArrayList<IPeer> proxiesList = new ArrayList<IPeer>(Arrays.asList(proxies));
                    proxiesList.add(locatorNode.getPeer());
                    proxies = proxiesList.toArray(new IPeer[proxiesList.size()]);
                    String encProxies = PeerDataHelper.encodePeerList((IPeer[])proxies);
                    List oldChildren = locatorNode.getChildren(ILocatorNode.class);
                    ILocatorModelLookupService lkup = LocatorModelRefreshService.this.getLocatorModel().getService(ILocatorModelLookupService.class);
                    String parentAgentId = locatorNode.getPeer().getAgentID();
                    if (parentAgentId == null) {
                        parentAgentId = locatorNode.getStringProperty("AgentID");
                    }
                    String parentId = LocatorModelRefreshService.this.normalizeId(locatorNode.getPeer().getID());
                    Collection peerAttributesList = (Collection)args[1];
                    for (HashMap<String, String> attributes : peerAttributesList) {
                        ILocatorNode[] lkupNodes;
                        String agentId = (String)attributes.get("AgentID");
                        String id = (String)attributes.get("ID");
                        String normalizedId = LocatorModelRefreshService.this.normalizeId(id);
                        ILocatorNode existing = null;
                        ILocatorNode[] iLocatorNodeArray = lkupNodes = agentId != null ? lkup.lkupLocatorNodeByAgentId(locatorNode, agentId) : new ILocatorNode[]{};
                        if (lkupNodes.length == 0) {
                            lkupNodes = id != null ? lkup.lkupLocatorNodeById(locatorNode, id) : new ILocatorNode[]{};
                        }
                        ILocatorNode[] iLocatorNodeArray2 = lkupNodes;
                        int n = lkupNodes.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ILocatorNode node = iLocatorNodeArray2[n2];
                            if (LocatorModelRefreshService.this.normalizeId(node.getPeer().getID()).equals(normalizedId)) {
                                oldChildren.remove(node);
                                existing = node;
                                break;
                            }
                            ++n2;
                        }
                        if (agentId != null && !agentId.equals(parentAgentId)) {
                            ILocatorNode parent = (ILocatorNode)locatorNode.getParent(ILocatorNode.class);
                            ILocatorNode[] parentNodes = lkup.lkupLocatorNodeByAgentId(parent, agentId);
                            while (parentNodes.length == 0 && parent != null) {
                                parent = (ILocatorNode)parent.getParent(ILocatorNode.class);
                                parentNodes = lkup.lkupLocatorNodeByAgentId(parent, agentId);
                            }
                            attributes = new HashMap(attributes);
                            attributes.put("Proxies", encProxies);
                            TransientPeer peer = new TransientPeer(attributes);
                            if (existing == null) {
                                if (parentNodes.length != 0 || LocatorModelRefreshService.this.isFiltered((IPeer)peer)) continue;
                                locatorNode.add((IModelNode)new LocatorNode((IPeer)peer));
                                continue;
                            }
                            if (parentNodes.length == 0 && !LocatorModelRefreshService.this.isFiltered((IPeer)peer)) {
                                existing.setProperty("PeerInstance", peer);
                                continue;
                            }
                            locatorNode.remove((IModelNode)existing, true);
                            continue;
                        }
                        if (!locatorNode.isStatic()) continue;
                        attributes = new HashMap<String, String>(attributes);
                        attributes.put("Proxies", parentProxies);
                        attributes.putAll(((IPeer)locatorNode.getProperty("staticInstance")).getAttributes());
                        TransientPeer peer = new TransientPeer(attributes);
                        locatorNode.setProperty("PeerInstance", peer);
                    }
                    for (ILocatorNode old : oldChildren) {
                        if (old.isStatic()) continue;
                        locatorNode.remove((IModelNode)old, true);
                    }
                    for (ILocatorNode child : locatorNode.getChildren(ILocatorNode.class)) {
                        String childAgentId = child.getPeer().getAgentID();
                        String childId = child.getPeer().getID();
                        if (parentAgentId.equals(childAgentId)) {
                            locatorNode.remove((IModelNode)child, true);
                            continue;
                        }
                        if (parentId == null || !parentId.equals(LocatorModelRefreshService.this.normalizeId(childId))) continue;
                        locatorNode.remove((IModelNode)child, true);
                    }
                } else {
                    List oldChildren = locatorNode.getChildren(ILocatorNode.class);
                    for (ILocatorNode old : oldChildren) {
                        if (old.isStatic()) {
                            old.setProperty("PeerInstance", locatorNode.getProperty("staticInstance"));
                            continue;
                        }
                        locatorNode.remove((IModelNode)old, true);
                    }
                }
                IAsyncRefreshableCtx refreshCtx = (IAsyncRefreshableCtx)locatorNode.getAdapter(IAsyncRefreshableCtx.class);
                refreshCtx.setQueryState(IAsyncRefreshableCtx.QueryType.CHILD_LIST, IAsyncRefreshableCtx.QueryState.DONE);
                LocatorModelRefreshService.this.invokeCallback(callback);
            }
        };
    }

    protected String normalizeId(String id) {
        if (id != null) {
            id = id.toLowerCase().replaceAll(":localhost:", "::");
            id = id.replaceAll(":127\\.0+\\.0+\\.0*1:", "::");
        }
        return id;
    }

    protected boolean isFiltered(IPeer peer) {
        boolean filtered;
        boolean bl = filtered = peer == null;
        if (!filtered) {
            String value = (String)peer.getAttributes().get("ValueAdd");
            boolean isValueAdd = value != null && ("1".equals(value.trim()) || Boolean.parseBoolean(value.trim()));
            boolean isCli = peer.getName() != null && (peer.getName().endsWith("Command Server") || peer.getName().endsWith("CLI Server"));
            filtered = isValueAdd || isCli;
        }
        return filtered;
    }

    protected File[] getStaticLocatorsLookupDirectories() {
        File file;
        ArrayList<File> rootLocations = new ArrayList<File>();
        IPath defaultPath = ModelLocationUtil.getStaticLocatorsRootLocation();
        if (defaultPath != null && (file = defaultPath.toFile()).canRead() && file.isDirectory() && !rootLocations.contains(file)) {
            rootLocations.add(file);
        }
        return rootLocations.toArray(new File[rootLocations.size()]);
    }

    protected void refreshStaticPeers() {
        File[] roots = this.getStaticLocatorsLookupDirectories();
        if (roots.length > 0) {
            ArrayList<Peer> peers = new ArrayList<Peer>();
            File[] fileArray = roots;
            int n = roots.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                File[] candidates = file.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        Path path = new Path(pathname.getAbsolutePath());
                        return path.getFileExtension() != null && path.getFileExtension().toLowerCase().equals("locator");
                    }
                });
                if (candidates != null && candidates.length > 0) {
                    File[] fileArray2 = candidates;
                    int n3 = candidates.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        File candidate = fileArray2[n4];
                        try {
                            IURIPersistenceService service = (IURIPersistenceService)ServiceManager.getInstance().getService(IURIPersistenceService.class);
                            IPeer tempPeer = (IPeer)service.read(IPeer.class, candidate.getAbsoluteFile().toURI());
                            HashMap<String, String> attrs = new HashMap<String, String>(tempPeer.getAttributes());
                            attrs.put("URI.transient", candidate.getAbsoluteFile().toURI().toString());
                            Peer peer = new Peer(attrs);
                            peers.add(peer);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            for (IPeer iPeer : peers) {
                ILocatorModelUpdateService update = this.getLocatorModel().getService(ILocatorModelUpdateService.class);
                update.add(iPeer, true);
            }
        }
    }
}

