/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.unittest.internal.model;

import org.eclipse.core.runtime.Assert;
import org.eclipse.unittest.internal.model.ProgressState;
import org.eclipse.unittest.internal.model.Status;
import org.eclipse.unittest.internal.model.TestElement;
import org.eclipse.unittest.internal.model.TestSuiteElement;
import org.eclipse.unittest.model.ITestCaseElement;
import org.eclipse.unittest.model.ITestElement;

public class TestCaseElement
extends TestElement
implements ITestCaseElement {
    private boolean fIgnored;
    private boolean fIsDynamicTest;

    public TestCaseElement(TestSuiteElement parent, String id, String testName, String displayName, boolean isDynamicTest, String uniqueId) {
        super(parent, id, testName, displayName, uniqueId);
        Assert.isNotNull((Object)parent);
        this.fIsDynamicTest = isDynamicTest;
    }

    @Override
    public ITestElement.Result getTestResult(boolean includeChildren) {
        return this.isIgnored() ? ITestElement.Result.IGNORED : super.getTestResult(includeChildren);
    }

    public void setIgnored(boolean ignored) {
        this.fIgnored = ignored;
    }

    @Override
    public boolean isIgnored() {
        return this.fIgnored;
    }

    @Override
    public String toString() {
        return "TestCase: " + super.toString();
    }

    @Override
    public boolean isDynamicTest() {
        return this.fIsDynamicTest;
    }

    @Override
    Integer getFinalTestCaseCount() {
        return 1;
    }

    @Override
    int countStartedTestCases() {
        return this.getProgressState() != ProgressState.NOT_STARTED || this.testStartedInstant != null ? 1 : 0;
    }

    @Override
    int getCurrentFailureCount() {
        return this.getStatus() == Status.FAILURE ? 1 : 0;
    }

    @Override
    int getCurrentAssumptionFailureCount() {
        return this.isAssumptionFailure() ? 1 : 0;
    }

    @Override
    int getCurrentIgnoredCount() {
        return this.isIgnored() ? 1 : 0;
    }

    @Override
    int getCurrentErrorCount() {
        return this.getStatus() == Status.ERROR ? 1 : 0;
    }
}

