/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.unittest.internal.model;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.unittest.internal.model.ProgressState;
import org.eclipse.unittest.internal.model.Status;
import org.eclipse.unittest.internal.model.TestElement;
import org.eclipse.unittest.model.ITestElement;
import org.eclipse.unittest.model.ITestSuiteElement;

public class TestSuiteElement
extends TestElement
implements ITestSuiteElement {
    private final List<TestElement> fChildren;
    private Status fChildrenStatus;
    private Integer expectedTestCount;

    public TestSuiteElement(TestSuiteElement parent, String id, String testName, Integer expectedChildrenCount, String displayName, String data) {
        super(parent, id, testName, displayName, data);
        this.expectedTestCount = expectedChildrenCount;
        this.fChildren = new ArrayList<TestElement>(expectedChildrenCount == null ? 0 : expectedChildrenCount);
    }

    @Override
    public ITestElement.Result getTestResult(boolean includeChildren) {
        if (includeChildren) {
            return this.getStatus().convertToResult();
        }
        return super.getStatus().convertToResult();
    }

    public List<TestElement> getChildren() {
        return Collections.unmodifiableList(this.fChildren);
    }

    public void addChild(TestElement child) {
        this.fChildren.add(child);
    }

    public void removeChild(TestElement child) {
        this.fChildren.remove(child);
    }

    @Override
    public Status getStatus() {
        Status suiteStatus = this.getSuiteStatus();
        if (this.fChildrenStatus != null) {
            return TestSuiteElement.combineStatus(this.fChildrenStatus, suiteStatus);
        }
        return suiteStatus;
    }

    private Status getCumulatedStatus() {
        TestElement[] children = this.fChildren.toArray(new TestElement[this.fChildren.size()]);
        if (children.length == 0) {
            return this.getSuiteStatus();
        }
        Status cumulated = children[0].getStatus();
        int i = 1;
        while (i < children.length) {
            Status childStatus = children[i].getStatus();
            cumulated = TestSuiteElement.combineStatus(cumulated, childStatus);
            ++i;
        }
        return cumulated;
    }

    public Status getSuiteStatus() {
        return super.getStatus();
    }

    public void childChangedStatus(ITestElement child, Status childStatus) {
        int childCount = this.fChildren.size();
        if (child == this.fChildren.get(0) && childStatus.isRunning()) {
            this.internalSetChildrenStatus(childStatus);
            return;
        }
        TestElement lastChild = this.fChildren.get(childCount - 1);
        if (child == lastChild) {
            if (childStatus.isDone()) {
                this.internalSetChildrenStatus(this.getCumulatedStatus());
                return;
            }
        } else if (!lastChild.getStatus().isNotRun()) {
            this.internalSetChildrenStatus(this.getCumulatedStatus());
            return;
        }
        if (childStatus.isFailure()) {
            if (this.fChildrenStatus == null || !this.fChildrenStatus.isErrorOrFailure()) {
                this.internalSetChildrenStatus(Status.RUNNING_FAILURE);
                return;
            }
        } else if (childStatus.isError() && (this.fChildrenStatus == null || !this.fChildrenStatus.isError())) {
            this.internalSetChildrenStatus(Status.RUNNING_ERROR);
            return;
        }
    }

    private void internalSetChildrenStatus(Status status) {
        if (this.fChildrenStatus == status) {
            return;
        }
        if (status == Status.RUNNING) {
            if (this.fDuration == null) {
                this.testStartedInstant = Instant.now();
            }
        } else if (status.convertToProgressState() == ProgressState.COMPLETED && this.fDuration == null && this.testStartedInstant != null) {
            this.fDuration = Duration.between(this.testStartedInstant, Instant.now());
        }
        this.fChildrenStatus = status;
        TestSuiteElement parent = this.getParent();
        if (parent != null) {
            parent.childChangedStatus(this, this.getStatus());
        }
    }

    @Override
    public String toString() {
        return "TestSuite: " + this.getTestName() + " : " + super.toString() + " (" + this.fChildren.size() + ")";
    }

    private static Status combineStatus(Status one, Status two) {
        Status progress = TestSuiteElement.combineProgress(one, two);
        Status error = TestSuiteElement.combineError(one, two);
        return TestSuiteElement.combineProgressAndErrorStatus(progress, error);
    }

    private static Status combineProgress(Status one, Status two) {
        if (one.isNotRun() && two.isNotRun()) {
            return Status.NOT_RUN;
        }
        if (one.isDone() && two.isDone()) {
            return Status.OK;
        }
        if (!one.isRunning() && !two.isRunning()) {
            return Status.OK;
        }
        return Status.RUNNING;
    }

    private static Status combineError(Status one, Status two) {
        if (one.isError() || two.isError()) {
            return Status.ERROR;
        }
        if (one.isFailure() || two.isFailure()) {
            return Status.FAILURE;
        }
        return Status.OK;
    }

    private static Status combineProgressAndErrorStatus(Status progress, Status error) {
        if (progress.isDone()) {
            if (error.isError()) {
                return Status.ERROR;
            }
            if (error.isFailure()) {
                return Status.FAILURE;
            }
            return Status.OK;
        }
        if (progress.isNotRun()) {
            return Status.NOT_RUN;
        }
        if (error.isError()) {
            return Status.RUNNING_ERROR;
        }
        if (error.isFailure()) {
            return Status.RUNNING_FAILURE;
        }
        return Status.RUNNING;
    }

    @Override
    Integer getFinalTestCaseCount() {
        if (this.expectedTestCount != null) {
            return this.expectedTestCount;
        }
        if (this.getStatus().isDone()) {
            return this.getChildren().stream().map(TestElement::getFinalTestCaseCount).filter(Objects::nonNull).mapToInt(Integer::intValue).sum();
        }
        return null;
    }

    @Override
    public int countStartedTestCases() {
        return this.getChildren().stream().mapToInt(TestElement::countStartedTestCases).sum();
    }

    @Override
    int getCurrentFailureCount() {
        return this.getChildren().stream().mapToInt(TestElement::getCurrentFailureCount).sum();
    }

    @Override
    int getCurrentAssumptionFailureCount() {
        return this.getChildren().stream().mapToInt(TestElement::getCurrentAssumptionFailureCount).sum();
    }

    @Override
    int getCurrentIgnoredCount() {
        return this.getChildren().stream().mapToInt(TestElement::getCurrentIgnoredCount).sum();
    }

    @Override
    int getCurrentErrorCount() {
        return this.getChildren().stream().mapToInt(TestElement::getCurrentErrorCount).sum();
    }
}

