/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.evm.update;

import org.eclipse.viatra.query.runtime.api.AdvancedViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.ViatraQueryModelUpdateListener;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;
import org.eclipse.viatra.transformation.evm.update.UpdateCompleteProvider;

public class QueryEngineUpdateCompleteProvider
extends UpdateCompleteProvider {
    private final ViatraQueryModelUpdateListener modelUpdateListener;
    private final AdvancedViatraQueryEngine engine;

    public QueryEngineUpdateCompleteProvider(ViatraQueryEngine engine) {
        Preconditions.checkArgument((engine != null ? 1 : 0) != 0, (String)"Cannot create provider with null engine!");
        this.engine = AdvancedViatraQueryEngine.from((ViatraQueryEngine)engine);
        this.modelUpdateListener = new ModelUpdateListener();
    }

    @Override
    protected void firstListenerAdded() {
        super.firstListenerAdded();
        this.engine.addModelUpdateListener(this.modelUpdateListener);
    }

    @Override
    protected void lastListenerRemoved() {
        super.lastListenerRemoved();
        if (!this.engine.isDisposed()) {
            this.engine.removeModelUpdateListener(this.modelUpdateListener);
        }
    }

    private final class ModelUpdateListener
    implements ViatraQueryModelUpdateListener {
        private ModelUpdateListener() {
        }

        public void notifyChanged(ViatraQueryModelUpdateListener.ChangeLevel changeLevel) {
            QueryEngineUpdateCompleteProvider.this.updateCompleted();
        }

        public ViatraQueryModelUpdateListener.ChangeLevel getLevel() {
            return ViatraQueryModelUpdateListener.ChangeLevel.MODEL;
        }
    }
}

