/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.core.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.wst.jsdt.debug.core.jsdi.Property;
import org.eclipse.wst.jsdt.debug.core.model.IJavaScriptValue;
import org.eclipse.wst.jsdt.debug.internal.core.model.JavaScriptDebugElement;
import org.eclipse.wst.jsdt.debug.internal.core.model.JavaScriptValue;

public class JavaScriptProperty
extends JavaScriptDebugElement
implements IVariable {
    private Property property;
    private IJavaScriptValue value = null;

    public JavaScriptProperty(JavaScriptValue jsdiValue, Property property) {
        super(jsdiValue.getJavaScriptDebugTarget());
        this.property = property;
    }

    public String getName() {
        return this.property.name();
    }

    public String getReferenceTypeName() throws DebugException {
        return this.getValue().getReferenceTypeName();
    }

    public IValue getValue() throws DebugException {
        if (this.value == null) {
            this.value = JavaScriptValue.createValue(this.getJavaScriptDebugTarget(), this.property.value());
        }
        return this.value;
    }

    public boolean hasValueChanged() throws DebugException {
        return false;
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == JavaScriptProperty.class) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    public void setValue(String expression) throws DebugException {
        this.notSupported("Javascript variables do not support being edited", null);
    }

    public void setValue(IValue value) throws DebugException {
        this.notSupported("Javascript variables do not support being edited", null);
    }

    public boolean supportsValueModification() {
        return false;
    }

    public boolean verifyValue(String expression) throws DebugException {
        return false;
    }

    public boolean verifyValue(IValue value) throws DebugException {
        return false;
    }
}

