/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.Ipam;
import org.mandas.docker.client.messages.IpamConfig;

final class ImmutableIpam
implements Ipam {
    private final String driver;
    @Nullable
    private final List<IpamConfig> config;
    @Nullable
    private final Map<String, String> options;

    private ImmutableIpam(String driver, @Nullable List<IpamConfig> config, @Nullable Map<String, String> options) {
        this.driver = driver;
        this.config = config;
        this.options = options;
    }

    @Override
    @JsonProperty(value="Driver")
    public String driver() {
        return this.driver;
    }

    @Override
    @JsonProperty(value="Config")
    @Nullable
    public List<IpamConfig> config() {
        return this.config;
    }

    @Override
    @JsonProperty(value="Options")
    @Nullable
    public Map<String, String> options() {
        return this.options;
    }

    public final ImmutableIpam withDriver(String value) {
        String newValue = Objects.requireNonNull(value, "driver");
        if (this.driver.equals(newValue)) {
            return this;
        }
        return new ImmutableIpam(newValue, this.config, this.options);
    }

    public final ImmutableIpam withConfig(IpamConfig ... elements) {
        if (elements == null) {
            return new ImmutableIpam(this.driver, null, this.options);
        }
        List<IpamConfig> newValue = Arrays.asList(elements) == null ? null : ImmutableIpam.createUnmodifiableList(false, ImmutableIpam.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableIpam(this.driver, newValue, this.options);
    }

    public final ImmutableIpam withConfig(@Nullable Iterable<? extends IpamConfig> elements) {
        if (this.config == elements) {
            return this;
        }
        List<IpamConfig> newValue = elements == null ? null : ImmutableIpam.createUnmodifiableList(false, ImmutableIpam.createSafeList(elements, true, false));
        return new ImmutableIpam(this.driver, newValue, this.options);
    }

    public final ImmutableIpam withOptions(@Nullable Map<String, ? extends String> entries) {
        if (this.options == entries) {
            return this;
        }
        Map<String, String> newValue = entries == null ? null : ImmutableIpam.createUnmodifiableMap(true, false, entries);
        return new ImmutableIpam(this.driver, this.config, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableIpam && this.equalTo((ImmutableIpam)another);
    }

    private boolean equalTo(ImmutableIpam another) {
        return this.driver.equals(another.driver) && Objects.equals(this.config, another.config) && Objects.equals(this.options, another.options);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.driver.hashCode();
        h += (h << 5) + Objects.hashCode(this.config);
        h += (h << 5) + Objects.hashCode(this.options);
        return h;
    }

    public String toString() {
        return "Ipam{driver=" + this.driver + ", config=" + this.config + ", options=" + this.options + "}";
    }

    public static ImmutableIpam copyOf(Ipam instance) {
        if (instance instanceof ImmutableIpam) {
            return (ImmutableIpam)instance;
        }
        return ImmutableIpam.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    static final class Builder
    implements Ipam.Builder {
        private static final long INIT_BIT_DRIVER = 1L;
        private long initBits = 1L;
        private String driver;
        private List<IpamConfig> config = null;
        private Map<String, String> options = null;

        private Builder() {
        }

        public final Builder from(Ipam instance) {
            Map<String, String> optionsValue;
            Objects.requireNonNull(instance, "instance");
            this.driver(instance.driver());
            List<IpamConfig> configValue = instance.config();
            if (configValue != null) {
                this.addAllConfig(configValue);
            }
            if ((optionsValue = instance.options()) != null) {
                this.putAllOptions(optionsValue);
            }
            return this;
        }

        @Override
        @JsonProperty(value="Driver")
        public final Builder driver(String driver) {
            this.driver = Objects.requireNonNull(driver, "driver");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder config(IpamConfig element) {
            if (this.config == null) {
                this.config = new ArrayList<IpamConfig>();
            }
            this.config.add(Objects.requireNonNull(element, "config element"));
            return this;
        }

        public final Builder config(IpamConfig ... elements) {
            if (this.config == null) {
                this.config = new ArrayList<IpamConfig>();
            }
            for (IpamConfig element : elements) {
                this.config.add(Objects.requireNonNull(element, "config element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="Config")
        public final Builder config(@Nullable Iterable<? extends IpamConfig> elements) {
            if (elements == null) {
                this.config = null;
                return this;
            }
            this.config = new ArrayList<IpamConfig>();
            return this.addAllConfig(elements);
        }

        public final Builder addAllConfig(Iterable<? extends IpamConfig> elements) {
            Objects.requireNonNull(elements, "config element");
            if (this.config == null) {
                this.config = new ArrayList<IpamConfig>();
            }
            for (IpamConfig ipamConfig : elements) {
                this.config.add(Objects.requireNonNull(ipamConfig, "config element"));
            }
            return this;
        }

        public final Builder addOption(String key, String value) {
            if (this.options == null) {
                this.options = new LinkedHashMap<String, String>();
            }
            this.options.put(Objects.requireNonNull(key, "options key"), Objects.requireNonNull(value, "options value"));
            return this;
        }

        public final Builder addOption(Map.Entry<String, ? extends String> entry) {
            if (this.options == null) {
                this.options = new LinkedHashMap<String, String>();
            }
            String k = entry.getKey();
            String v = entry.getValue();
            this.options.put(Objects.requireNonNull(k, "options key"), Objects.requireNonNull(v, "options value"));
            return this;
        }

        @Override
        @JsonProperty(value="Options")
        public final Builder options(@Nullable Map<String, ? extends String> entries) {
            if (entries == null) {
                this.options = null;
                return this;
            }
            this.options = new LinkedHashMap<String, String>();
            return this.putAllOptions(entries);
        }

        public final Builder putAllOptions(Map<String, ? extends String> entries) {
            if (this.options == null) {
                this.options = new LinkedHashMap<String, String>();
            }
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String k = e.getKey();
                String v = e.getValue();
                this.options.put(Objects.requireNonNull(k, "options key"), Objects.requireNonNull(v, "options value"));
            }
            return this;
        }

        @Override
        public ImmutableIpam build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableIpam(this.driver, this.config == null ? null : ImmutableIpam.createUnmodifiableList(true, this.config), this.options == null ? null : ImmutableIpam.createUnmodifiableMap(false, false, this.options));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("driver");
            }
            return "Cannot build Ipam, some of required attributes are not set " + attributes;
        }
    }
}

