/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.eclipse.bpmn2.modeler.core.features.RoutingLane;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.graphiti.datatypes.IDimension;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddConnectionContext;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.impl.AddConnectionContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.features.context.impl.DeleteContext;
import org.eclipse.graphiti.features.impl.AbstractAddShapeFeature;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polygon;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.algorithms.RoundedRectangle;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.FixPointAnchor;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeService;
import org.eclipse.graphiti.ui.features.DefaultDeleteFeature;
import org.eclipse.graphiti.util.ColorConstant;
import org.eclipse.graphiti.util.IColorConstant;

public class RoutingNet
extends ArrayList<RoutingLane> {
    private static final long serialVersionUID = -3041403111796385182L;
    protected static final IGaService gaService = Graphiti.getGaService();
    protected static final IPeService peService = Graphiti.getPeService();
    public static final String CONNECTION = "ROUTING_NET_CONNECTION";
    public static final String LANE = "ROUTING_NET_LANE";
    boolean isRotated = false;
    Shape source;
    Shape target;
    List<RoutingLane> sourceAdjacentLanes = new ArrayList<RoutingLane>();
    List<RoutingLane> targetAdjacentLanes = new ArrayList<RoutingLane>();
    Stack<RoutingLane> solutionStack;
    List<List<RoutingLane>> allSolutions;
    int minDist = Integer.MAX_VALUE;
    IFeatureProvider fp;

    public RoutingNet(IFeatureProvider fp) {
        this.fp = fp;
    }

    @Override
    public boolean add(RoutingLane a) {
        if (!this.contains(a) && a.getWidth() > 0 && a.getHeight() > 0) {
            return super.add(a);
        }
        return false;
    }

    public boolean add(int x, int y, int width, int height) {
        RoutingLane a = new RoutingLane(x, y, width, height);
        return this.add(a);
    }

    public void setFeatureProvider(IFeatureProvider fp) {
        this.fp = fp;
    }

    public void link() {
        for (RoutingLane a1 : this) {
            for (RoutingLane a2 : this) {
                if (a1 == a2) continue;
                switch (a1.adjacent(a2)) {
                    case LEFT: 
                    case TOP: {
                        a1.addLeft(a2);
                        break;
                    }
                    case BOTTOM: 
                    case RIGHT: {
                        a1.addRight(a2);
                        break;
                    }
                }
            }
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.sourceAdjacentLanes.clear();
        this.targetAdjacentLanes.clear();
        if (this.solutionStack != null) {
            this.solutionStack.clear();
        }
        if (this.allSolutions != null) {
            this.allSolutions.clear();
        }
    }

    public List<List<RoutingLane>> findSolutions(Shape source2, Shape target2) {
        this.allSolutions = new ArrayList<List<RoutingLane>>();
        this.source = source2;
        this.target = target2;
        if (source2 == null || target2 == null) {
            return this.allSolutions;
        }
        org.eclipse.draw2d.geometry.Rectangle sourceBounds = RoutingNet.getBounds(false, source2);
        org.eclipse.draw2d.geometry.Rectangle targetBounds = RoutingNet.getBounds(false, target2);
        this.sourceAdjacentLanes.clear();
        this.targetAdjacentLanes.clear();
        for (RoutingLane a1 : this) {
            if (a1.adjacent(sourceBounds) != RoutingLane.Adjacence.NONE) {
                this.sourceAdjacentLanes.add(a1);
            }
            if (a1.adjacent(targetBounds) == RoutingLane.Adjacence.NONE) continue;
            this.targetAdjacentLanes.add(a1);
        }
        this.solutionStack = new Stack();
        this.minDist = Integer.MAX_VALUE;
        for (RoutingLane sa : this.sourceAdjacentLanes) {
            for (RoutingLane ta : this.targetAdjacentLanes) {
                sa.navigateTo(ta, this);
            }
        }
        Collections.sort(this.allSolutions, new Comparator<List<RoutingLane>>(){

            @Override
            public int compare(List<RoutingLane> arg0, List<RoutingLane> arg1) {
                double m1;
                double m0 = RoutingNet.this.merit(arg0);
                int i = m0 < (m1 = RoutingNet.this.merit(arg1)) ? 1 : (m0 > m1 ? -1 : 0);
                return i;
            }
        });
        return this.allSolutions;
    }

    public double merit(List<RoutingLane> list) {
        ILocation sourceLoc = Graphiti.getPeService().getLocationRelativeToDiagram(this.source);
        IDimension sourceSize = GraphicsUtil.calculateSize((PictogramElement)this.source);
        ILocation targetLoc = Graphiti.getPeService().getLocationRelativeToDiagram(this.target);
        IDimension targetSize = GraphicsUtil.calculateSize((PictogramElement)this.target);
        Point p1 = GraphicsUtil.getShapeCenter((AnchorContainer)this.source);
        Point p2 = GraphicsUtil.getShapeCenter((AnchorContainer)this.target);
        if (this.isRotated) {
            if (sourceLoc.getY() + sourceSize.getHeight() < targetLoc.getY()) {
                p1.setY(sourceLoc.getY() + sourceSize.getHeight());
                p2.setY(targetLoc.getY());
            } else if (targetLoc.getY() + targetSize.getHeight() < sourceLoc.getY()) {
                p1.setY(sourceLoc.getY());
                p2.setY(targetLoc.getY() + targetSize.getHeight());
            }
        } else if (sourceLoc.getX() + sourceSize.getWidth() < targetLoc.getX()) {
            p1.setX(sourceLoc.getX() + sourceSize.getWidth());
            p2.setX(targetLoc.getX());
        } else if (targetLoc.getX() + targetSize.getWidth() < sourceLoc.getX()) {
            p1.setX(sourceLoc.getX());
            p2.setX(targetLoc.getX() + targetSize.getWidth());
        }
        int i = 0;
        double length = GraphicsUtil.getLength(p1, p2);
        for (RoutingLane rl : list) {
            if (GraphicsUtil.RectangleIntersectsLine.intersectsLine(p1.getX(), p1.getY(), p2.getX(), p2.getY(), rl.rect.x, rl.rect.y, rl.rect.width, rl.rect.height)) {
                i = (int)((double)i + length);
                continue;
            }
            Point c = GraphicsUtil.createPoint(rl.rect.getCenter().x, rl.rect.getCenter().y);
            double d = this.pointToLineDistance(p1, p2, c);
            i = (int)((double)i + length / d);
        }
        return (double)i / (length * (double)list.size());
    }

    public double pointToLineDistance(Point p1, Point p2, Point p) {
        double normalLength = Math.sqrt((p2.getX() - p1.getX()) * (p2.getX() - p1.getX()) + (p2.getY() - p1.getY()) * (p2.getY() - p1.getY()));
        return (double)Math.abs((p.getX() - p1.getX()) * (p2.getY() - p1.getY()) - (p.getY() - p1.getY()) * (p2.getX() - p1.getX())) / normalLength;
    }

    public void pop() {
        this.solutionStack.pop();
    }

    public boolean visited(RoutingLane lane) {
        return this.solutionStack.contains(lane);
    }

    public void push(RoutingLane lane) {
        this.solutionStack.push(lane);
    }

    public int getManhattanDistance(List<RoutingLane> lanes) {
        int dist = 0;
        org.eclipse.draw2d.geometry.Rectangle r0 = RoutingNet.getBounds(false, this.source);
        int x0 = r0.x + r0.width / 2;
        int y0 = r0.y + r0.height / 2;
        org.eclipse.draw2d.geometry.Rectangle r1 = RoutingNet.getBounds(false, this.target);
        int x1 = r1.x + r1.width / 2;
        int y1 = r1.y + r1.height / 2;
        int dx = Math.abs(x0 - x1);
        int dy = Math.abs(y0 - y1);
        RoutingLane a0 = lanes.get(0);
        RoutingLane a2 = null;
        if (this.isRotated) {
            if (dy > a0.getHeight()) {
                dist += a0.getHeight();
            }
            dist += dx;
            int i = 1;
            while (i < lanes.size()) {
                RoutingLane a1 = lanes.get(i);
                int d = 0;
                d = dy > a1.getHeight() ? a1.getHeight() : dy;
                if (i + 1 < lanes.size()) {
                    a2 = lanes.get(i + 1);
                    if (a0.getRight().contains(a1) && a1.getRight().contains(a2) || a0.getLeft().contains(a1) && a1.getLeft().contains(a2)) {
                        dist += d;
                    }
                } else {
                    dist += d;
                }
                d = 0;
                int right = a1.getX() + a1.getWidth();
                int left = a1.getX();
                if (right < x0) {
                    d = x0 - right;
                    x0 = right;
                } else if (left > x0) {
                    d = left - x0;
                    x0 = left;
                }
                dist += d;
                a0 = a1;
                ++i;
            }
        } else {
            if (dx > a0.getWidth()) {
                dist += a0.getWidth();
            }
            a0.getWidth();
            a0.getHeight();
            dist += dy;
            int i = 1;
            while (i < lanes.size()) {
                RoutingLane a1 = lanes.get(i);
                int d = 0;
                d = dx > a1.getWidth() ? a1.getWidth() : dx;
                if (i + 1 < lanes.size()) {
                    a2 = lanes.get(i + 1);
                    if (a0.getRight().contains(a1) && a1.getRight().contains(a2) || a0.getLeft().contains(a1) && a1.getLeft().contains(a2)) {
                        dist += d;
                    }
                } else {
                    dist += d;
                }
                d = 0;
                int bottom = a1.getY() + a1.getHeight();
                int top = a1.getY();
                if (bottom < y0) {
                    d = y0 - bottom;
                    y0 = bottom;
                } else if (top > y0) {
                    d = top - y0;
                    y0 = top;
                }
                dist += d;
                a0 = a1;
                ++i;
            }
        }
        return dist;
    }

    public boolean solutionFound() {
        if (!this.allSolutions.contains(this.solutionStack)) {
            ArrayList<RoutingLane> solution = new ArrayList<RoutingLane>(this.solutionStack);
            this.allSolutions.add(solution);
        }
        return true;
    }

    public void rotate(boolean b) {
        if (this.isRotated != b) {
            for (RoutingLane node : this) {
                node.rotate(b);
            }
            this.isRotated = b;
        }
    }

    public List<RoutingLane> getLanesAdjacentTo(ContainerShape shape, RoutingLane.Adjacence adjacence) {
        List<RoutingLane> adjacentLanes;
        ArrayList<RoutingLane> list = new ArrayList<RoutingLane>();
        if (shape == this.source) {
            adjacentLanes = this.sourceAdjacentLanes;
        } else if (shape == this.target) {
            adjacentLanes = this.targetAdjacentLanes;
        } else {
            return list;
        }
        org.eclipse.draw2d.geometry.Rectangle bounds = RoutingNet.getBounds(this.isRotated, (Shape)shape);
        for (RoutingLane a : adjacentLanes) {
            if (a.adjacent(bounds) != adjacence) continue;
            list.add(a);
        }
        return list;
    }

    private org.eclipse.draw2d.geometry.Rectangle getBounds(Shape target2) {
        return RoutingNet.getBounds(this.isRotated, target2);
    }

    protected static org.eclipse.draw2d.geometry.Rectangle getBounds(boolean rotate, Shape source2) {
        ILocation loc = peService.getLocationRelativeToDiagram(source2);
        IDimension size = GraphicsUtil.calculateSize((PictogramElement)source2);
        if (rotate) {
            return RoutingNet.rotateRectangle(loc.getX(), loc.getY(), size.getWidth(), size.getHeight());
        }
        return new org.eclipse.draw2d.geometry.Rectangle(loc.getX(), loc.getY(), size.getWidth(), size.getHeight());
    }

    protected static org.eclipse.draw2d.geometry.Rectangle rotateRectangle(int x, int y, int width, int height) {
        return RoutingNet.rotateRectangle(new org.eclipse.draw2d.geometry.Rectangle(x, y, width, height));
    }

    public static org.eclipse.draw2d.geometry.Rectangle rotateRectangle(org.eclipse.draw2d.geometry.Rectangle r) {
        int y = r.x;
        int x = r.y;
        int w = r.height;
        int h = r.width;
        r.x = x;
        r.y = y;
        r.width = w;
        r.height = h;
        return r;
    }

    public void drawLanes() {
        if (this.fp != null) {
            Diagram diagram = this.fp.getDiagramTypeProvider().getDiagram();
            for (RoutingLane a : this) {
                AddContext context = new AddContext();
                context.setTargetContainer((ContainerShape)diagram);
                context.setNewObject((Object)a);
                context.setX(a.getX());
                context.setY(a.getY());
                context.setSize(a.getWidth(), a.getHeight());
                AddRoutingLaneFeature feature = new AddRoutingLaneFeature(this.fp);
                a.setShape(feature.add((IAddContext)context));
            }
        }
    }

    public void drawConnections() {
        if (this.fp != null) {
            Diagram diagram = this.fp.getDiagramTypeProvider().getDiagram();
            for (RoutingLane n1 : this) {
                for (RoutingLane n2 : n1.getRight()) {
                    Anchor targetAnchor;
                    org.eclipse.draw2d.geometry.Rectangle r;
                    FixPointAnchor a;
                    Anchor sourceAnchor;
                    if (n1 == n2) continue;
                    ContainerShape sourceShape = n1.getShape();
                    ContainerShape targetShape = n2.getShape();
                    if (sourceShape == null || targetShape == null) continue;
                    if (sourceShape.getAnchors().size() > 0) {
                        sourceAnchor = (Anchor)sourceShape.getAnchors().get(0);
                    } else {
                        a = peService.createFixPointAnchor((AnchorContainer)sourceShape);
                        r = RoutingNet.getBounds(false, (Shape)sourceShape);
                        a.setLocation(GraphicsUtil.createPoint(r.width / 2, r.height / 2));
                        gaService.createInvisibleRectangle((PictogramElement)a);
                        sourceAnchor = a;
                    }
                    if (targetShape.getAnchors().size() > 0) {
                        targetAnchor = (Anchor)targetShape.getAnchors().get(0);
                    } else {
                        a = peService.createFixPointAnchor((AnchorContainer)targetShape);
                        r = RoutingNet.getBounds(false, (Shape)targetShape);
                        a.setLocation(GraphicsUtil.createPoint(r.width / 2, r.height / 2));
                        gaService.createInvisibleRectangle((PictogramElement)a);
                        targetAnchor = a;
                    }
                    AddConnectionContext context = new AddConnectionContext(sourceAnchor, targetAnchor);
                    context.setTargetContainer((ContainerShape)diagram);
                    context.setNewObject((Object)new Object[]{n1, n2});
                    AddRoutingLaneConnectionFeature feature = new AddRoutingLaneConnectionFeature(this.fp);
                    feature.add((IAddContext)context);
                }
            }
        }
    }

    public void drawSolution(List<RoutingLane> net, int i) {
        if (this.fp != null) {
            Diagram diagram = this.fp.getDiagramTypeProvider().getDiagram();
            for (RoutingLane a : net) {
                AddContext context = new AddContext();
                context.setTargetContainer((ContainerShape)diagram);
                context.setNewObject(null);
                context.setLocation(a.getX(), a.getY());
                context.setSize(a.getWidth(), a.getHeight());
                AddRoutingLaneFeature feature = new AddRoutingLaneFeature(this.fp);
                a.setShape(feature.add((IAddContext)context));
            }
        }
    }

    public void eraseLanes() {
        if (this.fp != null) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                RoutingLane cfr_ignored_0 = (RoutingLane)iterator.next();
                Diagram diagram = this.fp.getDiagramTypeProvider().getDiagram();
                ArrayList<ContainerShape> deleted = new ArrayList<ContainerShape>();
                TreeIterator iter = diagram.eAllContents();
                while (iter.hasNext()) {
                    ContainerShape s;
                    Object o = iter.next();
                    if (!(o instanceof ContainerShape) || FeatureSupport.getPropertyValue((PropertyContainer)(s = (ContainerShape)o), LANE) == null) continue;
                    deleted.add(s);
                }
                for (ContainerShape s : deleted) {
                    DeleteContext context = new DeleteContext((PictogramElement)s);
                    DeleteRoutingLaneFeature feature = new DeleteRoutingLaneFeature(this.fp);
                    feature.delete((IDeleteContext)context);
                }
            }
        }
    }

    private class AddRoutingLaneConnectionFeature
    extends AbstractAddShapeFeature {
        public AddRoutingLaneConnectionFeature(IFeatureProvider fp) {
            super(fp);
        }

        public boolean canAdd(IAddContext ac) {
            return true;
        }

        public PictogramElement add(IAddContext ac) {
            IAddConnectionContext context = (IAddConnectionContext)ac;
            Anchor sourceAnchor = context.getSourceAnchor();
            Anchor targetAnchor = context.getTargetAnchor();
            ContainerShape cfr_ignored_0 = (ContainerShape)sourceAnchor.getParent();
            ContainerShape cfr_ignored_1 = (ContainerShape)targetAnchor.getParent();
            Object[] newObject = (Object[])context.getNewObject();
            RoutingLane cfr_ignored_2 = (RoutingLane)newObject[0];
            RoutingLane cfr_ignored_3 = (RoutingLane)newObject[1];
            Diagram diagram = this.getDiagram();
            FreeFormConnection connection = peService.createFreeFormConnection(diagram);
            connection.setStart(sourceAnchor);
            connection.setEnd(targetAnchor);
            FeatureSupport.setPropertyValue((PropertyContainer)connection, RoutingNet.CONNECTION, "true");
            Polyline connectionLine = Graphiti.getGaService().createPolyline((GraphicsAlgorithmContainer)connection);
            connectionLine.setLineWidth(Integer.valueOf(1));
            ColorConstant foreground = new ColorConstant(0, 0, 255);
            int w = 3;
            int l = 15;
            ConnectionDecorator decorator = peService.createConnectionDecorator((Connection)connection, false, 1.0, true);
            int[] nArray = new int[8];
            nArray[0] = -l;
            nArray[1] = w;
            nArray[4] = -l;
            nArray[5] = -w;
            nArray[6] = -l;
            nArray[7] = w;
            Polygon arrowhead = gaService.createPolygon((GraphicsAlgorithmContainer)decorator, nArray);
            arrowhead.setForeground(gaService.manageColor(diagram, (IColorConstant)foreground));
            connectionLine.setForeground(gaService.manageColor(diagram, (IColorConstant)foreground));
            return connection;
        }
    }

    protected class AddRoutingLaneFeature
    extends AbstractAddShapeFeature {
        public AddRoutingLaneFeature(IFeatureProvider fp) {
            super(fp);
        }

        public boolean canAdd(IAddContext context) {
            return true;
        }

        public PictogramElement add(IAddContext context) {
            int x = context.getX();
            int y = context.getY();
            int width = context.getWidth();
            int height = context.getHeight();
            ColorConstant foreground = new ColorConstant(0, 0, 255);
            RoutingLane lane = (RoutingLane)context.getNewObject();
            ColorConstant background = new ColorConstant(128, 128, 128);
            double transparency = 0.75;
            org.eclipse.draw2d.geometry.Rectangle bounds = RoutingNet.this.getBounds(RoutingNet.this.source);
            if (lane == null) {
                Object bg = context.getProperty((Object)"background");
                background = bg instanceof ColorConstant ? (ColorConstant)bg : new ColorConstant(0, 255, 255);
                transparency = 0.5;
            } else {
                boolean sourceAdjacent = false;
                if (lane.adjacent(bounds) != RoutingLane.Adjacence.NONE) {
                    background = new ColorConstant(0, 255, 0);
                    transparency = 0.25;
                    sourceAdjacent = true;
                }
                if (lane.adjacent(bounds = RoutingNet.this.getBounds(RoutingNet.this.target)) != RoutingLane.Adjacence.NONE) {
                    background = sourceAdjacent ? new ColorConstant(255, 255, 0) : new ColorConstant(255, 0, 0);
                    transparency = 0.25;
                }
            }
            Diagram diagram = this.getDiagram();
            ContainerShape containerShape = peService.createContainerShape(context.getTargetContainer(), true);
            Rectangle invisibleRect = gaService.createInvisibleRectangle((PictogramElement)containerShape);
            gaService.setLocationAndSize((GraphicsAlgorithm)invisibleRect, x, y, width, height);
            Shape rectShape = peService.createShape(containerShape, false);
            RoundedRectangle roundedRect = gaService.createRoundedRectangle((GraphicsAlgorithmContainer)rectShape, 1, 1);
            roundedRect.setForeground(gaService.manageColor(diagram, (IColorConstant)foreground));
            roundedRect.setBackground(gaService.manageColor(diagram, (IColorConstant)background));
            roundedRect.setFilled(Boolean.valueOf(true));
            roundedRect.setTransparency(Double.valueOf(transparency));
            roundedRect.setLineWidth(Integer.valueOf(2));
            FeatureSupport.setPropertyValue((PropertyContainer)containerShape, RoutingNet.LANE, "true");
            gaService.setLocationAndSize((GraphicsAlgorithm)roundedRect, 0, 0, width, height);
            peService.sendToFront((Shape)containerShape);
            return containerShape;
        }
    }

    private class DeleteRoutingLaneFeature
    extends DefaultDeleteFeature {
        public DeleteRoutingLaneFeature(IFeatureProvider fp) {
            super(fp);
        }
    }
}

