/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.utils;

import org.eclipse.bpmn2.modeler.core.Activator;
import org.eclipse.bpmn2.modeler.core.utils.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class ErrorUtils {
    public static void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "org.eclipse.bpmn2.modeler.core", 0, message, null);
        Platform.getLog((Bundle)Activator.getDefault().getBundle()).log((IStatus)status);
        throw new CoreException((IStatus)status);
    }

    public static void showErrorWithLogging(IStatus status) {
        Platform.getLog((Bundle)Activator.getDefault().getBundle()).log(status);
        ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.ErrorUtils_Title, null, (IStatus)status);
    }

    public static void showErrorMessage(final String msg) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbench wb = PlatformUI.getWorkbench();
                IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
                if (win == null) {
                    return;
                }
                IWorkbenchPage page = win.getActivePage();
                if (page == null) {
                    return;
                }
                IWorkbenchPart part = page.getActivePart();
                if (part == null) {
                    return;
                }
                IActionBars actionBars = null;
                IWorkbenchPartSite site = part.getSite();
                if (site instanceof IViewSite) {
                    actionBars = ((IViewSite)site).getActionBars();
                } else if (site instanceof IEditorSite) {
                    actionBars = ((IEditorSite)site).getActionBars();
                }
                if (actionBars == null) {
                    return;
                }
                IStatusLineManager statusLineManager = actionBars.getStatusLineManager();
                if (statusLineManager == null) {
                    return;
                }
                statusLineManager.setErrorMessage(msg);
                statusLineManager.markDirty();
                statusLineManager.update(true);
            }
        });
    }
}

