/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.examples.dynamic;

import java.net.URL;
import org.eclipse.bpmn2.modeler.core.runtime.CustomTaskDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntime;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.Image;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.internal.GraphitiUIPlugin;
import org.eclipse.graphiti.ui.platform.AbstractImageProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;

public class SampleImageProvider
extends AbstractImageProvider {
    public static final String IMAGE_ID_PREFIX = String.valueOf(SampleImageProvider.class.getPackage().getName()) + ".";
    public static final String ICONS_FOLDER = "icons/";
    private static boolean registered = false;

    public static void registerAvailableImages() {
        if (!registered) {
            ImageRegistry imageRegistry = GraphitiUIPlugin.getDefault().getImageRegistry();
            TargetRuntime rt = TargetRuntime.getRuntime((String)"org.eclipse.bpmn2.modeler.examples.dynamic");
            IconSize[] iconSizeArray = IconSize.values();
            int n = iconSizeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IconSize size = iconSizeArray[n2];
                for (CustomTaskDescriptor ctd : rt.getCustomTaskDescriptors()) {
                    String imageId = SampleImageProvider.getImageId(ctd, size);
                    if (imageId == null) continue;
                    String filename = SampleImageProvider.getImagePath(ctd, size);
                    URL url = SampleImageProvider.class.getClassLoader().getResource(filename);
                    ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)url);
                    imageRegistry.put(imageId, descriptor);
                }
                ++n2;
            }
            registered = true;
        }
    }

    protected void addAvailableImages() {
        TargetRuntime rt = TargetRuntime.getRuntime((String)"org.eclipse.bpmn2.modeler.examples.dynamic");
        IconSize[] iconSizeArray = IconSize.values();
        int n = iconSizeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IconSize size = iconSizeArray[n2];
            for (CustomTaskDescriptor ctd : rt.getCustomTaskDescriptors()) {
                String imageId = SampleImageProvider.getImageId(ctd, size);
                if (imageId == null) continue;
                this.addImageFilePath(imageId, SampleImageProvider.getImagePath(ctd, size));
            }
            ++n2;
        }
    }

    public static Image createImage(GraphicsAlgorithmContainer ga, CustomTaskDescriptor ctd, int w, int h) {
        String imageId = SampleImageProvider.getImageId(ctd, IconSize.HUGE);
        Image img = null;
        if (imageId != null) {
            img = Graphiti.getGaService().createImage(ga, imageId);
            img.setProportional(Boolean.valueOf(false));
            img.setWidth(w);
            img.setHeight(h);
            img.setStretchH(Boolean.valueOf(true));
            img.setStretchV(Boolean.valueOf(true));
        }
        return img;
    }

    public static String getImageId(CustomTaskDescriptor ctd, IconSize size) {
        String icon = (String)ctd.getPropertyValue("icon");
        if (icon != null && icon.trim().length() > 0) {
            return String.valueOf(IMAGE_ID_PREFIX) + icon.trim() + "." + size.value;
        }
        return null;
    }

    public static String getImagePath(CustomTaskDescriptor ctd, IconSize size) {
        String icon = (String)ctd.getPropertyValue("icon");
        if (icon != null && icon.trim().length() > 0) {
            return ICONS_FOLDER + size.value + "/" + icon.trim();
        }
        return null;
    }

    public static enum IconSize {
        SMALL("small"),
        LARGE("large"),
        HUGE("huge");

        private String value;

        private IconSize(String value) {
            this.value = value;
        }
    }
}

