/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.property.providers;

import java.util.ArrayList;
import org.eclipse.bpmn2.modeler.ui.Activator;
import org.eclipse.bpmn2.modeler.ui.property.providers.JavaMemberTreeNode;
import org.eclipse.bpmn2.modeler.ui.property.providers.TreeNode;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.swt.graphics.Image;

public class JavaTypeTreeNode
extends TreeNode {
    public JavaTypeTreeNode(Object modelObject, boolean isCondensed) {
        super(modelObject, isCondensed);
    }

    @Override
    public String getLabel() {
        IType c = (IType)this.modelObject;
        return String.valueOf(c.getElementName()) + " - " + c.getFullyQualifiedName('.');
    }

    @Override
    public Image getImage() {
        IType c = (IType)this.modelObject;
        try {
            if (c.isInterface()) {
                return Activator.getDefault().getImage("obj16/javaInterface.png");
            }
        }
        catch (JavaModelException javaModelException) {}
        return Activator.getDefault().getImage("obj16/javaClass.png");
    }

    @Override
    public boolean hasChildren() {
        return false;
    }

    @Override
    public Object[] getChildren() {
        ArrayList<TreeNode> kids = new ArrayList<TreeNode>();
        try {
            IType c = (IType)this.modelObject;
            IField[] iFieldArray = c.getFields();
            int n = iFieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                IField f = iFieldArray[n2];
                if (Flags.isPublic((int)f.getFlags())) {
                    kids.add(new JavaMemberTreeNode(f, this.isCondensed));
                }
                ++n2;
            }
            iFieldArray = c.getMethods();
            n = iFieldArray.length;
            n2 = 0;
            while (n2 < n) {
                IField m = iFieldArray[n2];
                if (Flags.isPublic((int)m.getFlags()) && !m.isConstructor() || c.isInterface()) {
                    kids.add(new JavaMemberTreeNode(m, this.isCondensed));
                }
                ++n2;
            }
            iFieldArray = c.getTypes();
            n = iFieldArray.length;
            n2 = 0;
            while (n2 < n) {
                IField ic = iFieldArray[n2];
                if (Flags.isPublic((int)ic.getFlags())) {
                    kids.add(new JavaTypeTreeNode(ic, this.isCondensed));
                }
                ++n2;
            }
        }
        catch (Exception exception) {}
        return kids.toArray(new Object[kids.size()]);
    }
}

