/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.wizards;

import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.wizard.WizardPage;

public abstract class StatusWizardPage
extends WizardPage {
    private IStatus fCurrStatus = StatusWizardPage.createStatus(0, "");
    private boolean fPageVisible = false;
    private boolean fNoErrorOnStartup;

    public StatusWizardPage(String name, boolean noErrorOnStartup) {
        super(name);
        this.fNoErrorOnStartup = noErrorOnStartup;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.fPageVisible = visible;
        if (visible && this.fNoErrorOnStartup && this.fCurrStatus.matches(4)) {
            this.fCurrStatus = StatusWizardPage.createStatus(4, "");
        }
        this.updateStatus(this.fCurrStatus);
    }

    protected void updateStatus(IStatus status) {
        this.fCurrStatus = status;
        this.setPageComplete(!status.matches(4));
        if (this.fPageVisible) {
            StatusWizardPage.applyToStatusLine((DialogPage)this, status);
        }
    }

    public static void applyToStatusLine(DialogPage page, IStatus status) {
        String errorMessage = null;
        String warningMessage = null;
        String statusMessage = status.getMessage();
        if (statusMessage.length() > 0) {
            if (status.matches(4)) {
                errorMessage = statusMessage;
            } else if (!status.isOK()) {
                warningMessage = statusMessage;
            }
        }
        page.setErrorMessage(errorMessage);
        page.setMessage(warningMessage, status.getSeverity());
    }

    public static IStatus getMoreSevere(IStatus s1, IStatus s2) {
        if (s1.getSeverity() >= s2.getSeverity()) {
            return s1;
        }
        return s2;
    }

    public static IStatus createStatus(int severity, String message) {
        return new Status(severity, MakeUIPlugin.getUniqueIdentifier(), severity, message, null);
    }
}

