/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.launching;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IDeployment;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IExecutionEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.internal.launching.DLTKLaunchingPlugin;
import org.eclipse.dltk.internal.launching.EnvironmentResolver;
import org.eclipse.dltk.internal.launching.InterpreterMessages;
import org.eclipse.dltk.launching.EnvironmentVariable;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstallType;
import org.eclipse.dltk.launching.LaunchingMessages;
import org.eclipse.dltk.launching.LibraryLocation;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractInterpreterInstallType
implements IInterpreterInstallType,
IExecutableExtension {
    private static final int NOT_WORK_COUNT = -2;
    private static final String DLTK_TOTAL_WORK_START = "%DLTK_TOTAL_WORK_START%:";
    private static final String DLTK_TOTAL_WORK_END = "%DLTK_TOTAL_WORK_END%";
    private static final String DLTK_TOTAL_WORK_INC = "%DLTK_TOTAL_WORK_INCREMENT%";
    public static final String DLTK_PATH_PREFIX = "DLTK:";
    private List<IInterpreterInstall> fInterpreters = new ArrayList<IInterpreterInstall>();
    private String fId;
    private static HashMap<Object, LibraryLocation[]> fCachedLocations = new HashMap();

    protected AbstractInterpreterInstallType() {
    }

    @Override
    public IInterpreterInstall[] getInterpreterInstalls() {
        return this.fInterpreters.toArray(new IInterpreterInstall[this.fInterpreters.size()]);
    }

    @Override
    public void disposeInterpreterInstall(String id) {
        Iterator<IInterpreterInstall> it = this.fInterpreters.iterator();
        while (it.hasNext()) {
            IInterpreterInstall install = it.next();
            if (!install.getId().equals(id)) continue;
            it.remove();
            ScriptRuntime.fireInterpreterRemoved(install);
            return;
        }
    }

    @Override
    public IInterpreterInstall findInterpreterInstall(String id) {
        for (IInterpreterInstall install : this.fInterpreters) {
            if (!install.getId().equals(id)) continue;
            return install;
        }
        return null;
    }

    @Override
    public IInterpreterInstall createInterpreterInstall(String id) throws IllegalArgumentException {
        if (this.findInterpreterInstall(id) != null) {
            String format = LaunchingMessages.InterpreterInstallType_duplicateInterpreter;
            throw new IllegalArgumentException(NLS.bind((String)format, (Object)id));
        }
        IInterpreterInstall install = this.doCreateInterpreterInstall(id);
        this.fInterpreters.add(install);
        return install;
    }

    protected abstract IInterpreterInstall doCreateInterpreterInstall(String var1);

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
        this.fId = config.getAttribute("id");
    }

    @Override
    public String getId() {
        return this.fId;
    }

    @Override
    public IInterpreterInstall findInterpreterInstallByName(String name) {
        for (IInterpreterInstall install : this.fInterpreters) {
            if (!install.getName().equals(name)) continue;
            return install;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void storeFile(File dest, URL url) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            BufferedInputStream input = new BufferedInputStream(url.openStream());
            try {
                try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(dest));){
                    int ch = -1;
                    while ((ch = ((InputStream)input).read()) != -1) {
                        ((OutputStream)output).write(ch);
                    }
                }
                if (input == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (input == null) throw throwable;
                ((InputStream)input).close();
                throw throwable;
            }
            ((InputStream)input).close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    protected String[] extractEnvironment(IExecutionEnvironment exeEnv, EnvironmentVariable[] variables) {
        Map env = exeEnv.getEnvironmentVariables(false);
        if (env == null) {
            return null;
        }
        this.filterEnvironment(env);
        if (variables != null) {
            EnvironmentVariable[] vars = EnvironmentResolver.resolve(env, variables);
            int i = 0;
            while (i < vars.length) {
                env.put(vars[i].getName(), vars[i].getValue());
                ++i;
            }
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry entry : env.entrySet()) {
            list.add(String.valueOf((String)entry.getKey()) + "=" + (String)entry.getValue());
        }
        return list.toArray(new String[list.size()]);
    }

    protected void filterEnvironment(Map<String, String> environment) {
    }

    protected String[] readPathsFromProcess(IProgressMonitor monitor, Process process) {
        ArrayList result;
        block2: {
            BufferedReader dataIn = new BufferedReader(new InputStreamReader(process.getInputStream()));
            result = new ArrayList();
            Thread tReading = new Thread(() -> {
                boolean workReceived = false;
                try {
                    try {
                        while (true) {
                            if (monitor != null && monitor.isCanceled()) {
                                monitor.worked(1);
                                process.destroy();
                            } else {
                                int work;
                                String line = dataIn.readLine();
                                if (line != null && monitor != null && !workReceived && (work = this.extractWorkFromLine(line)) != -2) {
                                    monitor.beginTask(LaunchingMessages.AbstractInterpreterInstallType_fetchingInterpreterLibraryLocations, work);
                                    workReceived = true;
                                }
                                if (line != null && monitor != null && this.detectWorkInc(line)) {
                                    monitor.worked(1);
                                }
                                if (line != null) {
                                    result.add(line);
                                    continue;
                                }
                            }
                            break;
                        }
                    }
                    catch (IOException e) {
                        DLTKLaunchingPlugin.log((IStatus)new Status(1, "org.eclipse.dltk.launching", 1, NLS.bind((String)LaunchingMessages.AbstractInterpreterInstallType_failedToReadFromDiscoverScriptOutputStream, (Object)e.getMessage()), (Throwable)e));
                        if (monitor != null) {
                            if (!workReceived) {
                                monitor.beginTask(LaunchingMessages.AbstractInterpreterInstallType_fetchingInterpreterLibraryLocations, 1);
                            }
                            monitor.done();
                        }
                    }
                }
                finally {
                    if (monitor != null) {
                        if (!workReceived) {
                            monitor.beginTask(LaunchingMessages.AbstractInterpreterInstallType_fetchingInterpreterLibraryLocations, 1);
                        }
                        monitor.done();
                    }
                }
            });
            tReading.start();
            try {
                tReading.join(10000L);
            }
            catch (InterruptedException e) {
                if (!DLTKCore.DEBUG) break block2;
                e.printStackTrace();
            }
        }
        return result.toArray(new String[result.size()]);
    }

    private boolean detectWorkInc(String line) {
        return line.indexOf(DLTK_TOTAL_WORK_INC) != -1;
    }

    private int extractWorkFromLine(String line) {
        int pos1 = line.indexOf(DLTK_TOTAL_WORK_START);
        int pos2 = line.indexOf(DLTK_TOTAL_WORK_END);
        if (pos1 != -1 && pos2 != -1) {
            String totalWork = line.substring(pos1 + DLTK_TOTAL_WORK_START.length(), pos2);
            int intValue = Integer.parseInt(totalWork);
            if (intValue == -1) {
                return -1;
            }
            return intValue;
        }
        return -2;
    }

    public static LibraryLocation[] correctLocations(List<LibraryLocation> locs) {
        return AbstractInterpreterInstallType.correctLocations(locs, null);
    }

    public static LibraryLocation[] correctLocations(List<LibraryLocation> locs, IProgressMonitor monitor) {
        ArrayList<LibraryLocation> resolvedLocs = new ArrayList<LibraryLocation>();
        if (monitor != null) {
            monitor.beginTask(LaunchingMessages.AbstractInterpreterInstallType_correctingLocations, locs.size());
        }
        for (LibraryLocation n : locs) {
            if (!resolvedLocs.contains(n)) {
                resolvedLocs.add(n);
            }
            if (monitor == null) continue;
            monitor.worked(1);
        }
        LibraryLocation[] libs = resolvedLocs.toArray(new LibraryLocation[resolvedLocs.size()]);
        if (monitor != null) {
            monitor.done();
        }
        return libs;
    }

    protected void fillLocationsExceptOne(IEnvironment env, List<LibraryLocation> locs, String[] paths, IPath path) {
        String sPath = path.toOSString();
        int i = 0;
        while (i < paths.length) {
            LibraryLocation l;
            IFileHandle f;
            if (!paths[i].equals(sPath) && (f = env.getFile((IPath)new Path(paths[i]))).exists() && !locs.contains(l = new LibraryLocation(EnvironmentPathUtils.getFullPath((IEnvironment)env, (IPath)f.getPath())))) {
                locs.add(l);
            }
            ++i;
        }
    }

    protected void runLibraryLookup(ILookupRunnable runnable, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        runnable.run(monitor);
    }

    protected abstract String[] getPossibleInterpreterNames();

    protected abstract String getPluginId();

    protected abstract ILog getLog();

    protected abstract IPath createPathFile(IDeployment var1) throws IOException;

    protected String[] buildCommandLine(IFileHandle installLocation, IFileHandle pathFile) {
        String interpreterPath = installLocation.getCanonicalPath();
        String scriptPath = pathFile.getCanonicalPath();
        return new String[]{interpreterPath, scriptPath};
    }

    protected String getBuildPathDelimeter() {
        return " ";
    }

    protected String[] parsePaths(String result) {
        String res = result;
        if (res.startsWith(DLTK_PATH_PREFIX)) {
            res = res.substring(DLTK_PATH_PREFIX.length());
        }
        String[] paths = res.split(this.getBuildPathDelimeter());
        ArrayList<String> filtered = new ArrayList<String>();
        int i = 0;
        while (i < paths.length) {
            if (!paths[i].equals(".")) {
                filtered.add(paths[i].trim());
            }
            ++i;
        }
        return filtered.toArray(new String[filtered.size()]);
    }

    protected String[] parsePaths(String[] result) {
        ArrayList<String> filtered = new ArrayList<String>();
        int k = 0;
        while (k < result.length) {
            String res = result[k];
            if (res.startsWith(DLTK_PATH_PREFIX)) {
                res = res.substring(DLTK_PATH_PREFIX.length());
                String[] paths = this.parsePaths(res);
                int i = 0;
                while (i < paths.length) {
                    if (!paths[i].equals(".")) {
                        filtered.add(paths[i].trim());
                    }
                    ++i;
                }
            }
            ++k;
        }
        return filtered.toArray(new String[filtered.size()]);
    }

    @Deprecated
    public IStatus validateInstallLocation(IFileHandle installLocation) {
        if (!installLocation.exists() || !installLocation.isFile()) {
            return this.createStatus(4, InterpreterMessages.errNonExistentOrInvalidInstallLocation, null);
        }
        return this.validatePossiblyName(installLocation);
    }

    @Override
    public IStatus validateInstallLocation(IFileHandle installLocation, EnvironmentVariable[] variables, LibraryLocation[] libraryLocations, IProgressMonitor monitor) {
        return this.validateInstallLocation(installLocation);
    }

    @Override
    public IFileHandle[] detectInstallLocations() {
        return null;
    }

    @Override
    public String generateDetectedInterpreterName(IFileHandle install) {
        String name = install.getName();
        if ((name = name.trim()).length() == 0) {
            name = this.getName();
        }
        return name;
    }

    @Override
    public IStatus validatePossiblyName(IFileHandle installLocation) {
        String[] possibleNames = this.getPossibleInterpreterNames();
        boolean matchFound = false;
        String name = installLocation.getName();
        Path nPath = new Path(name);
        IExecutionEnvironment execEnv = (IExecutionEnvironment)installLocation.getEnvironment().getAdapter(IExecutionEnvironment.class);
        if (execEnv != null) {
            int i = 0;
            while (i < possibleNames.length) {
                String possibleName = possibleNames[i].toLowerCase();
                if (execEnv.isValidExecutableAndEquals(possibleName, (IPath)nPath)) {
                    matchFound = true;
                    break;
                }
                ++i;
            }
        }
        if (matchFound) {
            return this.createStatus(0, "", null);
        }
        return this.createStatus(4, InterpreterMessages.errNoInterpreterExecutablesFound, null);
    }

    protected String retrivePaths(IExecutionEnvironment exeEnv, IFileHandle installLocation, List<LibraryLocation> locations, IProgressMonitor monitor, IFileHandle locator, EnvironmentVariable[] variables) {
        Process process = null;
        try {
            if (monitor != null && monitor.isCanceled()) {
                return null;
            }
            String[] env = this.extractEnvironment(exeEnv, variables);
            String[] cmdLine = this.buildCommandLine(installLocation, locator);
            try {
                if (DLTKLaunchingPlugin.TRACE_EXECUTION) {
                    this.traceExecution(LaunchingMessages.AbstractInterpreterInstallType_libraryDiscoveryScript, cmdLine, env);
                }
                if ((process = exeEnv.exec(cmdLine, null, env)) != null) {
                    String[] result = this.readPathsFromProcess(monitor, process);
                    if (result == null) {
                        throw new IOException(LaunchingMessages.AbstractInterpreterInstallType_nullResultFromProcess);
                    }
                    if (DLTKLaunchingPlugin.TRACE_EXECUTION) {
                        this.traceDiscoveryOutput(result);
                    }
                    String[] paths = null;
                    paths = result.length == 1 ? this.parsePaths(result[0]) : this.parsePaths(result);
                    IPath path = new Path(locator.getCanonicalPath()).removeLastSegments(1);
                    this.fillLocationsExceptOne(exeEnv.getEnvironment(), locations, paths, path);
                    StringBuffer resultBuffer = new StringBuffer();
                    int i = 0;
                    while (i < result.length) {
                        resultBuffer.append(result[i]).append("\n");
                        ++i;
                    }
                    String string = resultBuffer.toString();
                    return string;
                }
            }
            catch (CoreException e) {
                try {
                    DLTKLaunchingPlugin.log(e);
                    if (DLTKCore.DEBUG) {
                        e.printStackTrace();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            if (process != null) {
                process.destroy();
            }
            if (monitor != null) {
                monitor.done();
            }
        }
        return null;
    }

    private void traceDiscoveryOutput(String[] result) {
        StringBuffer sb = new StringBuffer();
        sb.append("-----------------------------------------------\n");
        sb.append("Discovery script output:").append('\n');
        sb.append("Output Result:");
        if (result != null) {
            int i = 0;
            while (i < result.length) {
                sb.append(" " + result[i]);
                ++i;
            }
        } else {
            sb.append("Null");
        }
        sb.append("\n-----------------------------------------------\n");
        System.out.println(sb);
    }

    private void traceExecution(String processLabel, String[] cmdLineLabel, String[] environment) {
        StringBuffer sb = new StringBuffer();
        sb.append("-----------------------------------------------\n");
        sb.append("Running ").append(processLabel).append('\n');
        sb.append("Command line: ");
        int i = 0;
        while (i < cmdLineLabel.length) {
            sb.append(" " + cmdLineLabel[i]);
            ++i;
        }
        sb.append("\n");
        sb.append("Environment:\n");
        if (environment != null) {
            i = 0;
            while (i < environment.length) {
                sb.append('\t').append(environment[i]).append('\n');
                ++i;
            }
        }
        sb.append("-----------------------------------------------\n");
        System.out.println(sb);
    }

    protected ILookupRunnable createLookupRunnable(IFileHandle installLocation, List<LibraryLocation> locations, EnvironmentVariable[] variables) {
        return monitor -> {
            block10: {
                try {
                    IEnvironment env = installLocation.getEnvironment();
                    IExecutionEnvironment exeEnv = (IExecutionEnvironment)env.getAdapter(IExecutionEnvironment.class);
                    if (exeEnv == null) {
                        return;
                    }
                    IDeployment deployment = exeEnv.createDeployment();
                    if (deployment == null) {
                        DLTKLaunchingPlugin.logWarning(LaunchingMessages.AbstractInterpreterInstallType_failedToDeployLibraryLocationsScript);
                        return;
                    }
                    try {
                        IPath deploymentPath = this.createPathFile(deployment);
                        IFileHandle locator = deployment.getFile(deploymentPath);
                        String result = this.retrivePaths(exeEnv, installLocation, locations, monitor, locator, variables);
                        String message = NLS.bind((String)LaunchingMessages.AbstractInterpreterInstallType_failedToResolveLibraryLocationsForWith, (Object)installLocation.getName(), (Object)locator.toOSString());
                        if (locations.size() == 0) {
                            if (result == null) {
                                DLTKLaunchingPlugin.log(message);
                            } else {
                                DLTKLaunchingPlugin.logWarning(message, new Exception(NLS.bind((String)LaunchingMessages.AbstractInterpreterInstallType_output, (Object)result)));
                            }
                        }
                    }
                    finally {
                        deployment.dispose();
                    }
                }
                catch (IOException e) {
                    DLTKLaunchingPlugin.log(LaunchingMessages.AbstractInterpreterInstallType_problemWhileResolvingInterpreterLibraries, e);
                    if (!DLTKCore.DEBUG) break block10;
                    e.printStackTrace();
                }
            }
        };
    }

    @Override
    public synchronized LibraryLocation[] getDefaultLibraryLocations(IFileHandle installLocation) {
        return this.getDefaultLibraryLocations(installLocation, null);
    }

    @Override
    public synchronized LibraryLocation[] getDefaultLibraryLocations(IFileHandle installLocation, EnvironmentVariable[] variables) {
        return this.getDefaultLibraryLocations(installLocation, variables, null);
    }

    @Override
    public synchronized LibraryLocation[] getDefaultLibraryLocations(IFileHandle installLocation, EnvironmentVariable[] variables, IProgressMonitor monitor) {
        Object cacheKey;
        if (monitor != null) {
            monitor.beginTask(NLS.bind((String)LaunchingMessages.AbstractInterpreterInstallType_resolvingLibraryPaths, (Object)this.getName()), 100);
        }
        if (fCachedLocations.containsKey(cacheKey = AbstractInterpreterInstallType.makeKey(installLocation, variables))) {
            return fCachedLocations.get(cacheKey);
        }
        ArrayList<LibraryLocation> locations = new ArrayList<LibraryLocation>();
        ILookupRunnable runnable = this.createLookupRunnable(installLocation, locations, variables);
        try {
            this.runLibraryLookup(runnable, (IProgressMonitor)(monitor != null ? new SubProgressMonitor(monitor, 95) : null));
        }
        catch (InvocationTargetException e) {
            this.getLog().log(this.createStatus(4, LaunchingMessages.AbstractInterpreterInstallType_errorResolvingDefaultLibraries, e));
        }
        catch (InterruptedException e) {
            this.getLog().log(this.createStatus(4, LaunchingMessages.AbstractInterpreterInstallType_errorResolvingDefaultLibraries, e));
        }
        LibraryLocation[] libs = AbstractInterpreterInstallType.correctLocations(locations, (IProgressMonitor)(monitor != null ? new SubProgressMonitor(monitor, 5) : null));
        if (libs.length != 0) {
            fCachedLocations.put(cacheKey, libs);
        }
        if (monitor != null) {
            monitor.done();
        }
        return libs;
    }

    public static Object makeKey(IFileHandle installLocation, EnvironmentVariable[] variables) {
        String key = installLocation.getFullPath().toString();
        if (variables != null) {
            int i = 0;
            while (i < variables.length) {
                key = String.valueOf(key) + "|" + variables[i].getName() + ":" + variables[i].getValue();
                ++i;
            }
        }
        return key;
    }

    protected IStatus createStatus(int severity, String message, Throwable throwable) {
        return new Status(severity, this.getPluginId(), 0, message, throwable);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fId == null ? 0 : this.fId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractInterpreterInstallType other = (AbstractInterpreterInstallType)obj;
        return !(this.fId == null ? other.fId != null : !this.fId.equals(other.fId));
    }

    public static interface ILookupRunnable {
        public void run(IProgressMonitor var1) throws InvocationTargetException, InterruptedException;
    }
}

