/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.validation;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jpt.common.core.internal.utility.ValidationMessageTools;
import org.eclipse.jpt.common.core.utility.ValidationMessage;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateAdapter;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.internal.plugin.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.validation.JptJpaCoreValidationMessages;
import org.eclipse.wst.validation.AbstractValidator;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IProjectValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

public class JpaValidator
extends AbstractValidator
implements IValidator {
    private static final String OLD_RELATIVE_MARKER_TYPE = "jpaProblemMarker";
    private static final String OLD_MARKER_TYPE = String.valueOf(JpaProject.MARKER_TYPE_SCOPE_) + "jpaProblemMarker";
    private static final Predicate<IMessage> MESSAGE_IS_NOT_IGNORED = new MessageIsNotIgnored();

    public void validate(IValidationContext context, IReporter reporter) {
        this.validate(reporter, ((IProjectValidationContext)context).getProject());
    }

    public void cleanup(IReporter reporter) {
    }

    public ValidationResult validate(IResource resource, int kind, ValidationState state, IProgressMonitor monitor) {
        if (resource.getType() != 1) {
            return null;
        }
        ValidationResult result = new ValidationResult();
        IReporter reporter = result.getReporter(monitor);
        IProject project = resource.getProject();
        result.setSuspendValidation(project);
        this.validate(reporter, project);
        return result;
    }

    private void validate(IReporter reporter, IProject project) {
        Iterable<IMessage> messages = this.buildNonIgnoredValidationMessages(reporter, project);
        this.clearMarkers(project);
        for (IMessage message : messages) {
            reporter.addMessage((IValidator)this, message);
        }
    }

    private Iterable<IMessage> buildNonIgnoredValidationMessages(IReporter reporter, IProject project) {
        return IterableTools.filter(this.buildValidationMessages(reporter, project), MESSAGE_IS_NOT_IGNORED);
    }

    private Iterable<IMessage> buildValidationMessages(IReporter reporter, IProject project) {
        try {
            return this.buildValidationMessages_(reporter, project);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(ex);
        }
    }

    private Iterable<IMessage> buildValidationMessages_(IReporter reporter, IProject project) throws InterruptedException {
        JpaProject.Reference ref = this.getJpaProjectReference(project);
        return ref != null ? ref.buildValidationMessages(reporter) : this.buildValidationFailedMessages(project);
    }

    private Iterable<IMessage> buildValidationFailedMessages(IProject project) {
        return IterableTools.singletonIterable((Object)this.buildValidationFailedMessage(project));
    }

    private IMessage buildValidationFailedMessage(IProject project) {
        return ValidationMessageTools.buildValidationMessage((IResource)project, (ValidationMessage)JptJpaCoreValidationMessages.JPA_VALIDATION_FAILED);
    }

    private JpaProject.Reference getJpaProjectReference(IProject project) {
        return (JpaProject.Reference)project.getAdapter(JpaProject.Reference.class);
    }

    private void clearMarkers(IProject project) {
        try {
            this.clearMarkers_(project);
        }
        catch (CoreException ex) {
            JptJpaCorePlugin.instance().logError(ex);
        }
    }

    private void clearMarkers_(IProject project) throws CoreException {
        Object[] markers = project.findMarkers(JpaProject.MARKER_TYPE, true, 2);
        ArrayTools.addAll((Object[])markers, (Object[])project.findMarkers(OLD_MARKER_TYPE, true, 2));
        Object[] objectArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            Object marker = objectArray[n2];
            marker.delete();
            ++n2;
        }
    }

    static class MessageIsNotIgnored
    extends PredicateAdapter<IMessage> {
        MessageIsNotIgnored() {
        }

        public boolean evaluate(IMessage message) {
            return message.getSeverity() != 8;
        }
    }
}

