/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.ui.internal.navigator.web;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jst.javaee.core.JavaEEObject;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.jee.ui.internal.Messages;
import org.eclipse.jst.jee.ui.internal.navigator.AbstractGroupProvider;
import org.eclipse.jst.jee.ui.internal.navigator.web.AbstractWebGroupProvider;
import org.eclipse.jst.jee.ui.internal.navigator.web.GroupContextParamsItemProvider;
import org.eclipse.jst.jee.ui.internal.navigator.web.GroupErrorPagesItemProvider;
import org.eclipse.jst.jee.ui.internal.navigator.web.GroupFilterMappingItemProvider;
import org.eclipse.jst.jee.ui.internal.navigator.web.GroupFiltersItemProvider;
import org.eclipse.jst.jee.ui.internal.navigator.web.GroupListenerItemProvider;
import org.eclipse.jst.jee.ui.internal.navigator.web.GroupReferenceItemProvider;
import org.eclipse.jst.jee.ui.internal.navigator.web.GroupServletItemProvider;
import org.eclipse.jst.jee.ui.internal.navigator.web.GroupServletMappingItemProvider;
import org.eclipse.jst.jee.ui.internal.navigator.web.GroupWelcomePagesItemProvider;
import org.eclipse.jst.jee.ui.plugin.JEEUIPlugin;
import org.eclipse.jst.jee.ui.plugin.JEEUIPluginIcons;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;

public class WebAppProvider
extends AbstractWebGroupProvider
implements IAdaptable {
    private static final String PROJECT_RELATIVE_PATH = "WEB-INF/web.xml";
    private GroupErrorPagesItemProvider errors;
    private GroupServletItemProvider servlets;
    private GroupFiltersItemProvider filters;
    private GroupListenerItemProvider listeners;
    private GroupServletMappingItemProvider servletMapping;
    private GroupFilterMappingItemProvider filterMapping;
    private GroupReferenceItemProvider references;
    private GroupWelcomePagesItemProvider welcome;
    private GroupContextParamsItemProvider contextParams;
    private List<AbstractGroupProvider> children2 = new ArrayList<AbstractGroupProvider>();
    private String text2;
    private Image web25Image;
    private Image web30Image;
    private Image web31Image;
    private Image web40Image;
    private Image web50Image;
    private IProject prjct = null;
    private IFile ddFile = null;

    public WebAppProvider(WebApp webApp, IProject project) {
        super((JavaEEObject)webApp);
        this.text2 = NLS.bind((String)Messages.DEPLOYMENT_DESCRIPTOR, (Object)project.getName());
        this.contextParams = new GroupContextParamsItemProvider(webApp);
        this.errors = new GroupErrorPagesItemProvider(webApp);
        this.servlets = new GroupServletItemProvider(webApp);
        this.servletMapping = new GroupServletMappingItemProvider(webApp);
        this.filters = new GroupFiltersItemProvider(webApp);
        this.filterMapping = new GroupFilterMappingItemProvider(webApp);
        this.listeners = new GroupListenerItemProvider(webApp);
        this.references = new GroupReferenceItemProvider(webApp);
        this.welcome = new GroupWelcomePagesItemProvider(webApp);
        this.children2.add(this.contextParams);
        this.children2.add(this.errors);
        this.children2.add(this.servlets);
        this.children2.add(this.filters);
        this.children2.add(this.listeners);
        this.children2.add(this.servletMapping);
        this.children2.add(this.filterMapping);
        this.children2.add(this.references);
        this.children2.add(this.welcome);
        this.prjct = project;
    }

    public List getChildren() {
        return this.children2;
    }

    public String getText() {
        return this.text2;
    }

    public Image getImage() {
        String version = null;
        if (this.javaee != null && ((WebApp)this.javaee).getVersion() != null) {
            version = ((WebApp)this.javaee).getVersion().getLiteral();
        }
        if ("2.5".equals(version)) {
            return this.getWeb25Image();
        }
        if ("3.0".equals(version)) {
            return this.getWeb30Image();
        }
        if ("3.1".equals(version)) {
            return this.getWeb31Image();
        }
        if ("4.0".equals(version)) {
            return this.getWeb40Image();
        }
        if ("5.0".equals(version)) {
            return this.getWeb50Image();
        }
        return this.getWeb25Image();
    }

    public IProject getProject() {
        return this.prjct;
    }

    public IFile getDDFile() {
        if (this.ddFile != null) {
            return this.ddFile;
        }
        IVirtualFolder virtualFolder = ComponentCore.createComponent((IProject)this.getProject()).getRootFolder();
        return virtualFolder.getFile(PROJECT_RELATIVE_PATH).getUnderlyingFile();
    }

    public void reinit(JavaEEObject modelObject) {
        super.reinit(modelObject);
        for (AbstractGroupProvider child : this.children2) {
            child.reinit(modelObject);
        }
    }

    public Object getAdapter(Class adapter) {
        if (IProject.class == adapter) {
            return this.getProject();
        }
        return null;
    }

    private Image getWeb25Image() {
        if (this.web25Image == null) {
            this.web25Image = JEEUIPlugin.getDefault().getImageDescriptor(JEEUIPluginIcons.IMG_WEBEEMODEL).createImage();
        }
        return this.web25Image;
    }

    private Image getWeb30Image() {
        if (this.web30Image == null) {
            this.web30Image = JEEUIPlugin.getDefault().getImageDescriptor(JEEUIPluginIcons.IMG_WEBEE6MODEL).createImage();
        }
        return this.web30Image;
    }

    private Image getWeb31Image() {
        if (this.web31Image == null) {
            this.web31Image = JEEUIPlugin.getDefault().getImageDescriptor(JEEUIPluginIcons.IMG_WEBEE7MODEL).createImage();
        }
        return this.web31Image;
    }

    private Image getWeb40Image() {
        if (this.web40Image == null) {
            this.web40Image = JEEUIPlugin.getDefault().getImageDescriptor(JEEUIPluginIcons.IMG_WEBEE8MODEL).createImage();
        }
        return this.web40Image;
    }

    private Image getWeb50Image() {
        if (this.web50Image == null) {
            this.web50Image = JEEUIPlugin.getDefault().getImageDescriptor(JEEUIPluginIcons.IMG_WEBEE9MODEL).createImage();
        }
        return this.web50Image;
    }
}

