/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.axis2.consumption.core.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jst.ws.axis2.consumption.core.data.Model;
import org.eclipse.jst.ws.axis2.core.utils.ClassLoadingUtil;

public class WSDLPropertyReader {
    private Object DefinitionInstance = null;
    private Class DefinitionClass = null;
    private Class ServiceClass = null;
    private Model model;

    public WSDLPropertyReader(Model model) {
        this.model = model;
    }

    public void readWSDL(String projectName, String filepath) throws Exception {
        ClassLoadingUtil.init((String)projectName);
        this.DefinitionClass = ClassLoadingUtil.loadClassFromAntClassLoader((String)"javax.wsdl.Definition");
        if (!this.model.isWsdlAlreadyLoaded(filepath)) {
            Class WSDLFactoryClass = ClassLoadingUtil.loadClassFromAntClassLoader((String)"javax.wsdl.factory.WSDLFactory");
            Method newInstanceMethod = WSDLFactoryClass.getMethod("newInstance", null);
            Object WSDLFactoryObject = newInstanceMethod.invoke(null, null);
            Class WSDLFactoryImplClass = ClassLoadingUtil.loadClassFromAntClassLoader((String)WSDLFactoryObject.getClass().getName());
            Method newWSDLReaderMethod = WSDLFactoryImplClass.getMethod("newWSDLReader", null);
            Object WSDLReaderObject = newWSDLReaderMethod.invoke(WSDLFactoryObject, null);
            Class WSDLReaderClass = ClassLoadingUtil.loadClassFromAntClassLoader((String)WSDLReaderObject.getClass().getName());
            Method readWSDLMethod = WSDLReaderClass.getMethod("readWSDL", String.class);
            this.model.setWsdlDefinitionInstance(readWSDLMethod.invoke(WSDLReaderObject, filepath), filepath);
        }
        this.DefinitionInstance = this.model.getWsdlDefinitionInstance();
    }

    public Map getDefinitionNamespaceMap() {
        Map map = null;
        try {
            Method getNamespacesMethod = this.DefinitionClass.getMethod("getNamespaces", null);
            map = (Map)getNamespacesMethod.invoke(this.DefinitionInstance, null);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return map;
    }

    public String packageFromTargetNamespace() {
        String returnString = null;
        try {
            Method getTargetNamespaceMethod = this.DefinitionClass.getMethod("getTargetNamespace", null);
            String packageName = (String)getTargetNamespaceMethod.invoke(this.DefinitionInstance, null);
            Class URLProcessorClass = ClassLoadingUtil.loadClassFromAntClassLoader((String)"org.apache.axis2.util.URLProcessor");
            Method makePackageNameMethod = URLProcessorClass.getMethod("makePackageName", String.class);
            returnString = (String)makePackageNameMethod.invoke(null, packageName);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return returnString;
    }

    public List getServiceList() {
        ArrayList<Object> returnList = new ArrayList<Object>();
        try {
            Method getServicesMethod = this.DefinitionClass.getMethod("getServices", null);
            Map serviceMap = (Map)getServicesMethod.invoke(this.DefinitionInstance, null);
            if (serviceMap != null && !serviceMap.isEmpty()) {
                Iterator serviceIterator = serviceMap.values().iterator();
                while (serviceIterator.hasNext()) {
                    this.ServiceClass = ClassLoadingUtil.loadClassFromAntClassLoader((String)"javax.wsdl.Service");
                    Method getQNameMethod = this.ServiceClass.getMethod("getQName", null);
                    Object serviceInstance = serviceIterator.next();
                    returnList.add(getQNameMethod.invoke(serviceInstance, null));
                }
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return returnList;
    }

    public List getPortNameList(Object serviceName) {
        ArrayList<Object> returnList = new ArrayList<Object>();
        try {
            Method getPortsMethod;
            Map portMap;
            Method getServiceMethod = this.DefinitionClass.getMethod("getService", serviceName.getClass());
            Object serviceInstance = getServiceMethod.invoke(this.DefinitionInstance, serviceName);
            Object portInstance2 = null;
            if (serviceInstance != null && (portMap = (Map)(getPortsMethod = this.ServiceClass.getMethod("getPorts", null)).invoke(serviceInstance, null)) != null && !portMap.isEmpty()) {
                for (Object portInstance2 : portMap.values()) {
                    Class PortClass = ClassLoadingUtil.loadClassFromAntClassLoader((String)"javax.wsdl.Port");
                    Method getNameMethod = PortClass.getMethod("getName", null);
                    returnList.add(getNameMethod.invoke(portInstance2, null));
                }
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return returnList;
    }

    public Object getWsdlDefinitionInstance() {
        return this.DefinitionInstance;
    }

    public Class getWsdlDefinitionClass() {
        return this.DefinitionClass;
    }
}

