/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.common;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.consumption.ConsumptionMessages;
import org.eclipse.jst.ws.internal.consumption.common.FacetUtils;
import org.eclipse.jst.ws.internal.consumption.common.IFacetOperationDelegate;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.osgi.framework.Bundle;

public class FacetOperationDelegate
implements IFacetOperationDelegate {
    public IStatus addFacetsToProject(final IFacetedProject fproject, final Set projectFacetVersions) {
        final IStatus[] status = new IStatus[]{Status.OK_STATUS};
        final Set actions = FacetUtils.getInstallActions((Set)projectFacetVersions);
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor shellMonitor) throws InvocationTargetException, InterruptedException {
                try {
                    fproject.modify(actions, shellMonitor);
                    FacetOperationDelegate.this.fixEJBClassPath(fproject);
                }
                catch (CoreException e) {
                    status[0] = FacetOperationDelegate.getErrorStatusForAddingFacets(fproject.getProject().getName(), projectFacetVersions, e);
                }
            }
        };
        if (FacetOperationDelegate.displayPresent()) {
            try {
                PlatformUI.getWorkbench().getProgressService().run(true, false, runnable);
            }
            catch (InvocationTargetException ite) {
                status[0] = FacetOperationDelegate.getErrorStatusForAddingFacets(fproject.getProject().getName(), projectFacetVersions, ite);
            }
            catch (InterruptedException ie) {
                status[0] = FacetOperationDelegate.getErrorStatusForAddingFacets(fproject.getProject().getName(), projectFacetVersions, ie);
            }
        } else {
            try {
                fproject.modify(actions, null);
                this.fixEJBClassPath(fproject);
            }
            catch (CoreException e) {
                status[0] = FacetOperationDelegate.getErrorStatusForAddingFacets(fproject.getProject().getName(), projectFacetVersions, e);
            }
        }
        return status[0];
    }

    private void fixEJBClassPath(IFacetedProject project) {
        if (!J2EEUtils.isEJBComponent((IProject)project.getProject())) {
            return;
        }
        IProject ejbProject = project.getProject();
        IJavaProject javaProject = JavaCore.create((IProject)ejbProject);
        Path projectRoot = new Path(Path.ROOT.append((IPath)new Path(ejbProject.getName())).toString());
        IPath ejbModulePath = projectRoot.append("ejbModule");
        try {
            IClasspathEntry[] originalSet = javaProject.getRawClasspath();
            boolean foundEJBModulEntry = false;
            IClasspathEntry[] iClasspathEntryArray = originalSet;
            int n = originalSet.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getPath().equals((Object)ejbModulePath)) {
                    foundEJBModulEntry = true;
                }
                ++n2;
            }
            if (!foundEJBModulEntry) {
                IClasspathEntry[] newSet = new IClasspathEntry[originalSet.length + 1];
                int i = 0;
                IClasspathEntry[] iClasspathEntryArray2 = originalSet;
                int n3 = originalSet.length;
                int n4 = 0;
                while (n4 < n3) {
                    IClasspathEntry entry = iClasspathEntryArray2[n4];
                    newSet[i++] = entry;
                    ++n4;
                }
                newSet[i] = JavaCore.newSourceEntry((IPath)ejbModulePath);
                javaProject.setRawClasspath(newSet, null);
            }
        }
        catch (Exception exception) {}
    }

    public IStatus createNewFacetedProject(final String projectName) {
        IStatus[] status;
        block8: {
            status = new IStatus[]{Status.OK_STATUS};
            IProject project = ProjectUtilities.getProject((String)projectName);
            if (!project.exists()) {
                IRunnableWithProgress runnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor shellMonitor) throws InvocationTargetException, InterruptedException {
                        try {
                            IFacetedProject fProject = ProjectFacetsManager.create((String)projectName, null, (IProgressMonitor)shellMonitor);
                            if (fProject == null) {
                                status[0] = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionMessages.MSG_ERROR_PROJECT_CREATION, (Object[])new String[]{projectName}));
                            }
                        }
                        catch (CoreException e) {
                            status[0] = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionMessages.MSG_ERROR_PROJECT_CREATION, (Object[])new String[]{projectName}), (Throwable)e);
                        }
                    }
                };
                try {
                    if (FacetOperationDelegate.displayPresent()) {
                        PlatformUI.getWorkbench().getProgressService().run(true, false, runnable);
                        break block8;
                    }
                    try {
                        IFacetedProject fProject = ProjectFacetsManager.create((String)projectName, null, null);
                        if (fProject == null) {
                            status[0] = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionMessages.MSG_ERROR_PROJECT_CREATION, (Object[])new String[]{projectName}));
                        }
                    }
                    catch (CoreException e) {
                        status[0] = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionMessages.MSG_ERROR_PROJECT_CREATION, (Object[])new String[]{projectName}), (Throwable)e);
                    }
                }
                catch (InvocationTargetException ite) {
                    status[0] = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionMessages.MSG_ERROR_PROJECT_CREATION, (Object[])new String[]{projectName}), (Throwable)ite);
                }
                catch (InterruptedException ie) {
                    status[0] = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionMessages.MSG_ERROR_PROJECT_CREATION, (Object[])new String[]{projectName}), (Throwable)ie);
                }
            }
        }
        return status[0];
    }

    public IStatus setFacetRuntimeOnProject(final IFacetedProject fProject, final IRuntime fRuntime) {
        final IStatus[] status = new IStatus[]{Status.OK_STATUS};
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor shellMonitor) throws InvocationTargetException, InterruptedException {
                try {
                    fProject.setTargetedRuntimes(Collections.singleton(fRuntime), shellMonitor);
                }
                catch (CoreException e) {
                    status[0] = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionMessages.MSG_ERROR_SETTING_RUNTIME, (Object[])new String[]{fProject.getProject().getName(), fRuntime.getName()}), (Throwable)e);
                }
            }
        };
        if (FacetOperationDelegate.displayPresent()) {
            try {
                PlatformUI.getWorkbench().getProgressService().run(true, false, runnable);
            }
            catch (InvocationTargetException ite) {
                status[0] = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionMessages.MSG_ERROR_SETTING_RUNTIME, (Object[])new String[]{fProject.getProject().getName(), fRuntime.getName()}), (Throwable)ite);
            }
            catch (InterruptedException ie) {
                status[0] = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionMessages.MSG_ERROR_SETTING_RUNTIME, (Object[])new String[]{fProject.getProject().getName(), fRuntime.getName()}), (Throwable)ie);
            }
        } else {
            try {
                fProject.setTargetedRuntimes(Collections.singleton(fRuntime), null);
            }
            catch (CoreException e) {
                status[0] = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionMessages.MSG_ERROR_SETTING_RUNTIME, (Object[])new String[]{fProject.getProject().getName(), fRuntime.getName()}), (Throwable)e);
            }
        }
        return status[0];
    }

    public IStatus setFixedFacetsOnProject(final IFacetedProject fProject, final Set fixedFacets) {
        final IStatus[] status = new IStatus[]{Status.OK_STATUS};
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor shellMonitor) throws InvocationTargetException, InterruptedException {
                try {
                    fProject.setFixedProjectFacets(fixedFacets);
                }
                catch (CoreException e) {
                    status[0] = FacetOperationDelegate.getErrorStatusForSettingFixedFacets(fProject.getProject().getName(), fixedFacets, e);
                }
            }
        };
        if (FacetOperationDelegate.displayPresent()) {
            try {
                PlatformUI.getWorkbench().getProgressService().run(true, false, runnable);
            }
            catch (InvocationTargetException ite) {
                status[0] = FacetOperationDelegate.getErrorStatusForSettingFixedFacets(fProject.getProject().getName(), fixedFacets, ite);
            }
            catch (InterruptedException ie) {
                status[0] = FacetOperationDelegate.getErrorStatusForSettingFixedFacets(fProject.getProject().getName(), fixedFacets, ie);
            }
        } else {
            try {
                fProject.setFixedProjectFacets(fixedFacets);
            }
            catch (CoreException e) {
                status[0] = FacetOperationDelegate.getErrorStatusForSettingFixedFacets(fProject.getProject().getName(), fixedFacets, e);
            }
        }
        return status[0];
    }

    private static boolean displayPresent() {
        Bundle b = Platform.getBundle((String)"org.eclipse.swt");
        if (b == null) {
            return false;
        }
        if (b.getState() != 4 && b.getState() != 32) {
            return false;
        }
        try {
            return Display.getCurrent() != null;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static String getFacetListMessageString(Set facets) {
        String facetListMessage = "";
        int size = facets.size();
        if (size > 0) {
            Iterator itr = facets.iterator();
            IProjectFacet firstProjectFacet = (IProjectFacet)itr.next();
            facetListMessage = firstProjectFacet.getLabel();
            while (itr.hasNext()) {
                IProjectFacet projectFacet = (IProjectFacet)itr.next();
                String pfLabel = projectFacet.getLabel();
                facetListMessage = NLS.bind((String)ConsumptionMessages.MSG_FACETS, (Object[])new String[]{facetListMessage, pfLabel});
            }
        }
        return facetListMessage;
    }

    private static IStatus getErrorStatusForSettingFixedFacets(String projectName, Set facets, Throwable t) {
        IStatus status = Status.OK_STATUS;
        int size = facets.size();
        if (size > 0) {
            String facetList = FacetOperationDelegate.getFacetListMessageString(facets);
            status = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionMessages.MSG_ERROR_FIXED_FACETS, (Object[])new String[]{projectName, facetList}), (Throwable)t);
        }
        return status;
    }

    private static IStatus getErrorStatusForAddingFacets(String projectName, Set projectFacetVersions, Throwable t) {
        IStatus status = Status.OK_STATUS;
        int size = projectFacetVersions.size();
        if (size > 0) {
            HashSet<IProjectFacet> facets = new HashSet<IProjectFacet>();
            for (IProjectFacetVersion projectFacet : projectFacetVersions) {
                IProjectFacet facet = projectFacet.getProjectFacet();
                facets.add(facet);
            }
            String facetList = FacetOperationDelegate.getFacetListMessageString(facets);
            status = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionMessages.MSG_ERROR_ADDING_FACETS_TO_PROJECT, (Object[])new String[]{projectName, facetList}), (Throwable)t);
        }
        return status;
    }
}

