/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.persistence;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IDOM;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWsDOMRuntimeExtension;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWsDomLoadListener;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.WsDOMLoadCanceledException;
import org.eclipse.jst.ws.jaxws.dom.runtime.internal.plugin.JaxWsDomRuntimeMessages;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.JaxWsWorkspaceResource;
import org.eclipse.jst.ws.jaxws.utils.ContractChecker;

public class Jee5WsDomRuntimeExtension
implements IWsDOMRuntimeExtension {
    public static final String ID = "org.eclipse.jst.ws.jaxws.dom.jee5";
    private List<IWsDomLoadListener> listeners = new ArrayList<IWsDomLoadListener>();
    private JaxWsWorkspaceResource workspaceResource;
    private boolean finished;
    private boolean started;

    public void createDOM(IProgressMonitor monitor) throws IOException, WsDOMLoadCanceledException {
        Job.getJobManager().beginRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot(), monitor);
        try {
            if (this.workspaceResource == null || this.workspaceResource.isLoadCnaceled()) {
                this.performLoad(monitor);
            }
        }
        finally {
            Job.getJobManager().endRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        }
    }

    private void performLoad(IProgressMonitor monitor) throws IOException, WsDOMLoadCanceledException {
        this.workspaceResource = this.createResource();
        this.workspaceResource.setProgressMonitor(monitor);
        try {
            this.started();
            this.workspaceResource.load(null);
            if (this.workspaceResource.isLoadCnaceled()) {
                throw this.createCanceledException();
            }
        }
        finally {
            this.finished();
        }
        this.workspaceResource.startSynchronizing();
    }

    public IDOM getDOM() throws WsDOMLoadCanceledException {
        if (this.workspaceResource == null) {
            return null;
        }
        if (this.workspaceResource.isLoadCnaceled()) {
            throw this.createCanceledException();
        }
        return this.workspaceResource.getDOM();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLoadListener(IWsDomLoadListener listener) {
        ContractChecker.nullCheckParam((Object)listener, (String)"listener");
        List<IWsDomLoadListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
        if (this.started) {
            listener.started();
        }
        if (this.finished) {
            listener.finished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLoadListener(IWsDomLoadListener listener) {
        ContractChecker.nullCheckParam((Object)listener, (String)"listener");
        List<IWsDomLoadListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    protected IJavaModel javaModel() {
        return JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
    }

    protected JaxWsWorkspaceResource createResource() {
        return new JaxWsWorkspaceResource(this.javaModel());
    }

    protected void finished() {
        this.finished = true;
        for (IWsDomLoadListener listener : this.listeners) {
            listener.finished();
        }
    }

    protected void started() {
        this.started = true;
        this.finished = false;
        for (IWsDomLoadListener listener : this.listeners) {
            listener.started();
        }
    }

    private WsDOMLoadCanceledException createCanceledException() {
        return new WsDOMLoadCanceledException("JAX-WS DOM loading canceled", JaxWsDomRuntimeMessages.WorkspaceCUFinder_LOADING_CANCELED);
    }
}

