/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.text.atl.types;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.AtlTypesProcessor;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.Feature;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.LibraryType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.ModuleType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.OclAnyType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.OclType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.Operation;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.QueryType;
import org.eclipse.m2m.atl.engine.parser.AtlSourceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UnitType
extends OclAnyType {
    protected AtlSourceManager sourceManager;
    private IFile file;
    private Map<OclAnyType, Set<Operation>> helpers;
    private Map<OclAnyType, Set<Feature>> attributes;
    private List<LibraryType> libraries = new ArrayList<LibraryType>();

    public UnitType(IFile file, AtlSourceManager manager, OclType unitType) {
        super(unitType);
        this.file = file;
        this.sourceManager = manager;
        this.init();
    }

    public IFile getFile() {
        return this.file;
    }

    @Override
    public OclAnyType[] getSupertypes() {
        return new OclAnyType[]{OclAnyType.getInstance()};
    }

    private void addHelper(OclAnyType context, Operation helper) {
        if (this.helpers == null) {
            this.helpers = new HashMap<OclAnyType, Set<Operation>>();
        }
        if (this.helpers.get(context) == null) {
            HashSet<Operation> contextHelpers = new HashSet<Operation>(helper){
                {
                    this.add(operation);
                }
            };
            this.helpers.put(context, (Set<Operation>)contextHelpers);
        } else {
            this.helpers.get(context).add(helper);
        }
    }

    protected abstract Collection<EObject> getHelpersObjects();

    protected void init() {
        if (this.sourceManager != null && this.sourceManager.getModel() != null) {
            Collection librariesObjects = (Collection)AtlTypesProcessor.eGet(this.sourceManager.getModel(), "libraries");
            for (EObject libraryObject : librariesObjects) {
                String libraryName = (String)AtlTypesProcessor.eGet(libraryObject, "name");
                if (libraryName == null || this.sourceManager.getLibraryLocations().get(libraryName) == null) continue;
                String location = (String)this.sourceManager.getLibraryLocations().get(libraryName);
                AtlSourceManager libraryManager = new AtlSourceManager();
                IFile file = (IFile)ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(location));
                if (file == null || !file.isAccessible()) continue;
                if ("asm".equals(file.getFileExtension())) {
                    file = file.getProject().getParent().getFile(file.getFullPath().removeFileExtension().addFileExtension("atl"));
                }
                if (file == null || !file.isAccessible()) continue;
                try {
                    libraryManager.updateDataSource(file.getContents());
                    this.libraries.add(new LibraryType(file, libraryManager));
                }
                catch (IOException iOException) {
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
            Collection<EObject> helpers = this.getHelpersObjects();
            if (helpers != null) {
                for (EObject element : helpers) {
                    EObject definition;
                    if (!element.eClass().getName().equals("Helper") || (definition = (EObject)AtlTypesProcessor.eGet(element, "definition")) == null) continue;
                    EObject context = (EObject)AtlTypesProcessor.eGet(definition, "context_");
                    OclAnyType type = OclAnyType.getInstance();
                    if (context != null) {
                        EObject contextType = (EObject)AtlTypesProcessor.eGet(context, "context_");
                        type = OclAnyType.create(this.sourceManager, contextType);
                    } else {
                        type = this;
                    }
                    EObject f = (EObject)AtlTypesProcessor.eGet(definition, "feature");
                    if (f == null) continue;
                    if (f.eClass().getName().equals("Attribute")) {
                        this.addAttribute(type, Feature.createFromAttribute(this, f, type));
                        continue;
                    }
                    if (!f.eClass().getName().equals("Operation")) continue;
                    this.addHelper(type, Operation.createFromHelper(this, f, type));
                }
            }
        }
    }

    private void addAttribute(OclAnyType context, Feature attribute) {
        if (this.attributes == null) {
            this.attributes = new HashMap<OclAnyType, Set<Feature>>();
        }
        if (this.attributes.get(context) == null) {
            HashSet<Feature> contextAttributes = new HashSet<Feature>(attribute){
                {
                    this.add(feature);
                }
            };
            this.attributes.put(context, (Set<Feature>)contextAttributes);
        } else {
            this.attributes.get(context).add(attribute);
        }
    }

    public Set<Feature> getAttributes(OclAnyType type) {
        LinkedHashSet<Feature> res = new LinkedHashSet<Feature>();
        for (LibraryType library : this.libraries) {
            res.addAll(library.getAttributes(type));
        }
        if (this.attributes != null) {
            if (this.attributes.get(type) != null) {
                res.addAll((Collection<Feature>)this.attributes.get(type));
            }
            OclAnyType[] oclAnyTypeArray = type.getSupertypes();
            int n = oclAnyTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                OclAnyType supertype = oclAnyTypeArray[n2];
                res.addAll(this.getAttributes(supertype));
                ++n2;
            }
        }
        return res;
    }

    public Set<Feature> getAllAttributes() {
        LinkedHashSet<Feature> res = new LinkedHashSet<Feature>();
        if (this.attributes != null) {
            for (Collection collection : this.attributes.values()) {
                res.addAll(collection);
            }
        }
        return res;
    }

    public Set<Operation> getHelpers(OclAnyType type) {
        LinkedHashSet<Operation> res = new LinkedHashSet<Operation>();
        for (LibraryType library : this.libraries) {
            res.addAll(library.getHelpers(type));
        }
        if (this.helpers != null) {
            if (this.helpers.get(type) != null) {
                res.addAll((Collection<Operation>)this.helpers.get(type));
            }
            OclAnyType[] oclAnyTypeArray = type.getSupertypes();
            int n = oclAnyTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                OclAnyType supertype = oclAnyTypeArray[n2];
                res.addAll(this.getHelpers(supertype));
                ++n2;
            }
        }
        return res;
    }

    public Set<Operation> getAllHelpers() {
        LinkedHashSet<Operation> res = new LinkedHashSet<Operation>();
        if (this.helpers != null) {
            for (Collection collection : this.helpers.values()) {
                res.addAll(collection);
            }
        }
        return res;
    }

    public AtlSourceManager getSourceManager() {
        return this.sourceManager;
    }

    public static UnitType create(IFile file, AtlSourceManager manager) {
        if (file != null && manager != null) {
            switch (manager.getATLFileType()) {
                case 1: {
                    return new ModuleType(file, manager);
                }
                case 4: {
                    return new LibraryType(file, manager);
                }
                case 3: {
                    return new QueryType(file, manager);
                }
            }
        }
        return new ModuleType(null, null);
    }
}

