/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class ReaderInputStream
extends InputStream {
    private static final int MASK = 255;
    private final Charset charset;
    private Reader reader;
    private CharBuffer chars = CharBuffer.allocate(8192);
    private ByteBuffer bytes;

    public ReaderInputStream(Reader reader, String encoding) throws IOException {
        this.reader = reader;
        this.charset = encoding == null ? StandardCharsets.UTF_8 : Charset.forName(encoding);
    }

    public ReaderInputStream(Reader reader) throws IOException {
        this(reader, null);
    }

    @Override
    public int available() throws IOException {
        this.checkClosed();
        this.ensureBytes();
        if (this.bytes == null) {
            return 0;
        }
        return this.bytes.remaining();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int toRead;
        this.checkClosed();
        if (len == 0) {
            return 0;
        }
        this.ensureBytes();
        if (this.bytes == null) {
            return -1;
        }
        int count = 0;
        do {
            this.ensureBytes();
            if (this.bytes == null) break;
            toRead = Math.min(this.bytes.remaining(), len - count);
            this.bytes.get(b, off + count, toRead);
        } while ((count += toRead) < len);
        return count;
    }

    @Override
    public int read() throws IOException {
        this.checkClosed();
        this.ensureBytes();
        if (this.bytes == null) {
            return -1;
        }
        return this.bytes.get() & 0xFF;
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
            this.bytes = null;
            this.chars = null;
        }
    }

    private void ensureBytes() throws IOException {
        if (this.bytes == null || !this.bytes.hasRemaining()) {
            this.checkClosed();
            CharBuffer buffer = this.chars;
            ((Buffer)buffer).rewind();
            int count = this.reader.read(this.chars);
            if (count > 0) {
                ((Buffer)buffer).flip();
                this.bytes = this.charset.encode(this.chars);
            } else {
                this.bytes = null;
            }
        }
    }

    private void checkClosed() throws IOException {
        if (this.reader == null) {
            throw new IOException("Reader is closed");
        }
    }
}

