/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.search.ui.manager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.uml.search.ui.Messages;
import org.eclipse.papyrus.uml.search.ui.providers.ParticipantTypeAttribute;
import org.eclipse.papyrus.uml.search.ui.providers.ParticipantTypeElement;
import org.eclipse.papyrus.uml.search.ui.query.PapyrusAdvancedQuery;
import org.eclipse.papyrus.uml.search.ui.query.PapyrusQuery;
import org.eclipse.papyrus.views.search.scope.ScopeEntry;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class PapyrusSearchTextManager {
    private Collection<ScopeEntry> fScopeEntries;
    private boolean fIsCaseSensitive;
    private boolean fIsRegularExpression;
    private String fQueryText;

    public PapyrusSearchTextManager(Collection<ScopeEntry> scopeEntries, boolean isCaseSensitive, boolean isRegularExpression, String queryText) {
        this.fScopeEntries = scopeEntries;
        this.fIsCaseSensitive = isCaseSensitive;
        this.fIsRegularExpression = isRegularExpression;
        this.fQueryText = queryText;
    }

    public ISearchQuery manageSimpleSearch(boolean searchAllStrings, Object[] umlMetaClassesArray) {
        if (this.fQueryText.length() == 0) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.PapyrusSearchPage_29, (String)Messages.PapyrusSearchPage_30);
            return null;
        }
        PapyrusQuery query = new PapyrusQuery(this.fQueryText, this.fIsCaseSensitive, this.fIsRegularExpression, this.fScopeEntries, umlMetaClassesArray, searchAllStrings);
        return query;
    }

    public ISearchQuery manageAdvancedSearch(HashMap<ParticipantTypeElement, List<ParticipantTypeAttribute>> participantsList, Object[] checkedElements, boolean searchForAllSter, boolean searchForAnySter) {
        List<ParticipantTypeElement> participantsToEvaluate = this.getParticipantsToEvaluate(participantsList);
        if (participantsToEvaluate.size() == 0) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.PapyrusSearchPage_31, (String)Messages.PapyrusSearchPage_32);
            return null;
        }
        if (this.fQueryText.length() == 0) {
            Object[] objectArray = checkedElements;
            int n = checkedElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object participantChecked = objectArray[n2];
                if (participantChecked instanceof ParticipantTypeAttribute) {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.PapyrusSearchPage_33, (String)Messages.PapyrusSearchPage_34);
                    return null;
                }
                ++n2;
            }
        }
        PapyrusAdvancedQuery query = new PapyrusAdvancedQuery(this.fQueryText, this.fIsCaseSensitive, this.fIsRegularExpression, this.fScopeEntries, participantsToEvaluate.toArray(), searchForAllSter, searchForAnySter);
        return query;
    }

    private List<ParticipantTypeElement> getParticipantsToEvaluate(HashMap<ParticipantTypeElement, List<ParticipantTypeAttribute>> participantsList) {
        ArrayList<ParticipantTypeElement> participantsToEvaluate = new ArrayList<ParticipantTypeElement>();
        for (ParticipantTypeElement element : participantsList.keySet()) {
            if (!element.isChecked()) continue;
            participantsToEvaluate.add(element);
            for (ParticipantTypeAttribute attributesToEvaluate : participantsList.get(element)) {
                if (!attributesToEvaluate.isChecked()) continue;
                participantsToEvaluate.add(attributesToEvaluate);
            }
        }
        return participantsToEvaluate;
    }
}

