/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.helper;

import java.util.Arrays;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.IdentityCommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.CreateRelationshipCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.papyrus.uml.service.types.helper.ElementEditHelper;
import org.eclipse.uml2.uml.DirectedRelationship;
import org.eclipse.uml2.uml.UMLPackage;

public abstract class DirectedRelationshipEditHelper
extends ElementEditHelper {
    protected abstract EReference getSourceReference();

    protected abstract EReference getTargetReference();

    protected abstract boolean canCreate(EObject var1, EObject var2);

    protected ICommand getCreateRelationshipCommand(CreateRelationshipRequest req) {
        boolean noSourceAndTarget;
        EObject source = req.getSource();
        EObject target = req.getTarget();
        boolean noSourceOrTarget = source == null || target == null;
        boolean bl = noSourceAndTarget = source == null && target == null;
        if (!noSourceAndTarget && !this.canCreate(source, target)) {
            return UnexecutableCommand.INSTANCE;
        }
        if (noSourceOrTarget && !noSourceAndTarget) {
            return IdentityCommand.INSTANCE;
        }
        if (req.getContainer() == null || !req.getContainer().eClass().getEAllReferences().contains((Object)req.getContainmentFeature()) || req.getContainmentFeature() == null) {
            EObject targetPackage;
            EObject sourcePackage;
            EObject proposedContainer = EMFCoreUtil.getLeastCommonContainer(Arrays.asList(source, target), (EClass)UMLPackage.eINSTANCE.getPackage());
            if (proposedContainer == null && !this.isReadOnly(sourcePackage = EMFCoreUtil.getContainer((EObject)source, (EClass)UMLPackage.eINSTANCE.getPackage()))) {
                proposedContainer = sourcePackage;
            }
            if (proposedContainer == null && !this.isReadOnly(targetPackage = EMFCoreUtil.getContainer((EObject)target, (EClass)UMLPackage.eINSTANCE.getPackage()))) {
                proposedContainer = targetPackage;
            }
            if (proposedContainer == null) {
                return UnexecutableCommand.INSTANCE;
            }
            req.setContainer(proposedContainer);
        }
        return new CreateRelationshipCommand(req);
    }

    protected boolean isReadOnly(EObject eObject) {
        EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)eObject);
        boolean isReadOnly = eObject.eResource() != null && editingDomain.isReadOnly(eObject.eResource());
        return isReadOnly;
    }

    protected Object getSourceObject(ConfigureRequest req) {
        Object result = null;
        if (this.getSourceReference().getUpperBound() != 1) {
            BasicEList objects = new BasicEList();
            objects.add((Object)((EObject)req.getParameter("CreateRelationshipRequest.source")));
            result = objects;
        } else {
            result = req.getParameter("CreateRelationshipRequest.source");
        }
        return result;
    }

    protected Object getTargetObject(ConfigureRequest req) {
        Object result = null;
        if (this.getTargetReference().getUpperBound() != 1) {
            BasicEList objects = new BasicEList();
            objects.add((Object)((EObject)req.getParameter("CreateRelationshipRequest.target")));
            result = objects;
        } else {
            result = req.getParameter("CreateRelationshipRequest.target");
        }
        return result;
    }

    @Override
    protected ICommand getConfigureCommand(ConfigureRequest req) {
        return CompositeCommand.compose((ICommand)this.getConfigureSourcesAndTargetsCommand(req), (ICommand)super.getConfigureCommand(req));
    }

    protected ICommand getConfigureSourcesAndTargetsCommand(final ConfigureRequest req) {
        return new ConfigureElementCommand(req){

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                DirectedRelationship element = (DirectedRelationship)req.getElementToConfigure();
                if (req.getParameter("CreateRelationshipRequest.source") != null) {
                    element.eSet((EStructuralFeature)DirectedRelationshipEditHelper.this.getSourceReference(), DirectedRelationshipEditHelper.this.getSourceObject(req));
                }
                if (req.getParameter("CreateRelationshipRequest.target") != null) {
                    element.eSet((EStructuralFeature)DirectedRelationshipEditHelper.this.getTargetReference(), DirectedRelationshipEditHelper.this.getTargetObject(req));
                }
                return CommandResult.newOKCommandResult((Object)element);
            }
        };
    }
}

