/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.ast.nodes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ITypeHierarchy;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.evaluation.types.MultiTypeType;
import org.eclipse.dltk.evaluation.types.SimpleType;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.core.ast.nodes.BindingResolver;
import org.eclipse.php.core.ast.nodes.IMethodBinding;
import org.eclipse.php.core.ast.nodes.ITypeBinding;
import org.eclipse.php.core.ast.nodes.IVariableBinding;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.typeinference.PHPClassType;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.typeinference.evaluators.PHPTraitType;

public class TypeBinding
implements ITypeBinding {
    private IEvaluatedType type;
    private IModelElement[] elements;
    private BindingResolver resolver;
    private IType[] superTypes;
    private ITypeBinding superClass;
    private ITypeBinding[] interfaces;
    private IVariableBinding[] fields;
    private IMethodBinding[] methods;
    private Map<IType, ITypeHierarchy> hierarchy = new HashMap<IType, ITypeHierarchy>();

    public TypeBinding(BindingResolver resolver, IEvaluatedType type, IModelElement[] elements) {
        this.resolver = resolver;
        this.type = type;
        if (ArrayUtils.isNotEmpty((Object[])elements)) {
            int length = elements.length;
            this.elements = new IModelElement[length];
            System.arraycopy(elements, 0, this.elements, 0, length);
        } else {
            this.elements = new IModelElement[0];
        }
    }

    public TypeBinding(BindingResolver resolver, IEvaluatedType type, IModelElement element) {
        this.resolver = resolver;
        this.type = type;
        this.elements = element != null ? new IModelElement[]{element} : new IModelElement[0];
    }

    @Override
    public ITypeBinding createArrayType(int dimension) {
        return null;
    }

    @Override
    public String getBinaryName() {
        if (this.isUnknown() || this.isAmbiguous()) {
            return null;
        }
        return this.elements[0].getHandleIdentifier();
    }

    @Override
    public ITypeBinding getComponentType() {
        if (!this.isArray()) {
            return null;
        }
        return null;
    }

    @Override
    public IVariableBinding[] getDeclaredFields() {
        if (this.isUnknown()) {
            return new IVariableBinding[0];
        }
        if (this.fields == null) {
            if (this.isClass()) {
                ArrayList<IVariableBinding> variableBindings = new ArrayList<IVariableBinding>();
                IModelElement[] iModelElementArray = this.elements;
                int n = this.elements.length;
                int n2 = 0;
                while (n2 < n) {
                    block9: {
                        IModelElement element = iModelElementArray[n2];
                        IType type = (IType)element;
                        try {
                            IField[] fields = type.getFields();
                            int i = 0;
                            while (i < fields.length) {
                                IVariableBinding variableBinding = this.resolver.getVariableBinding(fields[i]);
                                if (variableBinding != null) {
                                    variableBindings.add(variableBinding);
                                }
                                ++i;
                            }
                        }
                        catch (ModelException e) {
                            if (!DLTKCore.DEBUG) break block9;
                            e.printStackTrace();
                        }
                    }
                    ++n2;
                }
                this.fields = variableBindings.toArray(new IVariableBinding[variableBindings.size()]);
            } else {
                this.fields = new IVariableBinding[0];
            }
        }
        return this.fields;
    }

    @Override
    public IMethodBinding[] getDeclaredMethods() {
        if (this.isUnknown()) {
            return new IMethodBinding[0];
        }
        if (this.methods == null) {
            if (this.isClass() || this.isTrait()) {
                ArrayList<IMethodBinding> methodBindings = new ArrayList<IMethodBinding>();
                IModelElement[] iModelElementArray = this.elements;
                int n = this.elements.length;
                int n2 = 0;
                while (n2 < n) {
                    block9: {
                        IModelElement element = iModelElementArray[n2];
                        IType type = (IType)element;
                        try {
                            IMethod[] methods = type.getMethods();
                            if (methods != null) {
                                int i = 0;
                                while (i < methods.length) {
                                    IMethodBinding methodBinding = this.resolver.getMethodBinding(methods[i]);
                                    methodBindings.add(methodBinding);
                                    ++i;
                                }
                            }
                        }
                        catch (ModelException e) {
                            if (!DLTKCore.DEBUG) break block9;
                            e.printStackTrace();
                        }
                    }
                    ++n2;
                }
                this.methods = methodBindings.toArray(new IMethodBinding[methodBindings.size()]);
            } else {
                this.methods = new IMethodBinding[0];
            }
        }
        return this.methods;
    }

    @Override
    public int getModifiers() {
        this.isClass();
        return -1;
    }

    @Override
    public int getDimensions() {
        return 0;
    }

    @Override
    public ITypeBinding getElementType() {
        if (this.elements == null || this.elements.length != 1) {
            return null;
        }
        return null;
    }

    @Override
    public ITypeBinding[] getInterfaces() {
        if (this.isUnknown()) {
            return new ITypeBinding[0];
        }
        if (this.interfaces == null) {
            IType[] types = this.getSuperTypes();
            LinkedList<ITypeBinding> interfaces = new LinkedList<ITypeBinding>();
            IType[] iTypeArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                block6: {
                    IType type = iTypeArray[n2];
                    try {
                        if (PHPFlags.isInterface((int)type.getFlags())) {
                            interfaces.add(this.resolver.getTypeBinding(type));
                        }
                    }
                    catch (ModelException e) {
                        if (!DLTKCore.DEBUG) break block6;
                        e.printStackTrace();
                    }
                }
                ++n2;
            }
            this.interfaces = interfaces.toArray(new ITypeBinding[interfaces.size()]);
        }
        return this.interfaces;
    }

    @Override
    public String getName() {
        return this.isUnknown() ? null : this.type.getTypeName();
    }

    @Override
    public IEvaluatedType getEvaluatedType() {
        return this.type;
    }

    protected IType[] getSuperTypes() {
        if (this.superTypes == null) {
            if (ArrayUtils.isNotEmpty((Object[])this.elements)) {
                HashSet<String> superTypeNames = new HashSet<String>();
                IModelElement[] iModelElementArray = this.elements;
                int n = this.elements.length;
                int n2 = 0;
                while (n2 < n) {
                    block14: {
                        IModelElement element = iModelElementArray[n2];
                        IType type = (IType)element;
                        try {
                            String[] superClassNames = type.getSuperClasses();
                            if (superClassNames != null) {
                                String[] stringArray = superClassNames;
                                int n3 = superClassNames.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    String name = stringArray[n4];
                                    if (!superTypeNames.contains(name)) {
                                        superTypeNames.add(name);
                                    }
                                    ++n4;
                                }
                            }
                        }
                        catch (CoreException e) {
                            if (!DLTKCore.DEBUG) break block14;
                            e.printStackTrace();
                        }
                    }
                    ++n2;
                }
                ArrayList<IType> typeList = new ArrayList<IType>();
                List<IModelElement> elementList = Arrays.asList(this.elements);
                for (String superTypeName : superTypeNames) {
                    try {
                        Collection<IType> types;
                        ISourceModule sourceModule = (ISourceModule)this.elements[0].getAncestor(5);
                        String typeName = PHPModelUtils.extractElementName(superTypeName);
                        String nameSpace = PHPModelUtils.extractNameSpaceName(superTypeName);
                        if (nameSpace == null) {
                            nameSpace = "<g>";
                        }
                        if ((types = this.resolver.getModelAccessCache().getClassesOrInterfaces(sourceModule, typeName, nameSpace, null)) == null) continue;
                        for (IType type : types) {
                            if (elementList.contains(type)) continue;
                            typeList.add(type);
                        }
                    }
                    catch (ModelException e) {
                        if (!DLTKCore.DEBUG) continue;
                        e.printStackTrace();
                    }
                }
                this.superTypes = typeList.size() > 0 ? typeList.toArray(new IType[typeList.size()]) : new IType[0];
            } else {
                this.superTypes = new IType[0];
            }
        }
        return this.superTypes;
    }

    @Override
    public ITypeBinding getSuperclass() {
        if (this.isUnknown()) {
            return null;
        }
        if (this.superClass == null) {
            IType[] types = this.getSuperTypes();
            LinkedList<IType> superClasses = new LinkedList<IType>();
            IType[] iTypeArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                block6: {
                    IType type = iTypeArray[n2];
                    try {
                        if (!PHPFlags.isInterface((int)type.getFlags())) {
                            superClasses.add(type);
                        }
                    }
                    catch (ModelException e) {
                        if (!DLTKCore.DEBUG) break block6;
                        e.printStackTrace();
                    }
                }
                ++n2;
            }
            this.superClass = this.resolver.getTypeBinding(superClasses.toArray(new IType[superClasses.size()]));
        }
        return this.superClass;
    }

    @Override
    public ITypeBinding getTypeDeclaration() {
        if (this.elements.length > 0) {
            return this.resolver.getTypeBinding((IType)this.elements[0]);
        }
        return null;
    }

    @Override
    public boolean isArray() {
        return this.type instanceof MultiTypeType;
    }

    @Override
    public boolean isClass() {
        if (this.isUnknown()) {
            return false;
        }
        return this.type.getClass() == PHPClassType.class;
    }

    @Override
    public boolean isTrait() {
        if (this.isUnknown()) {
            return false;
        }
        return this.type.getClass() == PHPTraitType.class;
    }

    @Override
    public boolean isInterface() {
        if (this.isUnknown()) {
            return false;
        }
        boolean result = true;
        IModelElement[] iModelElementArray = this.elements;
        int n = this.elements.length;
        int n2 = 0;
        while (n2 < n) {
            block4: {
                IModelElement element = iModelElementArray[n2];
                IType member = (IType)element;
                try {
                    result &= (member.getFlags() & 8) != 0;
                }
                catch (ModelException e) {
                    if (!DLTKCore.DEBUG) break block4;
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        return result;
    }

    @Override
    public boolean isNullType() {
        if (this.type instanceof SimpleType) {
            return ((SimpleType)this.type).getType() == 8;
        }
        return false;
    }

    @Override
    public boolean isPrimitive() {
        return this.type instanceof SimpleType && !this.isNullType();
    }

    @Override
    public boolean isSubTypeCompatible(ITypeBinding otherType) {
        if (otherType == null || ArrayUtils.isEmpty((Object[])this.elements)) {
            return false;
        }
        boolean isSubTypeCompatible = false;
        IModelElement[] iModelElementArray = this.elements;
        int n = this.elements.length;
        int n2 = 0;
        while (n2 < n) {
            block9: {
                IType type;
                block8: {
                    IModelElement element = iModelElementArray[n2];
                    type = (IType)element;
                    if (!ArrayUtils.isEmpty((Object[])type.getSuperClasses())) break block8;
                    return false;
                }
                try {
                    IModelElement[] otherElements;
                    ITypeHierarchy supertypeHierarchy = this.hierarchy.get(type);
                    if (supertypeHierarchy == null) {
                        supertypeHierarchy = type.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
                        this.hierarchy.put(type, supertypeHierarchy);
                    }
                    if ((otherElements = otherType.getPHPElements()) == null) break block9;
                    IModelElement[] iModelElementArray2 = otherElements;
                    int n3 = otherElements.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IModelElement modelElement = iModelElementArray2[n4];
                        if (modelElement instanceof IType && supertypeHierarchy.contains((IType)modelElement)) {
                            isSubTypeCompatible = true;
                            break;
                        }
                        ++n4;
                    }
                }
                catch (ModelException e) {
                    if (!DLTKCore.DEBUG) break block9;
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        return isSubTypeCompatible;
    }

    @Override
    public String getKey() {
        if (this.isUnknown() || this.isAmbiguous()) {
            return null;
        }
        return this.elements[0].getHandleIdentifier();
    }

    @Override
    public int getKind() {
        return 2;
    }

    @Override
    public IModelElement getPHPElement() {
        if (this.isUnknown() || this.isAmbiguous()) {
            return null;
        }
        return this.elements[0];
    }

    @Override
    public boolean isDeprecated() {
        return false;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof TypeBinding)) {
            return false;
        }
        TypeBinding otherBinding = (TypeBinding)other;
        if (!this.type.equals(otherBinding.type)) {
            return false;
        }
        if (this.elements == null) {
            return otherBinding.elements == null;
        }
        if (this.elements.length != otherBinding.elements.length) {
            return false;
        }
        int i = 0;
        while (i < this.elements.length) {
            boolean hasEqual = false;
            int j = 0;
            while (j < otherBinding.elements.length) {
                if (this.elements[i].equals(otherBinding.elements[j])) {
                    hasEqual = true;
                    break;
                }
                ++j;
            }
            if (!hasEqual) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean isAmbiguous() {
        return !this.isUnknown() && this.elements.length != 1;
    }

    @Override
    public boolean isUnknown() {
        return this.elements == null && !this.isPrimitive() && !this.isNullType() && !this.isArray();
    }

    @Override
    public List<IType> getTraitList(boolean isMethod, String classMemberName, boolean includeSuper) {
        LinkedList<IType> result = new LinkedList<IType>();
        if (ArrayUtils.isEmpty((Object[])this.elements)) {
            return result;
        }
        IModelElement[] iModelElementArray = this.elements;
        int n = this.elements.length;
        int n2 = 0;
        while (n2 < n) {
            IModelElement type = iModelElementArray[n2];
            IType trait = this.getTrait((IType)type, isMethod, classMemberName);
            if (trait != null) {
                result.add(trait);
            }
            ++n2;
        }
        if (includeSuper) {
            iModelElementArray = this.elements;
            n = this.elements.length;
            n2 = 0;
            while (n2 < n) {
                block10: {
                    IModelElement element = iModelElementArray[n2];
                    IType type = (IType)element;
                    try {
                        IType trait;
                        if (ArrayUtils.isEmpty((Object[])type.getSuperClasses()) || PHPFlags.isTrait(type.getFlags())) {
                            return result;
                        }
                        ITypeHierarchy supertypeHierarchy = this.hierarchy.get(type);
                        if (supertypeHierarchy == null) {
                            supertypeHierarchy = type.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
                            this.hierarchy.put(type, supertypeHierarchy);
                        }
                        if ((trait = this.getTrait(type, isMethod, classMemberName)) != null) {
                            result.add(trait);
                        }
                    }
                    catch (ModelException e) {
                        if (!DLTKCore.DEBUG) break block10;
                        e.printStackTrace();
                    }
                }
                ++n2;
            }
        }
        return result;
    }

    private IType getTrait(IType type, boolean isMethod, String classMemberName) {
        if (type != null) {
            try {
                Object[] members = isMethod ? PHPModelUtils.getTypeMethod(type, classMemberName, true) : PHPModelUtils.getTypeField(type, classMemberName, true);
                IMethod[] iMethodArray = members;
                int n = members.length;
                int n2 = 0;
                while (n2 < n) {
                    IMethod member = iMethodArray[n2];
                    IType declaringType = member.getDeclaringType();
                    if (PHPFlags.isTrait(declaringType.getFlags())) {
                        return declaringType;
                    }
                    ++n2;
                }
            }
            catch (ModelException modelException) {}
        }
        return null;
    }

    @Override
    public IModelElement[] getPHPElements() {
        return this.elements;
    }
}

