/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.ui;

import java.util.BitSet;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ptp.debug.core.TaskSet;
import org.eclipse.ptp.internal.debug.ui.PDebugUIUtils;
import org.eclipse.ptp.internal.debug.ui.messages.Messages;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class PInstructionPointerAnnotation2 {
    private Annotation annotation = null;
    private IAnnotationModel annotationModel = null;
    private TaskSet tasks = null;
    private Position position = null;
    private IResource file = null;
    private IMarker marker = null;
    private String type = null;

    public PInstructionPointerAnnotation2(IResource file, String type, Position position, IAnnotationModel annotationModel) {
        this.file = file;
        this.type = type;
        this.position = position;
        this.annotationModel = annotationModel;
        this.addAnnotationToModel();
    }

    public void addAnnotationToModel() {
        this.marker = this.createMarker();
        this.annotation = this.isMarkerExists() ? new MarkerAnnotation(this.marker) : new Annotation(this.type, false, "");
        this.annotation.markDeleted(false);
        this.annotationModel.addAnnotation(this.annotation, this.position);
    }

    public void addTasks(TaskSet aTasks) {
        if (this.tasks == null) {
            this.tasks = aTasks.copy();
        }
        if (this.tasks.taskSize() < aTasks.taskSize()) {
            aTasks.or((BitSet)this.tasks);
            this.tasks = aTasks.copy();
        } else {
            this.tasks.or((BitSet)aTasks);
        }
    }

    public boolean contains(TaskSet aTasks) {
        return this.tasks.intersects((BitSet)aTasks);
    }

    public int[] containTasks(TaskSet aTasks) {
        aTasks.and((BitSet)this.tasks);
        return aTasks.toArray();
    }

    public IAnnotationModel getAnnotationModel() {
        return this.annotationModel;
    }

    public IResource getMakerResource() {
        return this.file;
    }

    public Position getPosition() {
        return this.position;
    }

    public TaskSet getTasks() {
        return this.tasks;
    }

    public String getType() {
        return this.type;
    }

    public boolean isEmpty() {
        return this.tasks.isEmpty();
    }

    public boolean isMarkDeleted() {
        return this.annotation == null || this.annotation.isMarkedDeleted();
    }

    public void removeAnnotation() {
        if (this.isMarkerExists()) {
            try {
                this.marker.delete();
                this.marker = null;
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        this.annotation.setText("");
        this.annotation.markDeleted(true);
        this.annotationModel.removeAnnotation(this.annotation);
    }

    public void removeTasks(TaskSet aTasks) {
        this.tasks.andNot((BitSet)aTasks);
    }

    public void setMessage(boolean isRegister) {
        int[] tasks = this.getTasks().toArray();
        if (tasks.length == 0) {
            this.removeAnnotation();
            return;
        }
        String msg = Messages.PInstructionPointerAnnotation2_0;
        if (!isRegister && tasks.length == 1) {
            msg = Messages.PInstructionPointerAnnotation2_1;
        } else if (isRegister && tasks.length > 1) {
            msg = Messages.PInstructionPointerAnnotation2_2;
        } else if (!isRegister && tasks.length > 1) {
            msg = Messages.PInstructionPointerAnnotation2_3;
        }
        msg = String.valueOf(msg) + PDebugUIUtils.arrayToString(tasks);
        this.setMessage(msg);
    }

    public void setTasks(TaskSet tasks) {
        this.tasks = tasks;
    }

    public void setType(String type) {
        this.type = type;
        this.annotation.setType(type);
    }

    private IMarker createMarker() {
        if (this.file != null && this.file.exists()) {
            try {
                return this.file.createMarker(this.type);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return null;
    }

    private boolean isMarkerExists() {
        return this.marker != null && this.marker.exists();
    }

    private void setMessage(String message) {
        if (this.isMarkerExists()) {
            try {
                this.marker.setAttribute("message", (Object)message);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        this.annotation.setText(message);
    }
}

